/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeZonesService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpAliEcsZoneBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpAliPubEcsResourcesInfoBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeZonesReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeZonesRspBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsAliHostZoneQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostZoneQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostZoneQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostZoneQueryAbilityRspZoneBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.config.redis.RsCacheManager;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsAliHostZoneQueryAbilityService"})
public class RsAliHostZoneQueryAbilityServiceImpl
implements RsAliHostZoneQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsAliHostZoneQueryAbilityServiceImpl.class);
    @Autowired
    private McmpCloudSerDescribeZonesService mcmpCloudSerDescribeZonesService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsCacheManager rsCacheManager;

    @PostMapping(value={"queryZone"})
    public RsAliHostZoneQueryAbilityRspBo queryZone(@RequestBody RsAliHostZoneQueryAbilityReqBo reqBo) {
        RsAliHostZoneQueryAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsAliHostZoneQueryAbilityRspBo.class);
        String validateArgStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            return RsRspBoUtil.genFailedBo(RsAliHostZoneQueryAbilityRspBo.class, "\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr, "8887");
        }
        if (1L == reqBo.getPlatformId() && reqBo.getPayType() == null) {
            return RsRspBoUtil.genFailedBo(RsAliHostZoneQueryAbilityRspBo.class, "\u516c\u6709\u4e91\u5fc5\u987b\u8981\u4f20\u5165\u4ed8\u8d39\u7c7b\u578b");
        }
        RsQueryAliParamAtomReqBo qryParam = new RsQueryAliParamAtomReqBo();
        qryParam.setAccountId(reqBo.getAccountId());
        qryParam.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo paramAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(qryParam);
        if (!"0000".equals(paramAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsAliHostZoneQueryAbilityRspBo.class, paramAtomRspBo.getRespDesc(), paramAtomRspBo.getRespCode());
        }
        String cacheKey = "ALI_ZONE_CACHE_" + reqBo.getPlatformId() + "_" + (reqBo.getPayType() == null ? "null" : reqBo.getPayType()) + "_" + reqBo.getRegionId();
        RsAliHostZoneQueryAbilityRspBo object = this.rsCacheManager.getObject(cacheKey, RsAliHostZoneQueryAbilityRspBo.class);
        if (object != null) {
            return object;
        }
        String intCloud = RsInterfaceUtil.convertCloudType(reqBo.getPlatformId());
        McmpCloudSerDescribeZonesReqBO queryZones = new McmpCloudSerDescribeZonesReqBO();
        queryZones.setCloudType(intCloud);
        if (1L == reqBo.getPlatformId()) {
            queryZones.setInstanceChargeType(RsInterfaceUtil.convertAliHostPayType(reqBo.getPayType()));
        }
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)queryZones);
        queryZones.setRegionId(reqBo.getRegionId());
        log.debug("\u67e5\u8be2\u533a\u57df-\u53ef\u7528\u533a \u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSON((Object)queryZones));
        McmpCloudSerDescribeZonesRspBO mcmpCloudSerDescribeZonesRspBO = this.mcmpCloudSerDescribeZonesService.describeZones(queryZones);
        log.debug("\u67e5\u8be2\u533a\u57df-\u53ef\u7528\u533a \u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSON((Object)mcmpCloudSerDescribeZonesRspBO));
        if (!"0000".equals(mcmpCloudSerDescribeZonesRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsAliHostZoneQueryAbilityRspBo.class, mcmpCloudSerDescribeZonesRspBO.getRespDesc(), mcmpCloudSerDescribeZonesRspBO.getRespCode());
        }
        ArrayList<RsAliHostZoneQueryAbilityRspZoneBo> zoneList = new ArrayList<RsAliHostZoneQueryAbilityRspZoneBo>();
        rspBo.setZones(zoneList);
        for (McmpAliEcsZoneBO zoneBO : mcmpCloudSerDescribeZonesRspBO.getRows()) {
            RsAliHostZoneQueryAbilityRspZoneBo zoneBo = new RsAliHostZoneQueryAbilityRspZoneBo();
            zoneList.add(zoneBo);
            zoneBo.setZoneID(zoneBO.getZoneId());
            zoneBo.setZoneName(zoneBO.getLocalName());
            TreeSet zoneSpecSet = new TreeSet();
            List availableResources = zoneBO.getAvailableResources();
            if (availableResources != null) {
                for (McmpAliPubEcsResourcesInfoBO availableResource : availableResources) {
                    zoneSpecSet.addAll(availableResource.getInstanceTypes());
                }
            }
            zoneBo.setAvailableSpec(zoneSpecSet);
        }
        this.rsCacheManager.set(cacheKey, rspBo);
        return rspBo;
    }
}

