/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.resource.ability.api.RsCloudHdEditAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsCloudHdEditAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCloudHdEditAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsSyncResourceInfoToTicketAtomService;
import com.tydic.mcmp.resource.atom.bo.RsSyncResourceInfoToTicketAtomReqBo;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Date;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsCloudHdEditAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsCloudHdEditAbilityService"})
public class RsCloudHdEditAbilityServiceImpl
implements RsCloudHdEditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsCloudHdEditAbilityServiceImpl.class);
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private RsSyncResourceInfoToTicketAtomService rsSyncResourceInfoToTicketAtomService;

    @PostMapping(value={"editCloudHd"})
    public RsCloudHdEditAbilityRspBo editCloudHd(@RequestBody RsCloudHdEditAbilityReqBo reqBo) {
        log.info("=================================\u4e91\u76d8\u4fee\u6539\u670d\u52a1 \u5f00\u59cb=======================================");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        RsCloudHdEditAbilityRspBo retBo = new RsCloudHdEditAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((CharSequence)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        RsInfoResourcePo qryPo = this.rsInfoResourceMapper.selectByPrimaryKey(reqBo.getResourceId());
        if (qryPo == null) {
            log.error("\u6839\u636e\u8d44\u6e90ID(" + reqBo.getResourceId() + ")\u672a\u67e5\u8be2\u5230\u6570\u636e");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u6839\u636e\u8d44\u6e90ID(" + reqBo.getResourceId() + ")\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return retBo;
        }
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        RsInfoResourcePo po = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)po);
        po.setUpdateTime(nowTime);
        int result = this.rsInfoResourceMapper.updateByPrimaryKeySelective(po);
        if (result < 1) {
            log.error("\u66f4\u65b0\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u66f4\u65b0\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return retBo;
        }
        this.syncResourceInfoToTicket(reqBo.getResourceId(), null, reqBo.getTicketNo());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        log.info("=================================\u4e91\u76d8\u4fee\u6539\u670d\u52a1 \u7ed3\u675f=======================================");
        log.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)retBo));
        return retBo;
    }

    private void syncResourceInfoToTicket(Long resourceId, Set<Long> resourceIds, String ticketNo) {
        RsSyncResourceInfoToTicketAtomReqBo rsSyncResourceInfoToTicketAtomReqBo = new RsSyncResourceInfoToTicketAtomReqBo();
        rsSyncResourceInfoToTicketAtomReqBo.setResourceId(resourceId);
        rsSyncResourceInfoToTicketAtomReqBo.setResourceIds(resourceIds);
        rsSyncResourceInfoToTicketAtomReqBo.setTicketNo(ticketNo);
        this.rsSyncResourceInfoToTicketAtomService.syncResourceInfoToTicket(rsSyncResourceInfoToTicketAtomReqBo);
    }
}

