/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.tydic.mcmp.resource.ability.api.RsPlatformRunResourceOverviewAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformRunResourceOverviewAbilityBo;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformRunResourceOverviewAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformRunResourceOverviewAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsResourceOverPlatformCountBo;
import com.tydic.mcmp.resource.dao.RsInfoPlatformMapper;
import com.tydic.mcmp.resource.dao.RsInfoServiceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPlatformPo;
import com.tydic.mcmp.resource.dao.po.RsServiceCountInfoPo;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsPlatformRunResourceOverviewAbilityService"})
public class RsPlatformRunResourceOverviewAbilityServiceImpl
implements RsPlatformRunResourceOverviewAbilityService {
    @Autowired
    private RsInfoServiceMapper rsInfoServiceMapper;
    @Autowired
    private RsInfoPlatformMapper rsInfoPlatformMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsPlatformRunResourceOverviewAbilityServiceImpl.class);

    @PostMapping(value={"getPlatformRunResourceOverview"})
    public RsPlatformRunResourceOverviewAbilityRspBo getPlatformRunResourceOverview(@RequestBody RsPlatformRunResourceOverviewAbilityReqBo reqBo) {
        RsPlatformRunResourceOverviewAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsPlatformRunResourceOverviewAbilityRspBo.class);
        ArrayList<RsPlatformRunResourceOverviewAbilityBo> rsPlatformRunResourceOverviewAbilityBos = new ArrayList<RsPlatformRunResourceOverviewAbilityBo>();
        try {
            List<RsServiceCountInfoPo> rsServiceCountInfoPos = this.rsInfoServiceMapper.queryServiceCount();
            if (!CollectionUtils.isEmpty(rsServiceCountInfoPos)) {
                for (RsServiceCountInfoPo rsServiceCountInfoPo : rsServiceCountInfoPos) {
                    RsPlatformRunResourceOverviewAbilityBo rsPlatformRunResourceOverviewAbilityBo = new RsPlatformRunResourceOverviewAbilityBo();
                    rsPlatformRunResourceOverviewAbilityBo.setServiceId(rsServiceCountInfoPo.getServiceId());
                    rsPlatformRunResourceOverviewAbilityBo.setServiceName(rsServiceCountInfoPo.getServiceName());
                    rsPlatformRunResourceOverviewAbilityBos.add(rsPlatformRunResourceOverviewAbilityBo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u670d\u52a1\u5931\u8d25");
            return rspBo;
        }
        if (!CollectionUtils.isEmpty(rsPlatformRunResourceOverviewAbilityBos)) {
            for (RsPlatformRunResourceOverviewAbilityBo rsPlatformRunResourceOverviewAbilityBo : rsPlatformRunResourceOverviewAbilityBos) {
                ArrayList<RsResourceOverPlatformCountBo> rsResourceOverPlatformCountBos = new ArrayList<RsResourceOverPlatformCountBo>();
                List<RsInfoPlatformPo> rsInfoPlatformPos = this.rsInfoPlatformMapper.queryStatisticsInfo(rsPlatformRunResourceOverviewAbilityBo.getServiceId());
                if (!CollectionUtils.isEmpty(rsInfoPlatformPos)) {
                    for (RsInfoPlatformPo rsInfoPlatformPo : rsInfoPlatformPos) {
                        RsResourceOverPlatformCountBo rsResourceOverPlatformCountBo = new RsResourceOverPlatformCountBo();
                        rsResourceOverPlatformCountBo.setPlatformId(rsInfoPlatformPo.getPlatformId());
                        rsResourceOverPlatformCountBo.setPlatformName(rsInfoPlatformPo.getPlatformName());
                        rsResourceOverPlatformCountBo.setPlatformCount(rsInfoPlatformPo.getCount());
                        rsResourceOverPlatformCountBos.add(rsResourceOverPlatformCountBo);
                    }
                }
                rsPlatformRunResourceOverviewAbilityBo.setRsResourceOverPlatformCountBos(rsResourceOverPlatformCountBos);
            }
        }
        rspBo.setData(rsPlatformRunResourceOverviewAbilityBos);
        return rspBo;
    }
}

