/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeRegionsService;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeZonesService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpAliEcsZoneBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpAliPubEcsResourcesInfoBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeRegionsReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeRegionsRspBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeZonesReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeZonesRspBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerRegionsBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsRegionListQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsRegionListQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRegionListQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRegionListQueryAbilityRspRegionBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRegionListQueryAbilityRspZoneBo;
import com.tydic.mcmp.resource.atom.api.RsPlatformAccountParamQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsPlatformAccountParamQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsPlatformAccountParamQueryAtomRspBo;
import com.tydic.mcmp.resource.config.redis.RsCacheManager;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsRegionListQueryAbilityService"})
public class RsRegionListQueryAbilityServiceImpl
implements RsRegionListQueryAbilityService {
    private static final Logger log = LogManager.getLogger(RsRegionListQueryAbilityServiceImpl.class);
    @Autowired
    private McmpCloudSerDescribeRegionsService mcmpCloudSerDescribeRegionsService;
    @Autowired
    private McmpCloudSerDescribeZonesService mcmpCloudSerDescribeZonesService;
    @Autowired
    private RsPlatformAccountParamQueryAtomService rsPlatformAccountParamQueryAtomService;
    @Autowired
    private RsCacheManager rsCacheManager;

    @PostMapping(value={"queryRegion"})
    public RsRegionListQueryAbilityRspBo queryRegion(@RequestBody RsRegionListQueryAbilityReqBo reqBo) {
        RsRegionListQueryAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsRegionListQueryAbilityRspBo.class);
        String validateArgStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            return RsRspBoUtil.genFailedBo(RsRegionListQueryAbilityRspBo.class, "\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr, "8887");
        }
        long cacheTime = 86400L;
        String cacheKey = "ALI_HOST_REGION_" + reqBo.getPlatformId() + "_" + reqBo.getPayType();
        RsRegionListQueryAbilityRspBo object = this.rsCacheManager.getObject(cacheKey, RsRegionListQueryAbilityRspBo.class);
        if (object != null) {
            return object;
        }
        RsPlatformAccountParamQueryAtomReqBo queryAccount = new RsPlatformAccountParamQueryAtomReqBo();
        queryAccount.setAccountId(reqBo.getAccountId());
        RsPlatformAccountParamQueryAtomRspBo queryAtomRspBo = this.rsPlatformAccountParamQueryAtomService.qryAccountParams(queryAccount);
        if (!"0000".equals(queryAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsRegionListQueryAbilityRspBo.class, queryAtomRspBo.getRespDesc(), queryAtomRspBo.getRespCode());
        }
        Map<String, String> paramMap = queryAtomRspBo.getParamMap();
        String intCloud = RsInterfaceUtil.convertCloudType(reqBo.getPlatformId());
        McmpCloudSerDescribeRegionsReqBO queryRegion = new McmpCloudSerDescribeRegionsReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryRegion);
        queryRegion.setCloudType(intCloud);
        if (1L == reqBo.getPlatformId()) {
            queryRegion.setInstanceChargeType(RsInterfaceUtil.convertAliHostPayType(reqBo.getPayType()));
        }
        this.setParam(paramMap, (McmpIntfReqBaseBO)queryRegion);
        log.debug("\u67e5\u8be2\u533a\u57df\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSON((Object)queryRegion));
        McmpCloudSerDescribeRegionsRspBO mcmpCloudSerDescribeRegionsRspBO = this.mcmpCloudSerDescribeRegionsService.describeRegions(queryRegion);
        log.debug("\u67e5\u8be2\u533a\u57df\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSON((Object)mcmpCloudSerDescribeRegionsRspBO));
        if (!"0000".equals(mcmpCloudSerDescribeRegionsRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsRegionListQueryAbilityRspBo.class, mcmpCloudSerDescribeRegionsRspBO.getRespDesc(), mcmpCloudSerDescribeRegionsRspBO.getRespCode());
        }
        ArrayList<RsRegionListQueryAbilityRspRegionBo> regionsList = new ArrayList<RsRegionListQueryAbilityRspRegionBo>();
        rspBo.setRegions(regionsList);
        McmpCloudSerDescribeZonesReqBO queryZones = new McmpCloudSerDescribeZonesReqBO();
        queryZones.setCloudType(intCloud);
        if (1L == reqBo.getPlatformId()) {
            queryZones.setInstanceChargeType(RsInterfaceUtil.convertAliHostPayType(reqBo.getPayType()));
        }
        this.setParam(paramMap, (McmpIntfReqBaseBO)queryZones);
        String statusNo = "soldOut";
        if (!CollectionUtils.isEmpty((Collection)mcmpCloudSerDescribeRegionsRspBO.getRows())) {
            for (McmpCloudSerRegionsBO regionBo : mcmpCloudSerDescribeRegionsRspBO.getRows()) {
                if (statusNo.equals(regionBo.getStatus())) continue;
                RsRegionListQueryAbilityRspRegionBo regionRspBo = new RsRegionListQueryAbilityRspRegionBo();
                regionsList.add(regionRspBo);
                BeanUtils.copyProperties((Object)regionBo, (Object)regionRspBo);
                regionRspBo.setRegionID(regionBo.getRegionId());
                regionRspBo.setRegionName(regionBo.getLocalName());
                ArrayList<RsRegionListQueryAbilityRspZoneBo> zoneList = new ArrayList<RsRegionListQueryAbilityRspZoneBo>();
                regionRspBo.setZones(zoneList);
                queryZones.setRegionId(regionBo.getRegionId());
                log.debug("\u67e5\u8be2\u533a\u57df-\u53ef\u7528\u533a \u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSON((Object)queryZones));
                McmpCloudSerDescribeZonesRspBO mcmpCloudSerDescribeZonesRspBO = this.mcmpCloudSerDescribeZonesService.describeZones(queryZones);
                log.debug("\u67e5\u8be2\u533a\u57df-\u53ef\u7528\u533a \u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSON((Object)mcmpCloudSerDescribeZonesRspBO));
                if (!"0000".equals(mcmpCloudSerDescribeZonesRspBO.getRespCode())) {
                    return RsRspBoUtil.genFailedBo(RsRegionListQueryAbilityRspBo.class, mcmpCloudSerDescribeZonesRspBO.getRespDesc(), mcmpCloudSerDescribeZonesRspBO.getRespCode());
                }
                for (McmpAliEcsZoneBO zoneBO : mcmpCloudSerDescribeZonesRspBO.getRows()) {
                    RsRegionListQueryAbilityRspZoneBo zoneRspBo = new RsRegionListQueryAbilityRspZoneBo();
                    zoneList.add(zoneRspBo);
                    zoneRspBo.setZoneID(zoneBO.getZoneId());
                    zoneRspBo.setZoneName(zoneBO.getLocalName());
                    TreeSet<String> zoneSpecSet = new TreeSet<String>();
                    List availableResources = zoneBO.getAvailableResources();
                    if (availableResources != null) {
                        for (McmpAliPubEcsResourcesInfoBO availableResource : availableResources) {
                            zoneSpecSet.addAll(availableResource.getInstanceTypes());
                        }
                    }
                    this.rsCacheManager.saveCpuSpec(reqBo.getPlatformId(), regionBo.getRegionId(), zoneBO.getZoneId(), zoneSpecSet, cacheTime);
                }
            }
        }
        this.rsCacheManager.set(cacheKey, rspBo, cacheTime);
        return rspBo;
    }

    private void setParam(Map<String, String> paramMap, McmpIntfReqBaseBO queryRegion) {
        queryRegion.setAccessKeyId(paramMap.get("AccessKeyId"));
        queryRegion.setAccessKeySecret(paramMap.get("AccessKeySecret"));
        queryRegion.setRegion(paramMap.get("AccountRegionId"));
        queryRegion.setEndpointPriv(paramMap.get("endpoint"));
        queryRegion.setProxyHost(paramMap.get("proxyHost"));
        queryRegion.setProxyPort(paramMap.get("proxyPort"));
    }

    private String validateReqArg(RsRegionListQueryAbilityReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getPlatformId())) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027platformId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return null;
    }
}

