/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.tydic.mcmp.resource.ability.api.RsVMwareSpecListQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsVMwareConfigDataBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVMwareSpecListQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVMwareSpecListQueryAbilityRspBo;
import com.tydic.mcmp.resource.atom.bo.RsInfoHostTemplateQueryAtomRspBo;
import com.tydic.mcmp.resource.common.bo.RsRelHostTemplateHdBo;
import com.tydic.mcmp.resource.common.bo.RsRelHostTemplateNetworkBo;
import com.tydic.mcmp.resource.dao.RsInfoHostTemplateMapper;
import com.tydic.mcmp.resource.dao.RsRelHostTemplateHdMapper;
import com.tydic.mcmp.resource.dao.RsRelHostTemplateNetworkMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHostTemplatePo;
import com.tydic.mcmp.resource.dao.po.RsRelHostTemplateHdPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostTemplateNetworkPo;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="rsVMwareSpecListQueryAbilityService")
public class RsVMwareSpecListQueryAbilityServiceImpl
implements RsVMwareSpecListQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHostTemplateMapper rsInfoHostTemplateMapper;
    @Autowired
    private RsRelHostTemplateHdMapper rsRelHostTemplateHdMapper;
    @Autowired
    private RsRelHostTemplateNetworkMapper rsRelHostTemplateNetworkMapper;

    public RsVMwareSpecListQueryAbilityRspBo queryVMwareSpecList(RsVMwareSpecListQueryAbilityReqBo reqBo) {
        this.LOGGER.info("-----------------------vmware\u66f4\u65b0 Ability\u670d\u52a1\u5f00\u59cb-----------------------");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsVMwareSpecListQueryAbilityRspBo rspBO = new RsVMwareSpecListQueryAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBO.setRespCode("4023");
            rspBO.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBO;
        }
        ArrayList<RsVMwareConfigDataBo> vMwareConfigDataBos = new ArrayList<RsVMwareConfigDataBo>();
        RsInfoHostTemplateQueryAtomRspBo hostTemplateQueryAtomRspBo = this.buildRsInfoHostTemplate(reqBo);
        if (CollectionUtils.isEmpty((Collection)hostTemplateQueryAtomRspBo.getRows())) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230VMWARE\u914d\u7f6e\u4fe1\u606f\uff1a");
            rspBO.setRespCode("1010");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230VMWARE\u914d\u7f6e\u4fe1\u606f");
            return rspBO;
        }
        for (RsInfoHostTemplatePo hostTemplatePo : hostTemplateQueryAtomRspBo.getRows()) {
            RsVMwareConfigDataBo rsVMwareConfigDataBo = new RsVMwareConfigDataBo();
            BeanUtils.copyProperties((Object)hostTemplatePo, (Object)rsVMwareConfigDataBo);
            List<RsRelHostTemplateHdBo> hostTemplateHDRsbBoList = this.buildRsInfoHostTemplateHD(hostTemplatePo);
            rsVMwareConfigDataBo.setRsInfoHostTemplateHDRsbBoList(hostTemplateHDRsbBoList);
            List<RsRelHostTemplateNetworkBo> hostTemplateNetworkRsbBoList = this.buildRsInfoHostNetworkTemplate(hostTemplatePo);
            rsVMwareConfigDataBo.setRsRelHostTemplateNetworkBoList(hostTemplateNetworkRsbBoList);
            vMwareConfigDataBos.add(rsVMwareConfigDataBo);
        }
        rspBO.setRsVMwareConfigDataBoList(vMwareConfigDataBos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public RsInfoHostTemplateQueryAtomRspBo buildRsInfoHostTemplate(RsVMwareSpecListQueryAbilityReqBo reqBo) {
        RsInfoHostTemplateQueryAtomRspBo rspBo = new RsInfoHostTemplateQueryAtomRspBo();
        ArrayList<RsInfoHostTemplatePo> hostTemplateRsbBoList = new ArrayList<RsInfoHostTemplatePo>();
        RsInfoHostTemplatePo rsInfoHostTemplatePo = new RsInfoHostTemplatePo();
        rsInfoHostTemplatePo.setCpuCores(reqBo.getCpuCores());
        rsInfoHostTemplatePo.setCpuNumber(reqBo.getCpuNumber());
        List<RsInfoHostTemplatePo> rsInfoHostTemplatePoList = this.rsInfoHostTemplateMapper.queryList(rsInfoHostTemplatePo);
        if (CollectionUtils.isNotEmpty(rsInfoHostTemplatePoList)) {
            for (RsInfoHostTemplatePo hostTemplatePo : rsInfoHostTemplatePoList) {
                RsInfoHostTemplatePo infoHostTemplatePo = new RsInfoHostTemplatePo();
                BeanUtils.copyProperties((Object)hostTemplatePo, (Object)infoHostTemplatePo);
                hostTemplateRsbBoList.add(infoHostTemplatePo);
            }
        }
        rspBo.setRows(hostTemplateRsbBoList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public List<RsRelHostTemplateNetworkBo> buildRsInfoHostNetworkTemplate(RsInfoHostTemplatePo reqBo) {
        ArrayList<RsRelHostTemplateNetworkBo> rsbBos = new ArrayList<RsRelHostTemplateNetworkBo>();
        RsRelHostTemplateNetworkPo hostTemplateNetworkPo = new RsRelHostTemplateNetworkPo();
        hostTemplateNetworkPo.setTemplateId(reqBo.getTemplateId());
        List<RsRelHostTemplateNetworkBo> templateNetworkBoList = this.rsRelHostTemplateNetworkMapper.selectList(hostTemplateNetworkPo);
        if (CollectionUtils.isNotEmpty(templateNetworkBoList)) {
            for (RsRelHostTemplateNetworkBo templateNetworkBo : templateNetworkBoList) {
                RsRelHostTemplateNetworkBo rsbBo = new RsRelHostTemplateNetworkBo();
                BeanUtils.copyProperties((Object)templateNetworkBo, (Object)rsbBo);
                rsbBos.add(rsbBo);
            }
        }
        return rsbBos;
    }

    public List<RsRelHostTemplateHdBo> buildRsInfoHostTemplateHD(RsInfoHostTemplatePo reqBo) {
        ArrayList<RsRelHostTemplateHdBo> templateHDRsbBoList = new ArrayList<RsRelHostTemplateHdBo>();
        RsRelHostTemplateHdPo rsRelHostTemplateHdPo = new RsRelHostTemplateHdPo();
        rsRelHostTemplateHdPo.setTemplateId(reqBo.getTemplateId());
        List<RsRelHostTemplateHdPo> hostTemplateHdPoList = this.rsRelHostTemplateHdMapper.queryAll(rsRelHostTemplateHdPo);
        if (CollectionUtils.isNotEmpty(hostTemplateHdPoList)) {
            for (RsRelHostTemplateHdPo templateHdPo : hostTemplateHdPoList) {
                RsRelHostTemplateHdBo templateHDRsbBo = new RsRelHostTemplateHdBo();
                BeanUtils.copyProperties((Object)templateHdPo, (Object)templateHDRsbBo);
                templateHDRsbBoList.add(templateHDRsbBo);
            }
        }
        return templateHDRsbBoList;
    }
}

