/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.resource.atom.api.RsHostOperLogListQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsHostOperLogListQueryAtomReqBo;
import com.tydic.mcmp.resource.common.bo.RsHostOpLogsQueryDataBo;
import com.tydic.mcmp.resource.dao.RsInfoHostOpLogsMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHostOpLogsPo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsHostOperLogListQueryAtomService")
public class RsHostOperLogListQueryAtomServiceImpl
implements RsHostOperLogListQueryAtomService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHostOpLogsMapper rsInfoHostOpLogsMapper;

    @Override
    public McmpRspPageBo<McmpRspPageDataBo<RsHostOpLogsQueryDataBo>> queryLogs(RsHostOperLogListQueryAtomReqBo reqBo) {
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo data = new McmpRspPageDataBo();
        retBo.setData((Object)data);
        ArrayList<RsHostOpLogsQueryDataBo> rows = new ArrayList<RsHostOpLogsQueryDataBo>();
        Page<RsInfoHostOpLogsPo> page = this.getPage(reqBo);
        RsInfoHostOpLogsPo logsPo = new RsInfoHostOpLogsPo();
        logsPo.setHostResourceId(Long.valueOf(reqBo.getHostResourceId()));
        List<RsInfoHostOpLogsPo> logs = this.rsInfoHostOpLogsMapper.selectPageByCondition(logsPo, page);
        if (CollectionUtils.isEmpty(logs)) {
            this.LOGGER.error("\u67e5\u8be2\u7528\u6237\u64cd\u4f5cESC\u8bb0\u5f55\u4e3a\u7a7a");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u67e5\u8be2\u7528\u6237\u64cd\u4f5cESC\u8bb0\u5f55\u4e3a\u7a7a");
            return retBo;
        }
        for (RsInfoHostOpLogsPo po : logs) {
            RsHostOpLogsQueryDataBo logBo = new RsHostOpLogsQueryDataBo();
            BeanUtils.copyProperties((Object)po, (Object)logBo);
            rows.add(logBo);
        }
        data.setRows(rows);
        data.setPageNo(reqBo.getPageNo());
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Page<RsInfoHostOpLogsPo> getPage(RsHostOperLogListQueryAtomReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)((Object)reqBo), (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

