/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerCreateDiskService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerCreateDiskReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerCreateDiskRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.api.RsSyncResourceInfoToTicketAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.atom.bo.RsSyncResourceInfoToTicketAtomReqBo;
import com.tydic.mcmp.resource.busi.api.RsCloudHdCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdCreateBusiRsp;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsCloudHdCreateBusiService")
public class RsCloudHdCreateBusiServiceImpl
implements RsCloudHdCreateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private McmpCloudSerCreateDiskService mcmpCloudSerCreateDiskService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsSyncResourceInfoToTicketAtomService rsSyncResourceInfoToTicketAtomService;

    public RsCloudHdCreateBusiRsp createHd(RsCloudHdCreateBusiReqBo reqBo) {
        int payType;
        this.LOGGER.info("\u4e91\u76d8\u521b\u5efa Busi\u670d\u52a1\uff1a" + reqBo);
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_SSD.equals(reqBo.getHdType())) {
            throw new McmpBusinessException("24009", "\u4e0d\u652f\u6301\u521b\u5efa\u6b64\u7c7b\u578b(1:local_ssd)\u7684\u4e91\u76d8");
        }
        if (StringUtils.isEmpty((CharSequence)reqBo.getZoneId()) && !StringUtils.isEmpty((CharSequence)reqBo.getInstanceId())) {
            payType = RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_MONTH;
        } else if (!StringUtils.isEmpty((CharSequence)reqBo.getZoneId()) && StringUtils.isEmpty((CharSequence)reqBo.getInstanceId())) {
            payType = RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_USAGE;
        } else {
            throw new McmpBusinessException("24009", "\u53ef\u7528\u533aID(zoneId)\u548c\u4e3b\u673a\u5b9e\u4f8bID\uff08instanceId\uff09\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        RsCloudHdCreateBusiRsp retBo = new RsCloudHdCreateBusiRsp();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)atomReqBo));
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u8d26\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
            throw new McmpBusinessException("24009", "\u67e5\u8be2\u8d26\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpCloudSerCreateDiskReqBO diskReqBo = new McmpCloudSerCreateDiskReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)diskReqBo);
        if (2L == reqBo.getPlatformId()) {
            diskReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            diskReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            diskReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            diskReqBo.setProxyHost(atomRetBo.getProxyHost());
            diskReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            diskReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            diskReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            diskReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        if (!StringUtils.isEmpty((CharSequence)reqBo.getRegionId())) {
            diskReqBo.setRegion(reqBo.getRegionId());
        }
        diskReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        diskReqBo.setSize(reqBo.getHdSize());
        diskReqBo.setDiskCategory(RsInterfaceUtil.convertAliHdType(reqBo.getHdType()));
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)diskReqBo));
        List<Long> resourceIds = this.invokeExtAndInsertData(reqBo, diskReqBo, payType);
        this.syncResourceInfoToTicket(null, new HashSet<Long>(resourceIds), reqBo.getTicketNo());
        retBo.setResourceIds(resourceIds);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void syncResourceInfoToTicket(Long resourceId, Set<Long> resourceIds, String ticketNo) {
        RsSyncResourceInfoToTicketAtomReqBo rsSyncResourceInfoToTicketAtomReqBo = new RsSyncResourceInfoToTicketAtomReqBo();
        rsSyncResourceInfoToTicketAtomReqBo.setResourceId(resourceId);
        rsSyncResourceInfoToTicketAtomReqBo.setResourceIds(resourceIds);
        rsSyncResourceInfoToTicketAtomReqBo.setTicketNo(ticketNo);
        this.rsSyncResourceInfoToTicketAtomService.syncResourceInfoToTicket(rsSyncResourceInfoToTicketAtomReqBo);
    }

    private List<Long> invokeExtAndInsertData(RsCloudHdCreateBusiReqBo reqBo, McmpCloudSerCreateDiskReqBO diskReqBo, int payType) {
        ArrayList<Long> resourceIds = new ArrayList<Long>();
        ArrayList<RsInfoHardDiskPo> hdPos = new ArrayList<RsInfoHardDiskPo>();
        ArrayList<RsInfoResourcePo> resourcePos = new ArrayList<RsInfoResourcePo>();
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        McmpCloudSerCreateDiskRspBO diskRetBo = null;
        for (int size = 0; size < reqBo.getCreateNumbers(); ++size) {
            diskRetBo = this.mcmpCloudSerCreateDiskService.createDisk(diskReqBo);
            this.LOGGER.info("\u521b\u5efa\u4e91\u76d8\u5b9e\u4f8b\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)diskRetBo));
            if (!"0000".equals(diskRetBo.getRespCode())) {
                this.LOGGER.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u521b\u5efa\u4e91\u76d8\u5b9e\u4f8b\u5931\u8d25\uff1a" + diskRetBo.getRespCode());
                throw new McmpBusinessException("9000", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u521b\u5efa\u4e91\u76d8\u5b9e\u4f8b\u5931\u8d25\uff1a" + diskRetBo.getRespCode());
            }
            Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
            resourceIds.add(resourceId);
            RsInfoHardDiskPo hdPo = new RsInfoHardDiskPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)hdPo);
            hdPo.setInstanceId(diskRetBo.getDiskId());
            hdPo.setHdPayType(payType);
            hdPo.setHdResourceId(resourceId);
            hdPo.setHdProperty(RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_DATA);
            hdPo.setHdStatus(RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_STATUS_FREE);
            if (StringUtils.isEmpty((CharSequence)reqBo.getResourceName())) {
                hdPo.setHdName(diskRetBo.getDiskId());
            } else {
                hdPo.setHdName(reqBo.getResourceName());
            }
            hdPos.add(hdPo);
            RsInfoResourcePo resourcePo = new RsInfoResourcePo();
            BeanUtils.copyProperties((Object)reqBo, (Object)resourcePo);
            resourcePo.setInstanceId(diskRetBo.getDiskId());
            if (StringUtils.isEmpty((CharSequence)reqBo.getResourceName())) {
                resourcePo.setResourceName(diskRetBo.getDiskId());
            }
            resourcePo.setServiceId(7L);
            resourcePo.setResourceId(resourceId);
            resourcePo.setCreateTime(nowTime);
            resourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
            resourcePos.add(resourcePo);
        }
        int result = this.rsInfoHardDiskMapper.insertBatch(hdPos);
        if (result < reqBo.getCreateNumbers()) {
            this.LOGGER.error("\u4e91\u76d8\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
            throw new McmpBusinessException("9000", "\u4e91\u76d8\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
        }
        result = this.rsInfoResourceMapper.insertBatch(resourcePos);
        if (result < reqBo.getCreateNumbers()) {
            this.LOGGER.error("\u8d44\u6e90\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
            throw new McmpBusinessException("9000", "\u8d44\u6e90\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25");
        }
        return resourceIds;
    }

    private Long getSequenceId(String sequenceName) {
        long sequenceId;
        try {
            sequenceId = this.sequenceManagement.nextId(sequenceName);
        }
        catch (SQLException e) {
            this.LOGGER.error("\u83b7\u53d6\u4e91\u76d8\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u4e91\u76d8\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
        }
        return sequenceId;
    }
}

