/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.ability.api.bo.RsCloudPlatformAccountParamDetailDataBo;
import com.tydic.mcmp.resource.busi.api.RsCloudPlatformAccountAddBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudPlatformAccountAddBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudPlatformAccountAddBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsRelTenementPlatformParamMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPlatformAcountPo;
import com.tydic.mcmp.resource.dao.po.RsRelTenementPlatformParamPo;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="rsCloudPlatformAccountAddBusiService")
public class RsCloudPlatformAccountAddBusiServiceImpl
implements RsCloudPlatformAccountAddBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private RsRelTenementPlatformParamMapper rsRelTenementPlatformParamMapper;

    public RsCloudPlatformAccountAddBusiRspBo addPlatformAccount(RsCloudPlatformAccountAddBusiReqBo reqBo) {
        int result;
        this.LOGGER.info("\u4e91\u5e73\u53f0\u8d26\u6237\u65b0\u589e Busi\u670d\u52a1\uff1a" + reqBo);
        RsCloudPlatformAccountAddBusiRspBo retBo = new RsCloudPlatformAccountAddBusiRspBo();
        String validate = this.validate(reqBo);
        if (!StringUtils.isEmpty((Object)validate)) {
            this.LOGGER.error(validate);
            retBo.setRespCode("8887");
            retBo.setRespDesc(validate);
            return retBo;
        }
        Date nowTime = null;
        try {
            nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        }
        catch (Exception e) {
            this.LOGGER.error("\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u5f02\u5e38\uff1a" + e.getMessage());
            throw new McmpBusinessException("6001", "\u83b7\u53d6\u5f53\u524d\u65f6\u95f4\u5f02\u5e38\uff1a" + e);
        }
        RsInfoPlatformAcountPo accountPo = new RsInfoPlatformAcountPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)accountPo);
        accountPo.setAccountStatus(RsDictionaryValueConstants.RS_INFO_RPLATFORM_ACOUNT_STATUS_AVAILABLE);
        accountPo.setCreateTime(nowTime);
        try {
            result = this.rsInfoPlatformAcountMapper.insertSelective(accountPo);
        }
        catch (Exception e) {
            this.LOGGER.error("\u4e91\u5e73\u53f0\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u5199\u5165\u5f02\u5e38\uff1a" + e.getMessage());
            throw new McmpBusinessException("6001", "\u4e91\u5e73\u53f0\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u5199\u5165\u5f02\u5e38\uff1a" + e);
        }
        if (result < 1) {
            this.LOGGER.error("\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("6001", "\u4e91\u8d26\u6237\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        this.LOGGER.info("\u4e91\u8d26\u6237ID\uff1a" + accountPo.getAccountId());
        RsRelTenementPlatformParamPo relParamPo = new RsRelTenementPlatformParamPo();
        relParamPo.setCreateTime(nowTime);
        relParamPo.setCreateOper(reqBo.getCreateOper());
        relParamPo.setAccountId(accountPo.getAccountId());
        relParamPo.setPlatformId((long)reqBo.getPlatformId());
        relParamPo.setTenementId(Long.valueOf(reqBo.getTenementId()));
        for (RsCloudPlatformAccountParamDetailDataBo paramDetailDataBo : reqBo.getParams()) {
            relParamPo.setParamKey(paramDetailDataBo.getParamKey());
            relParamPo.setParamValue(paramDetailDataBo.getParamValue());
            relParamPo.setAccounted(paramDetailDataBo.getAccounted());
            try {
                result = this.rsRelTenementPlatformParamMapper.insertSelective(relParamPo);
            }
            catch (Exception e) {
                this.LOGGER.error("\u79df\u6237-\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u4fe1\u606f\u8868\u5199\u5165\u5f02\u5e38\uff1a" + e.getMessage());
                throw new McmpBusinessException("6001", "\u79df\u6237-\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25\uff1a" + e);
            }
            if (result >= 1) continue;
            this.LOGGER.error("\u79df\u6237-\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("6001", "\u79df\u6237-\u5e73\u53f0\u8d26\u6237\u53c2\u6570\u4fe1\u606f\u8868\u5199\u5165\u5931\u8d25\uff1a\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private String validate(RsCloudPlatformAccountAddBusiReqBo reqBo) {
        if (!StringUtils.isEmpty((Object)reqBo.getAccountName())) {
            RsInfoPlatformAcountPo accountPo = new RsInfoPlatformAcountPo();
            accountPo.setAccountName(reqBo.getAccountName());
            List<RsInfoPlatformAcountPo> accounts = this.rsInfoPlatformAcountMapper.selectByCondition(accountPo);
            if (!CollectionUtils.isEmpty(accounts)) {
                this.LOGGER.error("\u6b64\u8d26\u6237\u540d\u88ab\u5360\u7528");
                return "\u6b64\u8d26\u6237\u540d\u88ab\u5360\u7528";
            }
        }
        return null;
    }
}

