/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.rds.McmpIntfDatabaseCreateDBInstanceService;
import com.tydic.mcmp.intf.api.rds.bo.McmpAliRdsCreateDbInstanceReqBO;
import com.tydic.mcmp.intf.api.rds.bo.McmpIntfDatabaseCreateDBInstanceReqBO;
import com.tydic.mcmp.intf.api.rds.bo.McmpIntfDatabaseCreateDBInstanceRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.api.RsSyncResourceInfoToTicketAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.atom.bo.RsSyncResourceInfoToTicketAtomReqBo;
import com.tydic.mcmp.resource.busi.api.RsDatabaseIndCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabaseIndCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabaseIndCreateBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.constants.RsPlatformConstants;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceDatabaseMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceDatabasePo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="rsDatabaseIndCreateBusiService")
public class RsDatabaseIndCreateBusiServiceImpl
implements RsDatabaseIndCreateBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private McmpIntfDatabaseCreateDBInstanceService mcmpIntfDatabaseCreateDBInstanceService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceDatabaseMapper rsInfoResourceDatabaseMapper;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsSyncResourceInfoToTicketAtomService rsSyncResourceInfoToTicketAtomService;

    public RsDatabaseIndCreateBusiRspBo createDatabaseIns(RsDatabaseIndCreateBusiReqBo reqBo) {
        this.LOGGER.info("\u6570\u636e\u5e93\u5b9e\u4f8b\u521b\u5efabusi\u670d\u52a1\uff1a" + reqBo);
        RsDatabaseIndCreateBusiRspBo retBo = new RsDatabaseIndCreateBusiRspBo();
        this.validateStr(reqBo);
        McmpIntfDatabaseCreateDBInstanceRspBO createDbInsRetBo = this.invokeExtInterface(reqBo);
        this.LOGGER.info("\u5916\u90e8\u63a5\u53e3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)createDbInsRetBo));
        if (!"0000".equals(createDbInsRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u63a5\u53e3\u521b\u5efa\u6570\u636e\u5e93\u5b9e\u4f8b\u5931\u8d25\uff1a" + createDbInsRetBo.getRespDesc());
            throw new McmpBusinessException("9000", "\u8c03\u7528\u63a5\u53e3\u521b\u5efa\u6570\u636e\u5e93\u5b9e\u4f8b\u5931\u8d25\uff1a" + createDbInsRetBo.getRespDesc());
        }
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        Long resourceId = this.insertDatabaseInfo(reqBo, createDbInsRetBo);
        this.insertResourceInfo(reqBo, resourceId, createDbInsRetBo, nowTime);
        this.syncResourceInfoToTicket(resourceId, null, reqBo.getTicketNo());
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void insertResourceInfo(RsDatabaseIndCreateBusiReqBo reqBo, Long resourceId, McmpIntfDatabaseCreateDBInstanceRspBO createDbInsRetBo, Date nowTime) {
        RsInfoResourcePo resourcePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)resourcePo);
        resourcePo.setResourceName(createDbInsRetBo.getDBInstanceId());
        if (!StringUtils.isEmpty((Object)reqBo.getDBInstanceDescription())) {
            resourcePo.setResourceName(reqBo.getDBInstanceDescription());
        }
        resourcePo.setResourceId(resourceId);
        resourcePo.setServiceId(2L);
        resourcePo.setInstanceId(createDbInsRetBo.getDBInstanceId());
        resourcePo.setRequestId(reqBo.getCreateOper());
        resourcePo.setCreateTime(nowTime);
        resourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
        int result = this.rsInfoResourceMapper.insertSelective(resourcePo);
        if (result < 1) {
            throw new McmpBusinessException("24010", "\u5199\u8d44\u6e90\u4fe1\u606f\u8868\u5931\u8d25");
        }
    }

    private Long insertDatabaseInfo(RsDatabaseIndCreateBusiReqBo reqBo, McmpIntfDatabaseCreateDBInstanceRspBO createDbInsRetBo) {
        long resourceId;
        try {
            resourceId = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        }
        catch (SQLException e) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
        }
        RsInfoResourceDatabasePo databasePo = new RsInfoResourceDatabasePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)databasePo);
        databasePo.setResourceId(resourceId);
        databasePo.setInstanceId(createDbInsRetBo.getDBInstanceId());
        databasePo.setNetType(RsInterfaceUtil.convertNetType(reqBo.getInsNetType()));
        databasePo.setPort(createDbInsRetBo.getPort());
        databasePo.setInstanceMemory(reqBo.getInstanceMemory());
        databasePo.setInstanceStorage(reqBo.getHsSize());
        databasePo.setInstanceVersion(RsInterfaceUtil.convertDbVersion(reqBo.getInstanceVersion()));
        if (RsPlatformConstants.DbInsNetType.INTRANET.equals(reqBo.getDbNetType())) {
            databasePo.setInnerAddress(createDbInsRetBo.getConnectionString());
        } else {
            databasePo.setPublicAddress(createDbInsRetBo.getConnectionString());
        }
        int result = this.rsInfoResourceDatabaseMapper.insertSelective(databasePo);
        if (result < 1) {
            throw new McmpBusinessException("24010", "\u5199\u6570\u636e\u5e93\u4fe1\u606f\u8868\u5931\u8d25");
        }
        return resourceId;
    }

    private McmpIntfDatabaseCreateDBInstanceRspBO invokeExtInterface(RsDatabaseIndCreateBusiReqBo reqBo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u7528\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpIntfDatabaseCreateDBInstanceReqBO createDbInsReqBo = new McmpIntfDatabaseCreateDBInstanceReqBO();
        if (2L == reqBo.getPlatformId()) {
            createDbInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            createDbInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            createDbInsReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            createDbInsReqBo.setProxyHost(atomRetBo.getProxyHost());
            createDbInsReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            createDbInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            createDbInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            createDbInsReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        createDbInsReqBo.setRegion(reqBo.getRegionId());
        createDbInsReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        McmpAliRdsCreateDbInstanceReqBO dataBo = new McmpAliRdsCreateDbInstanceReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)dataBo);
        dataBo.setDBInstanceClass(reqBo.getInstanceSpecification());
        dataBo.setDBInstanceNetType(RsInterfaceUtil.convertDbNetType(reqBo.getDbNetType()));
        dataBo.setDBInstanceStorage(reqBo.getHsSize());
        dataBo.setEngine(RsInterfaceUtil.convertAliInstanceType(reqBo.getInstanceType()));
        dataBo.setEngineVersion(RsInterfaceUtil.convertDbVersion(reqBo.getInstanceVersion()));
        dataBo.setPayType(RsInterfaceUtil.convertAliDbInsPayType(reqBo.getPayType()));
        dataBo.setSecurityIPList("0.0.0.0/0");
        dataBo.setInstanceNetworkType(RsInterfaceUtil.convertNetType(reqBo.getInsNetType()));
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_MONTH.equals(reqBo.getPayType())) {
            dataBo.setUsedTime(RsInterfaceUtil.convertBuyTime(reqBo.getBuyTime()));
            dataBo.setPeriod(RsInterfaceUtil.convertTimeUnit(reqBo.getBuyTime()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStorageType()) && !StringUtils.isEmpty((Object)reqBo.getInstanceSeries())) {
            dataBo.setDBInstanceStorageType(RsInterfaceUtil.convertDbInsStorageType(Integer.parseInt(reqBo.getStorageType())));
            dataBo.setCategory(RsInterfaceUtil.convertAliInstanceSeries(reqBo.getInstanceSeries()));
        }
        createDbInsReqBo.setMcmpAliRdsCreateDbInstanceReqBO(dataBo);
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString((Object)createDbInsReqBo));
        return this.mcmpIntfDatabaseCreateDBInstanceService.createDBInstance(createDbInsReqBo);
    }

    private void validateStr(RsDatabaseIndCreateBusiReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getPlatformId())) {
            throw new McmpBusinessException("9000", "\u5e73\u53f0ID'platformId'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getAccountId())) {
            throw new McmpBusinessException("9000", "\u8d26\u6237ID'accountId'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegionId()) && 1L == reqBo.getPlatformId()) {
            throw new McmpBusinessException("9000", "\u5730\u57dfID'regionId'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayType()) && 1L == reqBo.getPlatformId()) {
            throw new McmpBusinessException("9000", "\u4ed8\u8d39\u65b9\u5f0f'payType'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getInstanceType())) {
            throw new McmpBusinessException("9000", "\u6570\u636e\u5e93\u7c7b\u578b'instanceType'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getInstanceVersion())) {
            throw new McmpBusinessException("9000", "\u6570\u636e\u5e93\u7248\u672c'instanceVersion'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getHsSize())) {
            throw new McmpBusinessException("9000", "\u786c\u76d8\u5c3a\u5bf8'hsSize'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getInstanceSpecification())) {
            throw new McmpBusinessException("9000", "\u5b9e\u4f8b\u89c4\u683c'instanceSpecification'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_MONTH.equals(reqBo.getPayType()) && StringUtils.isEmpty((Object)reqBo.getBuyTime())) {
            throw new McmpBusinessException("9000", "\u5f53\u4ed8\u8d39\u65b9\u5f0f\u4e3a\u5305\u5e74\u5305\u6708\u65f6\uff0c\u8d2d\u4e70\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a'buyTime'\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void syncResourceInfoToTicket(Long resourceId, Set<Long> resourceIds, String ticketNo) {
        RsSyncResourceInfoToTicketAtomReqBo rsSyncResourceInfoToTicketAtomReqBo = new RsSyncResourceInfoToTicketAtomReqBo();
        rsSyncResourceInfoToTicketAtomReqBo.setResourceId(resourceId);
        rsSyncResourceInfoToTicketAtomReqBo.setResourceIds(resourceIds);
        rsSyncResourceInfoToTicketAtomReqBo.setTicketNo(ticketNo);
        this.rsSyncResourceInfoToTicketAtomService.syncResourceInfoToTicket(rsSyncResourceInfoToTicketAtomReqBo);
    }
}

