/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.redis.McmpRedisDeleteWithRestartInstanceService;
import com.tydic.mcmp.intf.api.redis.bo.McmpRedisDeleteInstanceReqBO;
import com.tydic.mcmp.intf.api.redis.bo.McmpRedisDeleteWithRestartInstanceReqBO;
import com.tydic.mcmp.intf.api.redis.bo.McmpRedisDeleteWithRestartInstanceRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsDeleteRedisInstanceBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsDeleteRedisInstanceBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsDeleteRedisInstanceBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceRedisMapper;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RsDeleteRedisInstanceBusiServiceImpl
implements RsDeleteRedisInstanceBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsDeleteRedisInstanceBusiServiceImpl.class);
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceRedisMapper rsInfoResourceRedisMapper;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpRedisDeleteWithRestartInstanceService mcmpRedisDeleteWithRestartInstanceService;

    public RsDeleteRedisInstanceBusiRspBo deleteRedisInstance(RsDeleteRedisInstanceBusiReqBo busiReqBo) {
        RsDeleteRedisInstanceBusiRspBo busiRspBo = new RsDeleteRedisInstanceBusiRspBo();
        int count = this.rsInfoResourceMapper.deleteByPrimaryKey(busiReqBo.getCacheResourceId());
        if (count != 1) {
            throw new McmpBusinessException("24011", " \u5220\u9664\u8d44\u6e90\u8868\u4fe1\u606f\u5931\u8d25");
        }
        int count1 = this.rsInfoResourceRedisMapper.deleteByPrimaryKey(busiReqBo.getCacheResourceId());
        if (count1 != 1) {
            throw new McmpBusinessException("24011", " \u5220\u9664\u8d44\u6e90-Redis\u4fe1\u606f\u8868\u4fe1\u606f\u5931\u8d25");
        }
        this.invokeDeleteWithRestartInstance(busiReqBo);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u5220\u9664\u7f13\u5b58\u5b9e\u4f8b\u6210\u529f");
        return busiRspBo;
    }

    private void invokeDeleteWithRestartInstance(RsDeleteRedisInstanceBusiReqBo busiReqBo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        McmpRedisDeleteWithRestartInstanceReqBO mcmpRedisDeleteWithRestartInstanceReqBO = new McmpRedisDeleteWithRestartInstanceReqBO();
        mcmpRedisDeleteWithRestartInstanceReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpRedisDeleteWithRestartInstanceReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpRedisDeleteWithRestartInstanceReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpRedisDeleteWithRestartInstanceReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpRedisDeleteWithRestartInstanceReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpRedisDeleteWithRestartInstanceReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        if (StringUtils.hasText((String)busiReqBo.getRegionId())) {
            mcmpRedisDeleteWithRestartInstanceReqBO.setRegion(busiReqBo.getRegionId());
        }
        mcmpRedisDeleteWithRestartInstanceReqBO.setDeleteOrRestart(Integer.valueOf(0));
        McmpRedisDeleteInstanceReqBO mcmpRedisDeleteInstanceReqBO = new McmpRedisDeleteInstanceReqBO();
        mcmpRedisDeleteInstanceReqBO.setInstanceId(busiReqBo.getInstanceId());
        mcmpRedisDeleteWithRestartInstanceReqBO.setRedisDeleteInstanceReqBO(mcmpRedisDeleteInstanceReqBO);
        log.info("\u8c03\u7528\u7f13\u5b58\u5b9e\u4f8b\u91cd\u542f/\u5220\u9664API\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpRedisDeleteWithRestartInstanceReqBO));
        McmpRedisDeleteWithRestartInstanceRspBO mcmpRedisDeleteWithRestartInstanceRspBO = this.mcmpRedisDeleteWithRestartInstanceService.deleteWithRestartInstance(mcmpRedisDeleteWithRestartInstanceReqBO);
        log.info("\u8c03\u7528\u7f13\u5b58\u5b9e\u4f8b\u91cd\u542f/\u5220\u9664API\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpRedisDeleteWithRestartInstanceRspBO));
        if (!"0000".equals(mcmpRedisDeleteWithRestartInstanceRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpRedisDeleteWithRestartInstanceRspBO.getRespCode(), mcmpRedisDeleteWithRestartInstanceRspBO.getRespDesc());
        }
    }
}

