/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDeleteSnapshotService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDeleteSnapshotReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDeleteSnapshotRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsHostSnapshotDeleteBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsHostSnapshotDeleteBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsHostSnapshotDeleteBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoHostSnapshotMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelHostSnapshotMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHostSnapshotQueryPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostSnapshotPo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsHostSnapshotDeleteBusiService")
public class RsHostSnapshotDeleteBusiServiceImpl
implements RsHostSnapshotDeleteBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHostSnapshotMapper rsInfoHostSnapshotMapper;
    @Autowired
    private RsRelHostSnapshotMapper rsRelHostSnapshotMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private McmpCloudSerDeleteSnapshotService mcmpCloudSerDeleteSnapshotService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsHostSnapshotDeleteBusiRspBo deleteSnapshot(RsHostSnapshotDeleteBusiReqBo reqBo) {
        this.LOGGER.info("\u5feb\u7167\u5220\u9664busi\u670d\u52a1\uff1a" + reqBo);
        RsHostSnapshotDeleteBusiRspBo retBo = new RsHostSnapshotDeleteBusiRspBo();
        RsInfoHostSnapshotQueryPo qryPo = this.rsInfoHostSnapshotMapper.selectByQuery(reqBo.getSnapshotResourceId());
        if (qryPo == null) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u5feb\u7167ID(" + reqBo.getSnapshotResourceId() + ")\u7684\u4fe1\u606f");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5feb\u7167ID(" + reqBo.getSnapshotResourceId() + ")\u7684\u4fe1\u606f");
            return retBo;
        }
        McmpCloudSerDeleteSnapshotRspBO snapshotRetBo = this.invokeExtInterface(qryPo, reqBo);
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5f97\u5230\u7684\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)snapshotRetBo));
        if (!"0000".equals(snapshotRetBo.getRespCode())) {
            this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5220\u9664\u5feb\u7167\u5931\u8d25\uff1a" + snapshotRetBo.getRespDesc());
            throw new McmpBusinessException("9000", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5220\u9664\u5feb\u7167\u5931\u8d25\uff1a" + snapshotRetBo.getRespDesc());
        }
        int result = this.rsInfoHostSnapshotMapper.deleteByPrimaryKey(reqBo.getSnapshotResourceId());
        if (result < 1) {
            this.LOGGER.error("\u5220\u9664\u5feb\u7167\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("24011", "\u5220\u9664\u5feb\u7167\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        result = this.rsInfoResourceMapper.deleteByPrimaryKey(reqBo.getSnapshotResourceId());
        if (result < 1) {
            this.LOGGER.error("\u5220\u9664\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("24011", "\u5220\u9664\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        RsRelHostSnapshotPo relPo = new RsRelHostSnapshotPo();
        relPo.setSnapshotResourceId(qryPo.getSnapshotResourceId());
        result = this.rsRelHostSnapshotMapper.deleteByCondition(relPo);
        if (result < 1) {
            this.LOGGER.error("\u5220\u9664\u4e3b\u673a-\u5feb\u7167\u5173\u7cfb\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("24011", "\u5220\u9664\u4e3b\u673a-\u5feb\u7167\u5173\u7cfb\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private McmpCloudSerDeleteSnapshotRspBO invokeExtInterface(RsInfoHostSnapshotQueryPo qryPo, RsHostSnapshotDeleteBusiReqBo reqBo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)atomReqBo));
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            this.LOGGER.info("\u67e5\u8be2\u8d26\u6237\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
            throw new McmpBusinessException("9000", "\u67e5\u8be2\u8d26\u6237\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpCloudSerDeleteSnapshotReqBO snapshotReqBo = new McmpCloudSerDeleteSnapshotReqBO();
        if (2L == reqBo.getPlatformId()) {
            snapshotReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            snapshotReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            snapshotReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            snapshotReqBo.setProxyHost(atomRetBo.getProxyHost());
            snapshotReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            snapshotReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            snapshotReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            snapshotReqBo.setRegion(atomRetBo.getAccountRegionId());
            if (!StringUtils.isEmpty((CharSequence)qryPo.getRegionId())) {
                snapshotReqBo.setRegion(qryPo.getRegionId());
            }
        }
        snapshotReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        snapshotReqBo.setSnapshotId(qryPo.getInstanceId());
        this.LOGGER.info("\u8c03\u7528\u63a5\u53e3\u7684\u5165\u53c2\uff1a" + JSON.toJSONString((Object)snapshotReqBo));
        return this.mcmpCloudSerDeleteSnapshotService.deleteSnapshot(snapshotReqBo);
    }
}

