/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.resource.atom.api.RsVerifyDataAtomService;
import com.tydic.mcmp.resource.atom.bo.RsVerifyDataAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsVerifyDataAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsMachineRoomPageQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsMachineRoomPageQueryBusiReqBo;
import com.tydic.mcmp.resource.common.bo.RsMachineRoomDataBo;
import com.tydic.mcmp.resource.dao.RsInfoPyhsicsDataCenterMapper;
import com.tydic.mcmp.resource.dao.RsInfoPyhsicsMachineRoomMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPyhsicsDataCenterPo;
import com.tydic.mcmp.resource.dao.po.RsInfoPyhsicsMachineRoomPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsMachineRoomPageQueryBusiService")
public class RsMachineRoomPageQueryBusiServiceImpl
implements RsMachineRoomPageQueryBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsMachineRoomPageQueryBusiServiceImpl.class);
    private static final Integer CAN_DELETE = 1;
    private static final Integer NOT_DELETE = 0;
    @Autowired
    private RsInfoPyhsicsMachineRoomMapper rsInfoPyhsicsMachineRoomMapper;
    @Autowired
    private RsInfoPyhsicsDataCenterMapper rsInfoPyhsicsDataCenterMapper;
    @Autowired
    private RsVerifyDataAtomService rsVerifyDataAtomService;

    public McmpRspPageBo<McmpRspPageDataBo<RsMachineRoomDataBo>> queryMachineRoom(RsMachineRoomPageQueryBusiReqBo reqBo) {
        log.info("\u8fdb\u5165\u673a\u623f\u5206\u9875\u67e5\u8be2busi\u670d\u52a1\uff1a" + reqBo);
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo data = new McmpRspPageDataBo();
        ArrayList<RsMachineRoomDataBo> rows = new ArrayList<RsMachineRoomDataBo>();
        retBo.setData((Object)data);
        data.setRows(rows);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        Page<RsInfoPyhsicsMachineRoomPo> page = this.getPage(reqBo);
        RsInfoPyhsicsMachineRoomPo qryPo = new RsInfoPyhsicsMachineRoomPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryPo);
        List<RsInfoPyhsicsMachineRoomPo> machineRooms = this.rsInfoPyhsicsMachineRoomMapper.selectPage(qryPo, page);
        if (CollectionUtils.isEmpty(machineRooms)) {
            log.error("\u672a\u67e5\u8be2\u5230\u5339\u914d\u7684\u6570\u636e");
        }
        Map<Long, String> dataCentrNameMap = this.getDataCenterName();
        RsVerifyDataAtomReqBo atomReqBo = new RsVerifyDataAtomReqBo();
        for (RsInfoPyhsicsMachineRoomPo machineRoomPo : machineRooms) {
            RsMachineRoomDataBo dataBo = new RsMachineRoomDataBo();
            BeanUtils.copyProperties((Object)machineRoomPo, (Object)dataBo);
            dataBo.setDataCenterName(dataCentrNameMap.get(dataBo.getDataCenterId()));
            atomReqBo.setMachineRoomId(dataBo.getMachineRoomId());
            RsVerifyDataAtomRspBo atomRetBo = this.rsVerifyDataAtomService.verifyData(atomReqBo);
            dataBo.setCanDelete(CAN_DELETE);
            if (atomRetBo.isHaveData()) {
                dataBo.setCanDelete(NOT_DELETE);
            }
            rows.add(dataBo);
        }
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        return retBo;
    }

    private Map<Long, String> getDataCenterName() {
        HashMap<Long, String> dataCentrNameMap = new HashMap<Long, String>(16);
        List<RsInfoPyhsicsDataCenterPo> centerPos = this.rsInfoPyhsicsDataCenterMapper.selectByCondtion(new RsInfoPyhsicsDataCenterPo());
        for (RsInfoPyhsicsDataCenterPo centerPo : centerPos) {
            dataCentrNameMap.put(centerPo.getDataCenterId(), centerPo.getDataCenterName());
        }
        return dataCentrNameMap;
    }

    private Page<RsInfoPyhsicsMachineRoomPo> getPage(RsMachineRoomPageQueryBusiReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }
}

