/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.busi.api.RsNetworkChangeBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsNetworkChangeBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsNetworkChangeBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoNetworkCardMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelNetworkCardSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoNetworkCardPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsRelNetworkCardSecurityGroupPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsNetworkChangeBusiService")
public class RsNetworkChangeBusiServiceImpl
implements RsNetworkChangeBusiService {
    @Autowired
    private RsInfoNetworkCardMapper rsInfoNetworkCardMapper;
    @Autowired
    private RsRelNetworkCardSecurityGroupMapper rsRelNetworkCardSecurityGroupMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsNetworkChangeBusiServiceImpl.class);

    public RsNetworkChangeBusiRspBo dealRsNetworkChange(RsNetworkChangeBusiReqBo reqBo) {
        RsNetworkChangeBusiRspBo rspBo = RsRspBoUtil.genSuccessBo(RsNetworkChangeBusiRspBo.class);
        try {
            RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
            rsInfoResourcePo.setResourceId(reqBo.getCardResourceId());
            rsInfoResourcePo.setDepartId(reqBo.getDepartId());
            rsInfoResourcePo.setDepartName(reqBo.getDepartName());
            rsInfoResourcePo.setProjectId(reqBo.getProjectId());
            rsInfoResourcePo.setProjectName(reqBo.getProjectName());
            this.rsInfoResourceMapper.updateByPrimaryKeySelective(rsInfoResourcePo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4fee\u6539\u8d44\u6e90\u5931\u8d25");
            return rspBo;
        }
        try {
            RsInfoNetworkCardPo rsInfoNetworkCardPo = new RsInfoNetworkCardPo();
            rsInfoNetworkCardPo.setCardResourceId(reqBo.getCardResourceId());
            rsInfoNetworkCardPo.setCardName(reqBo.getNetworkName());
            rsInfoNetworkCardPo.setCardRemark(reqBo.getDesc());
            this.rsInfoNetworkCardMapper.updateByPrimaryKeySelective(rsInfoNetworkCardPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u4fee\u6539\u7f51\u5361\u5931\u8d25");
            return rspBo;
        }
        try {
            this.rsRelNetworkCardSecurityGroupMapper.deleteByCardResource(reqBo.getCardResourceId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5220\u9664\u5b89\u5168\u7ec4\u5173\u7cfb\u5931\u8d25");
            return rspBo;
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSecurityGroupList())) {
            try {
                for (Long group : reqBo.getSecurityGroupList()) {
                    Long relId = this.sequenceManagement.nextId(RsSequencesEnum.RS_REL_NETWORK_CARD_SECURITY_GROUP.toString());
                    RsRelNetworkCardSecurityGroupPo relNetworkCardSecurityGroupPo = new RsRelNetworkCardSecurityGroupPo();
                    relNetworkCardSecurityGroupPo.setRelId(relId);
                    relNetworkCardSecurityGroupPo.setSecurityGroupResourceId(group);
                    relNetworkCardSecurityGroupPo.setCardResourceId(reqBo.getCardResourceId());
                    this.rsRelNetworkCardSecurityGroupMapper.insert(relNetworkCardSecurityGroupPo);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                rspBo.setRespCode("8888");
                rspBo.setRespDesc("\u4fee\u6539\u5b89\u5168\u7ec4\u5173\u7cfb\u5931\u8d25");
                return rspBo;
            }
        }
        return rspBo;
    }
}

