/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.vpc.McmpDescribeVSwitchesBusiService;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVSwitchesReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVSwitchesRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsQryAliVSwitchesBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsQryAliVSwitchesBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsQryAliVSwitchesBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsAliVSwitchesInfoBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RsQryAliVSwitchesBusiServiceImpl
implements RsQryAliVSwitchesBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsQryAliVSwitchesBusiServiceImpl.class);
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpDescribeVSwitchesBusiService mcmpDescribeVSwitchesBusiService;

    public RsQryAliVSwitchesBusiRspBo qryAliVSwitches(RsQryAliVSwitchesBusiReqBo busiReqBo) {
        RsQryAliVSwitchesBusiRspBo busiRspBo = new RsQryAliVSwitchesBusiRspBo();
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(busiReqBo.getAccountId());
        atomReqBo.setPlatformId(busiReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        McmpDescribeVSwitchesReqBO mcmpDescribeVSwitchesReqBO = new McmpDescribeVSwitchesReqBO();
        mcmpDescribeVSwitchesReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpDescribeVSwitchesReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpDescribeVSwitchesReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpDescribeVSwitchesReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpDescribeVSwitchesReqBO.setProxyPort(atomRspBo.getProxyPort());
        mcmpDescribeVSwitchesReqBO.setCloudType(RsInterfaceUtil.convertCloudType(busiReqBo.getPlatformId()));
        mcmpDescribeVSwitchesReqBO.setVpcId(busiReqBo.getVpcId());
        if (StringUtils.hasText((String)busiReqBo.getRegion())) {
            mcmpDescribeVSwitchesReqBO.setRegion(busiReqBo.getRegion());
        }
        mcmpDescribeVSwitchesReqBO.setZoneId(busiReqBo.getZoneId());
        if (StringUtils.hasText((String)busiReqBo.getVSwitchName())) {
            mcmpDescribeVSwitchesReqBO.setVSwitchName(busiReqBo.getVSwitchName());
        }
        mcmpDescribeVSwitchesReqBO.setPageNumber(busiReqBo.getPageNo());
        mcmpDescribeVSwitchesReqBO.setPageSize(busiReqBo.getPageSize());
        log.info("\u8c03\u7528\u4ea4\u6362\u673a\u5217\u8868\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpDescribeVSwitchesReqBO));
        McmpDescribeVSwitchesRspBO mcmpDescribeVSwitchesRspBO = this.mcmpDescribeVSwitchesBusiService.describeVSwitches(mcmpDescribeVSwitchesReqBO);
        log.info("\u8c03\u7528\u4ea4\u6362\u673a\u5217\u8868\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpDescribeVSwitchesRspBO));
        if (!"0000".equals(mcmpDescribeVSwitchesRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpDescribeVSwitchesRspBO.getRespCode(), mcmpDescribeVSwitchesRspBO.getRespDesc());
        }
        ArrayList<RsAliVSwitchesInfoBo> rows = new ArrayList<RsAliVSwitchesInfoBo>();
        if (!CollectionUtils.isEmpty((Collection)mcmpDescribeVSwitchesRspBO.getVSwitches())) {
            for (McmpDescribeVSwitchesRspBO.VSwitch vSwitch : mcmpDescribeVSwitchesRspBO.getVSwitches()) {
                RsAliVSwitchesInfoBo bo = new RsAliVSwitchesInfoBo();
                bo.setVSwitchId(vSwitch.getVSwitchId());
                bo.setVSwitchName(vSwitch.getVSwitchName());
                rows.add(bo);
            }
        }
        busiRspBo.setPageNo(mcmpDescribeVSwitchesRspBO.getPageNumber());
        busiRspBo.setRecordsTotal(mcmpDescribeVSwitchesRspBO.getTotalCount());
        busiRspBo.setRows(rows);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return busiRspBo;
    }
}

