/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.utils;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.constants.RsPlatformConstants;

public class RsInterfaceUtil {
    public static String convertCloudType(Long platformId) {
        if (1L == platformId) {
            return "1";
        }
        if (2L == platformId) {
            return "2";
        }
        throw new McmpBusinessException("9000", "\u8bf7\u4f20\u5165\u5408\u9002\u7684\u5e73\u53f0id(" + platformId + ")");
    }

    public static String convertAliHostPayType(Integer payType) {
        if (payType == null) {
            return null;
        }
        if (1 == payType) {
            return "PrePaid";
        }
        if (2 == payType) {
            return "PostPaid";
        }
        throw new McmpBusinessException("9000", "payType[" + payType + "]\u6682\u4e0d\u652f\u6301");
    }

    public static String convertAliHdType(Integer HdType) {
        if (HdType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_SSD == HdType) {
            return "cloud_ssd";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_CLOUD == HdType) {
            return "cloud_efficiency";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_GENERAL_CLOUD == HdType) {
            return "cloud";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_CLOUD_ESSD == HdType) {
            return "cloud_essd";
        }
        return null;
    }

    public static String convertAliHdPayType(Integer HdPayType) {
        if (HdPayType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_MONTH == HdPayType) {
            return "Prepaid";
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_USAGE == HdPayType) {
            return "Postpaid";
        }
        return null;
    }

    public static Integer convertAliDiskCategoryHdType(String category) {
        if ("cloud_ssd".equals(category)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_SSD;
        }
        if ("cloud_efficiency".equals(category)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_TYPE_CLOUD;
        }
        return null;
    }

    public static Integer convertAliDiskTypeHdProperty(String diskType) {
        if ("system".equals(diskType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_SYS;
        }
        if ("data".equals(diskType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_DATA;
        }
        return null;
    }

    public static Integer convertAliDiskChargeTypeHdPayType(String diskChargeType) {
        if ("Prepaid".equals(diskChargeType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_MONTH;
        }
        if ("Postpaid".equals(diskChargeType)) {
            return RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PAY_TYPE_USAGE;
        }
        return null;
    }

    public static String convertAliInternetChargeType(Integer bwBillType) {
        if (null == bwBillType) {
            return null;
        }
        if (1 == bwBillType) {
            return "PayByBandwidth";
        }
        if (2 == bwBillType) {
            return "PayByTraffic";
        }
        return null;
    }

    public static String convertAliInstanceSeries(Integer instanceSeries) {
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES_HA.equals(instanceSeries)) {
            return "HighAvailability";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_INSTANCE_SERIES_BASE.equals(instanceSeries)) {
            return "Basic";
        }
        return null;
    }

    public static void setAliParamToIntReqBo(RsQueryAliParamAtomRspBo pBo, McmpIntfReqBaseBO iBo) {
        iBo.setAccessKeyId(pBo.getAccessKeyId());
        iBo.setAccessKeySecret(pBo.getAccessKeySecret());
        iBo.setEndpointPriv(pBo.getEndpoint());
        iBo.setRegion(pBo.getAccountRegionId());
        iBo.setProxyPort(pBo.getProxyPort());
        iBo.setProxyHost(pBo.getProxyHost());
    }

    public static String convertAliInstanceType(Integer instanceType) {
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_INSTANCE_TYPE_MYSQL.equals(instanceType)) {
            return "MySQL";
        }
        return null;
    }

    public static String convertAliDbInsPayType(Integer payType) {
        if (payType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_MONTH == payType) {
            return "Prepaid";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_USAGE == payType) {
            return "Postpaid";
        }
        return null;
    }

    public static String convertAliStorageClass(Integer ossType) {
        if (ossType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE_STANDARD == ossType) {
            return "Standard";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE_LF == ossType) {
            return "IA";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_STORAGE_OSS_TYPE_ARCHIVE == ossType) {
            return "Archive";
        }
        return null;
    }

    public static String convertAliCannedACL(Integer readAuthority) {
        if (readAuthority == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY_public == readAuthority) {
            return "private";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY_READ == readAuthority) {
            return "public-read";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_OBJECT_READ_AUTHORITY_READ_WRITE == readAuthority) {
            return "public-read-write";
        }
        return null;
    }

    public static String convertPayType(Integer payType) {
        if (payType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_PAY_TYPE_USAGE == payType) {
            return "PostPaid";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_PAY_TYPE_MONTH == payType) {
            return "PrePaid";
        }
        return null;
    }

    public static String convertNetType(Integer netType) {
        if (netType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_NET_TYPE_VPC == netType) {
            return "VPC";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_NET_TYPE_CLASSIC == netType) {
            return "CLASSIC";
        }
        return null;
    }

    public static String convertEngineVersion(Integer engineType) {
        if (engineType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION_5 == engineType) {
            return "5.0";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION_4 == engineType) {
            return "4.0";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION_28 == engineType) {
            return "2.8";
        }
        return null;
    }

    public static String convertEngineVersionType(Integer engineType) {
        if (engineType == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_VERSION_TYPE_COMMUNITY == engineType) {
            return "\u793e\u533a\u7248";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_REDIS_VERSION_TYPE_EE == engineType) {
            return "\u4f01\u4e1a\u7248";
        }
        return null;
    }

    public static String convertDbNetType(Integer netType) {
        if (netType == null) {
            return "Internet";
        }
        if (RsPlatformConstants.DbInsNetType.INTERNET == netType) {
            return "Internet";
        }
        if (RsPlatformConstants.DbInsNetType.INTRANET == netType) {
            return "Intranet";
        }
        return null;
    }

    public static String convertDbVersion(String version) {
        if (version == null) {
            return null;
        }
        if ("1".equals(version)) {
            return "5.5";
        }
        if ("2".equals(version)) {
            return "5.6";
        }
        if ("3".equals(version)) {
            return "5.7";
        }
        return null;
    }

    public static String convertDbInsStorageType(Integer type) {
        if (type == null) {
            return null;
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE_LOCAL == type) {
            return "local_ssd";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE_CLOUD == type) {
            return "cloud_ssd";
        }
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_STORAGE_TYPE_ESSD_CLOUD == type) {
            return "cloud_essd";
        }
        return null;
    }

    public static String convertTimeUnit(Integer buyTime) {
        if (buyTime == null) {
            return null;
        }
        if (9 >= buyTime) {
            return "Month";
        }
        return "Year";
    }

    public static String convertBuyTime(Integer buyTime) {
        if (buyTime == null) {
            return null;
        }
        if (12 > buyTime) {
            return buyTime.toString();
        }
        return buyTime / 12 + "";
    }
}

