/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeInstanceTypesService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeInstanceTypesReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeInstanceTypesRspBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerInstanceTypesBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsAliCpuSpecQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.RsAliHostZoneQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsAliCpuSpecQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliCpuSpecQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliCpuSpecQueryAbilityRspSpecBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostZoneQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostZoneQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAliHostZoneQueryAbilityRspZoneBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.config.redis.RsCacheManager;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsAliCpuSpecQueryAbilityService"})
public class RsAliCpuSpecQueryAbilityServiceImpl
implements RsAliCpuSpecQueryAbilityService {
    private static final Logger log = LogManager.getLogger(RsAliCpuSpecQueryAbilityServiceImpl.class);
    @Autowired
    private McmpCloudSerDescribeInstanceTypesService mcmpCloudSerDescribeInstanceTypesService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsCacheManager rsCacheManager;
    @Autowired
    private RsAliHostZoneQueryAbilityService rsAliHostZoneQueryAbilityService;

    @PostMapping(value={"queryCpuSpec"})
    public RsAliCpuSpecQueryAbilityRspBo queryCpuSpec(@RequestBody RsAliCpuSpecQueryAbilityReqBo reqBo) {
        RsAliCpuSpecQueryAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsAliCpuSpecQueryAbilityRspBo.class);
        String validateArgStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateArgStr)) {
            return RsRspBoUtil.genFailedBo(RsAliCpuSpecQueryAbilityRspBo.class, "\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateArgStr, "8887");
        }
        if (1L == reqBo.getPlatformId() && reqBo.getPayType() == null) {
            return RsRspBoUtil.genFailedBo(RsAliCpuSpecQueryAbilityRspBo.class, "\u516c\u6709\u4e91\u5fc5\u987b\u8981\u4f20\u5165\u4ed8\u8d39\u7c7b\u578b");
        }
        String cacheKey = "ALI_HOST_SPEC_" + reqBo.getPlatformId() + "_" + reqBo.getRegionId() + "|" + reqBo.getZoneId();
        RsQueryAliParamAtomReqBo qryParam = new RsQueryAliParamAtomReqBo();
        qryParam.setAccountId(reqBo.getAccountId());
        qryParam.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo paramAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(qryParam);
        if (!"0000".equals(paramAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsAliCpuSpecQueryAbilityRspBo.class, paramAtomRspBo.getRespDesc(), paramAtomRspBo.getRespCode());
        }
        McmpCloudSerDescribeInstanceTypesReqBO qryCpuSpec = new McmpCloudSerDescribeInstanceTypesReqBO();
        qryCpuSpec.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)qryCpuSpec);
        qryCpuSpec.setRegion(reqBo.getRegionId());
        log.debug("\u67e5\u8be2\u955c\u50cf\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSON((Object)qryCpuSpec));
        McmpCloudSerDescribeInstanceTypesRspBO instanceTypesRspBO = this.mcmpCloudSerDescribeInstanceTypesService.describeInstanceTypes(qryCpuSpec);
        log.debug("\u67e5\u8be2\u955c\u50cf\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSON((Object)instanceTypesRspBO));
        if (!"0000".equals(instanceTypesRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsAliCpuSpecQueryAbilityRspBo.class, instanceTypesRspBO.getRespDesc(), instanceTypesRspBO.getRespCode());
        }
        RsAliHostZoneQueryAbilityReqBo qryZone = new RsAliHostZoneQueryAbilityReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)qryZone);
        Set cpuSpec = new HashSet();
        RsAliHostZoneQueryAbilityRspBo rsAliHostZoneQueryAbilityRspBo = this.rsAliHostZoneQueryAbilityService.queryZone(qryZone);
        if ("0000".equals(rsAliHostZoneQueryAbilityRspBo.getRespCode())) {
            for (RsAliHostZoneQueryAbilityRspZoneBo zone : rsAliHostZoneQueryAbilityRspBo.getZones()) {
                if (!reqBo.getZoneId().equals(zone.getZoneID())) continue;
                cpuSpec = zone.getAvailableSpec();
                break;
            }
        }
        LinkedList<RsAliCpuSpecQueryAbilityRspSpecBo> cpuSpecs = new LinkedList<RsAliCpuSpecQueryAbilityRspSpecBo>();
        for (McmpCloudSerInstanceTypesBO tBo : instanceTypesRspBO.getRows()) {
            if (!CollectionUtils.isEmpty(cpuSpec) && !cpuSpec.contains(tBo.getInstanceTypeId())) continue;
            RsAliCpuSpecQueryAbilityRspSpecBo rBo = new RsAliCpuSpecQueryAbilityRspSpecBo();
            cpuSpecs.add(rBo);
            rBo.setSpecId(tBo.getInstanceTypeId());
            rBo.setSpecName(tBo.getInstanceTypeFamily());
            rBo.setSpecDesc(tBo.getInstanceTypeFamily());
            rBo.setCpuNumber(tBo.getCpuCoreCount());
            rBo.setRamSize(tBo.getMemorySize());
            rBo.setAverageCpuPerformance(tBo.getBaselineCredit() != null ? tBo.getBaselineCredit() + "%" : null);
            rBo.setInnerBandWidth(tBo.getInstanceBandwidthRx() != null ? tBo.getInstanceBandwidthRx().toString() : null);
            rBo.setInnerReceive(tBo.getInstancePpsRx() != null ? tBo.getInstancePpsRx() / 10000L + "\u4e07PPS" : null);
        }
        rspBo.setCpuSpecs(cpuSpecs);
        return rspBo;
    }

    private String validateReqArg(RsAliCpuSpecQueryAbilityReqBo reqBo) {
        if (reqBo.getPlatformId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027platformId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (reqBo.getAccountId() == null) {
            return "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027accountId\u4e0d\u80fd\u4e3a\u7a7a";
        }
        return ArgValidator.validateArg((Object)reqBo);
    }
}

