/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.mcmp.intf.api.routable.McmpDescribeServerCertificatesService;
import com.tydic.mcmp.intf.api.routable.bo.McmpDescribeServerCertificatesReqBo;
import com.tydic.mcmp.intf.api.routable.bo.McmpDescribeServerCertificatesRspBo;
import com.tydic.mcmp.intf.util.PageList;
import com.tydic.mcmp.resource.ability.api.RsCertificateListPageQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsCertificateCreateAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCertificateListPageQueryAbilityBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCertificateListPageQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCertificateListPageQueryAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoCertificateMapper;
import com.tydic.mcmp.resource.dao.RsRelCertificateRegionMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoCertificatePo;
import com.tydic.mcmp.resource.dao.po.RsRelCertificateRegionPo;
import com.tydic.mcmp.resource.utils.ListUtils;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsCertificateListPageQueryAbilityService"})
public class RsCertificateListPageQueryAbilityServiceImpl
implements RsCertificateListPageQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsCertificateListPageQueryAbilityServiceImpl.class);
    @Autowired
    private McmpDescribeServerCertificatesService mcmpDescribeServerCertificatesService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoCertificateMapper rsInfoCertificateMapper;
    @Autowired
    private RsRelCertificateRegionMapper rsRelCertificateRegionMapper;

    @PostMapping(value={"getRsCertificateList"})
    public RsCertificateListPageQueryAbilityRspBo getRsCertificateList(@RequestBody RsCertificateListPageQueryAbilityReqBo reqBo) {
        RsCertificateListPageQueryAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsCertificateListPageQueryAbilityRspBo.class);
        List<Object> accountIds = new ArrayList();
        if (reqBo.getAccountId() == null) {
            RsInfoCertificatePo rsInfoCertificatePo = new RsInfoCertificatePo();
            rsInfoCertificatePo.setPlatformId(reqBo.getPlatformId());
            List<RsInfoCertificatePo> rsInfoCertificatePos = this.rsInfoCertificateMapper.selectList(rsInfoCertificatePo);
            if (!CollectionUtils.isEmpty(rsInfoCertificatePos)) {
                accountIds = rsInfoCertificatePos.stream().map(RsInfoCertificatePo::getAccountId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(accountIds)) {
                    accountIds = ListUtils.duplicateRemovalToList(accountIds);
                }
            } else {
                return rspBo;
            }
        }
        List<Object> regionIds = new ArrayList();
        if (StringUtils.isEmpty((Object)reqBo.getRegionId())) {
            RsRelCertificateRegionPo rsRelCertificateRegionPo = new RsRelCertificateRegionPo();
            List<RsRelCertificateRegionPo> rsRelCertificateRegionPos = this.rsRelCertificateRegionMapper.selectList(rsRelCertificateRegionPo);
            if (!CollectionUtils.isEmpty((Collection)rsRelCertificateRegionPos)) {
                regionIds = rsRelCertificateRegionPos.stream().map(RsRelCertificateRegionPo::getRegionId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(regionIds)) {
                    regionIds = ListUtils.duplicateRemovalToList(regionIds);
                }
            } else {
                return rspBo;
            }
        }
        ArrayList<RsCertificateListPageQueryAbilityBo> rsCertificateListPageQueryAbilityBos = new ArrayList<RsCertificateListPageQueryAbilityBo>();
        for (Long account : accountIds) {
            for (String regionId : regionIds) {
                RsQueryAliParamAtomReqBo rsQueryAliParamAtomReqBo = new RsQueryAliParamAtomReqBo();
                rsQueryAliParamAtomReqBo.setAccountId(account);
                rsQueryAliParamAtomReqBo.setPlatformId(reqBo.getPlatformId());
                RsQueryAliParamAtomRspBo rsQueryAliParamAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(rsQueryAliParamAtomReqBo);
                if (!"0000".equals(rsQueryAliParamAtomRspBo.getRespCode())) {
                    rspBo.setRespCode("4052");
                    rspBo.setRespDesc("\u67e5\u8be2\u79d8\u94a5\u5931\u8d25");
                    return rspBo;
                }
                McmpDescribeServerCertificatesReqBo mcmpDescribeServerCertificatesReqBo = new McmpDescribeServerCertificatesReqBo();
                mcmpDescribeServerCertificatesReqBo.setCloudType(reqBo.getPlatformId().toString());
                mcmpDescribeServerCertificatesReqBo.setAccessKeyId(rsQueryAliParamAtomRspBo.getAccessKeyId());
                mcmpDescribeServerCertificatesReqBo.setAccessKeySecret(rsQueryAliParamAtomRspBo.getAccessKeySecret());
                mcmpDescribeServerCertificatesReqBo.setEndpointPriv(rsQueryAliParamAtomRspBo.getEndpoint());
                mcmpDescribeServerCertificatesReqBo.setProxyHost(rsQueryAliParamAtomRspBo.getProxyHost());
                mcmpDescribeServerCertificatesReqBo.setProxyPort(rsQueryAliParamAtomRspBo.getProxyPort());
                mcmpDescribeServerCertificatesReqBo.setRegion(regionId);
                mcmpDescribeServerCertificatesReqBo.setCertificateName(reqBo.getCertificateName());
                log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u4f20\u9012\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)mcmpDescribeServerCertificatesReqBo));
                McmpDescribeServerCertificatesRspBo mcmpDescribeServerCertificatesRspBo = this.mcmpDescribeServerCertificatesService.getMcmpDescribeServerCertificates(mcmpDescribeServerCertificatesReqBo);
                log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)mcmpDescribeServerCertificatesRspBo));
                if (!"0000".equals(mcmpDescribeServerCertificatesRspBo.getRespCode())) {
                    rspBo.setRespCode("4052");
                    rspBo.setRespDesc("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5931\u8d25");
                    return rspBo;
                }
                if (CollectionUtils.isEmpty((Collection)mcmpDescribeServerCertificatesRspBo.getCACertificates())) continue;
                for (McmpDescribeServerCertificatesRspBo.Certificate certificate : mcmpDescribeServerCertificatesRspBo.getCACertificates()) {
                    RsCertificateListPageQueryAbilityBo rsCertificateListPageQueryAbilityBo = new RsCertificateListPageQueryAbilityBo();
                    rsCertificateListPageQueryAbilityBo.setCertificateId(certificate.getCertificateId());
                    rsCertificateListPageQueryAbilityBo.setCertificateName(certificate.getCertificateName());
                    rsCertificateListPageQueryAbilityBo.setCertificateSource("");
                    rsCertificateListPageQueryAbilityBo.setCertificateType(certificate.getCertificateType());
                    if (RsDictionaryValueConstants.CERTIFICATE_TYPE_SERVICE.equals(Integer.valueOf(certificate.getCertificateType()))) {
                        rsCertificateListPageQueryAbilityBo.setCertificateTypeDesc("\u670d\u52a1\u5668\u8bc1\u4e66");
                    } else {
                        rsCertificateListPageQueryAbilityBo.setCertificateTypeDesc("CA\u8bc1\u4e66");
                    }
                    rsCertificateListPageQueryAbilityBo.setCertificateDomainName(certificate.getCommonName());
                    rsCertificateListPageQueryAbilityBo.setResourceGroup(certificate.getResourceGroupId());
                    RsInfoCertificatePo rsInfoCertificatePo = new RsInfoCertificatePo();
                    rsInfoCertificatePo.setCertificateId(rsCertificateListPageQueryAbilityBo.getCertificateId());
                    List<RsInfoCertificatePo> rsInfoCertificatePos = this.rsInfoCertificateMapper.selectList(rsInfoCertificatePo);
                    if (!CollectionUtils.isEmpty(rsInfoCertificatePos)) {
                        rsCertificateListPageQueryAbilityBo.setAccountId(rsInfoCertificatePos.get(0).getAccountId());
                        rsCertificateListPageQueryAbilityBo.setPlatformId(rsInfoCertificatePos.get(0).getPlatformId());
                    }
                    RsRelCertificateRegionPo rsRelCertificateRegionPo = new RsRelCertificateRegionPo();
                    rsRelCertificateRegionPo.setCertificateId(rsCertificateListPageQueryAbilityBo.getCertificateId());
                    List<RsRelCertificateRegionPo> rsRelCertificateRegionPos = this.rsRelCertificateRegionMapper.selectList(rsRelCertificateRegionPo);
                    ArrayList<RsCertificateCreateAbilityReqBo.RegionInfo> regionInfos = new ArrayList<RsCertificateCreateAbilityReqBo.RegionInfo>();
                    if (!CollectionUtils.isEmpty(rsRelCertificateRegionPos)) {
                        for (RsRelCertificateRegionPo rsRelCertificateRegionPo1 : rsRelCertificateRegionPos) {
                            RsCertificateCreateAbilityReqBo.RegionInfo regionInfo = new RsCertificateCreateAbilityReqBo.RegionInfo();
                            regionInfo.setRegionId(rsRelCertificateRegionPo1.getRegionId());
                            regionInfo.setRegionName(rsRelCertificateRegionPo1.getRegionName());
                            regionInfos.add(regionInfo);
                        }
                        rsCertificateListPageQueryAbilityBo.setRegionInfoList(regionInfos);
                    }
                    rsCertificateListPageQueryAbilityBos.add(rsCertificateListPageQueryAbilityBo);
                }
            }
        }
        List list = PageList.startPage(rsCertificateListPageQueryAbilityBos, (Integer)reqBo.getPageNo(), (Integer)reqBo.getPageSize());
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(Integer.valueOf(rsCertificateListPageQueryAbilityBos.size()));
        Integer pageCount = 0;
        pageCount = rspBo.getRecordsTotal() % reqBo.getPageSize() == 0 ? Integer.valueOf(rspBo.getRecordsTotal() / reqBo.getPageSize()) : Integer.valueOf(rspBo.getRecordsTotal() / reqBo.getPageSize() + 1);
        rspBo.setTotal(pageCount);
        rspBo.setRows(list);
        return rspBo;
    }
}

