/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.vpc.McmpCreateVSwitchService;
import com.tydic.mcmp.intf.api.vpc.bo.McmpCreateVSwitchReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpCreateVSwitchRspBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsCreateInterchangerAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateInterchangerAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateInterchangerAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.dao.RsInfoInterchangerMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoVpcMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoInterchangerPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoVpcPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsCreateInterchangerAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsCreateInterchangerAbilityService"})
public class RsCreateInterchangerAbilityServiceImpl
implements RsCreateInterchangerAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoInterchangerMapper rsInfoInterchangerMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoVpcMapper rsInfoVpcMapper;
    @Autowired
    private McmpCreateVSwitchService mcmpCreateVSwitchService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"createInterchanger"})
    public RsCreateInterchangerAbilityRspBo createInterchanger(@RequestBody RsCreateInterchangerAbilityReqBo reqBo) {
        this.LOGGER.info("----------------------\u521b\u5efa\u4ea4\u6362\u673a Ability\u670d\u52a1----------------------");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsCreateInterchangerAbilityRspBo rspBo = new RsCreateInterchangerAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("4069");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBo;
        }
        RsQueryAliParamAtomReqBo qryParam = new RsQueryAliParamAtomReqBo();
        qryParam.setTenementId(reqBo.getTenementId());
        qryParam.setPlatformId(reqBo.getPlatformId());
        qryParam.setAccountId(reqBo.getAccountId());
        RsQueryAliParamAtomRspBo paramAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(qryParam);
        if (!"0000".equals(paramAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsCreateInterchangerAbilityRspBo.class, paramAtomRspBo.getRespDesc(), paramAtomRspBo.getRespCode());
        }
        McmpCreateVSwitchReqBO mcmpCreateVSwitchReqBO = new McmpCreateVSwitchReqBO();
        mcmpCreateVSwitchReqBO.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)mcmpCreateVSwitchReqBO);
        BeanUtils.copyProperties((Object)reqBo, (Object)mcmpCreateVSwitchReqBO);
        mcmpCreateVSwitchReqBO.setVSwitchName(reqBo.getInterchangerName());
        mcmpCreateVSwitchReqBO.setDescription(reqBo.getInterchangerDesc());
        mcmpCreateVSwitchReqBO.setCidrBlock(reqBo.getIpv4Scope());
        this.LOGGER.debug("\u8c03\u7528\u63a5\u53e3\u7ec4\u521b\u5efa\u4ea4\u6362\u673a\u5165\u53c2\uff1a" + JSON.toJSON((Object)mcmpCreateVSwitchReqBO));
        McmpCreateVSwitchRspBO mcmpCreateVSwitchRspBO = this.mcmpCreateVSwitchService.createVSwitch(mcmpCreateVSwitchReqBO);
        if (!"0000".equals(mcmpCreateVSwitchRspBO.getRespCode())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc(mcmpCreateVSwitchRspBO.getRespDesc());
            return rspBo;
        }
        RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
        Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoResourcePo);
        rsInfoResourcePo.setResourceName("\u4ea4\u6362\u673a");
        rsInfoResourcePo.setResourceId(resourceId);
        rsInfoResourcePo.setInstanceId(mcmpCreateVSwitchRspBO.getVSwitchId());
        rsInfoResourcePo.setCreateTime(new Date());
        rsInfoResourcePo.setServiceId(13L);
        this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
        RsInfoInterchangerPo rsInfoInterchangerPo = new RsInfoInterchangerPo();
        RsInfoVpcPo rsInfoVpcPo = new RsInfoVpcPo();
        rsInfoVpcPo.setVpcId(reqBo.getVpcId());
        RsInfoVpcPo vpcPo = this.rsInfoVpcMapper.queryModelBy(rsInfoVpcPo);
        if (null != vpcPo) {
            rsInfoInterchangerPo.setVpcResourceId(vpcPo.getResourceId());
            rsInfoInterchangerPo.setVpcName(vpcPo.getVpcName());
        }
        BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoInterchangerPo);
        rsInfoInterchangerPo.setResourceId(resourceId);
        rsInfoInterchangerPo.setInterchangerId(mcmpCreateVSwitchRspBO.getVSwitchId());
        this.rsInfoInterchangerMapper.insertSelective(rsInfoInterchangerPo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        this.LOGGER.info("----------------------\u521b\u5efa\u4ea4\u6362\u673a Ability\u670d\u52a1\u7ed3\u675f----------------------");
        return rspBo;
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

