/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.ability.api.RsCreateIpPoolAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateIpPoolAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateIpPoolAbilityRspBo;
import com.tydic.mcmp.resource.busi.api.RsCheckIpPoolBusiService;
import com.tydic.mcmp.resource.busi.api.RsCreateIpPoolBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCheckIpPoolBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCheckIpPoolBusiRspBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateIpPoolBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateIpPoolBusiRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsCreateIpPoolAbilityService"})
public class RsCreateIpPoolAbilityServiceImpl
implements RsCreateIpPoolAbilityService {
    @Autowired
    private RsCheckIpPoolBusiService rsCheckIpPoolBusiService;
    @Autowired
    private RsCreateIpPoolBusiService rsCreateIpPoolBusiService;

    @PostMapping(value={"createIpPool"})
    public RsCreateIpPoolAbilityRspBo createIpPool(@RequestBody RsCreateIpPoolAbilityReqBo abilityReqBo) {
        RsCreateIpPoolAbilityRspBo abilityRspBo = new RsCreateIpPoolAbilityRspBo();
        this.validParam(abilityReqBo);
        RsCheckIpPoolBusiReqBo rsCheckIpPoolBusiReqBo = new RsCheckIpPoolBusiReqBo();
        rsCheckIpPoolBusiReqBo.setIpEnd(abilityReqBo.getIpEnd());
        rsCheckIpPoolBusiReqBo.setIpStart(abilityReqBo.getIpStart());
        rsCheckIpPoolBusiReqBo.setIpNetmask(abilityReqBo.getIpNetmask());
        RsCheckIpPoolBusiRspBo rsCheckIpPoolBusiRspBo = this.rsCheckIpPoolBusiService.checkIpPool(rsCheckIpPoolBusiReqBo);
        if (!"0000".equals(rsCheckIpPoolBusiRspBo.getRespCode())) {
            throw new McmpBusinessException(rsCheckIpPoolBusiRspBo.getRespCode(), rsCheckIpPoolBusiRspBo.getRespDesc());
        }
        RsCreateIpPoolBusiReqBo busiReqBo = new RsCreateIpPoolBusiReqBo();
        BeanUtils.copyProperties((Object)abilityReqBo, (Object)busiReqBo);
        busiReqBo.setIps(rsCheckIpPoolBusiRspBo.getIps());
        RsCreateIpPoolBusiRspBo busiRspBo = this.rsCreateIpPoolBusiService.createIpPool(busiReqBo);
        BeanUtils.copyProperties((Object)busiRspBo, (Object)abilityRspBo);
        return abilityRspBo;
    }

    private void validParam(RsCreateIpPoolAbilityReqBo abilityReqBo) {
        if (null == abilityReqBo) {
            throw new McmpBusinessException("24000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getVmDataCenterId())) {
            throw new McmpBusinessException("24001", "\u6570\u636e\u4e2d\u5fc3ID\u3010vmDataCenterId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getVmSwitchId())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u4ea4\u6362\u673aID\u3010vmSwitchId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getIpStart())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u5f00\u59cbIP\u5730\u5740\u3010ipStart\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getIpEnd())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u7ed3\u675fIP\u5730\u5740\u3010ipEnd\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getIpNetwork())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u63a9\u7801\u3010ipNetmask\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getIpNetmask())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u7f51\u5173\u3010ipNetwork\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

