/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceCreateMasterSlaveServerGroupService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceCreateMasterSlaveServerGroupReqBO;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceCreateMasterSlaveServerGroupRspBO;
import com.tydic.mcmp.resource.ability.api.RsCreateMasterSlaveServerGroupAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateMasterSlaveServerGroupAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateMasterSlaveServerGroupAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.common.bo.RsMasterSlaveBackendServerBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsCreateMasterSlaveServerGroupAbilityService"})
public class RsCreateMasterSlaveServerGroupAbilityServiceImpl
implements RsCreateMasterSlaveServerGroupAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsCreateMasterSlaveServerGroupAbilityServiceImpl.class);
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpLoadBalanceCreateMasterSlaveServerGroupService mcmpLoadBalanceCreateMasterSlaveServerGroupService;

    @PostMapping(value={"createMasterSlaveServerGroup"})
    public RsCreateMasterSlaveServerGroupAbilityRspBo createMasterSlaveServerGroup(@RequestBody RsCreateMasterSlaveServerGroupAbilityReqBo abilityReqBo) {
        RsCreateMasterSlaveServerGroupAbilityRspBo abilityRspBo = new RsCreateMasterSlaveServerGroupAbilityRspBo();
        this.validParam(abilityReqBo);
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(abilityReqBo.getAccountId());
        atomReqBo.setPlatformId(abilityReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        McmpLoadBalanceCreateMasterSlaveServerGroupReqBO slaveServerGroupReqBO = new McmpLoadBalanceCreateMasterSlaveServerGroupReqBO();
        slaveServerGroupReqBO.setCloudType(RsInterfaceUtil.convertCloudType(abilityReqBo.getPlatformId()));
        slaveServerGroupReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        slaveServerGroupReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        slaveServerGroupReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        slaveServerGroupReqBO.setProxyHost(atomRspBo.getProxyHost());
        slaveServerGroupReqBO.setProxyPort(atomRspBo.getProxyPort());
        if (StringUtils.hasText((String)abilityReqBo.getRegionId())) {
            slaveServerGroupReqBO.setRegion(abilityReqBo.getRegionId());
        }
        slaveServerGroupReqBO.setLoadBalancerId(abilityReqBo.getLoadBalancerId());
        slaveServerGroupReqBO.setMasterSlaveServerGroupName(abilityReqBo.getMasterSlaveServerGroupName());
        slaveServerGroupReqBO.setMasterSlaveBackendServers(JSON.toJSONString((Object)abilityReqBo.getRsMasterSlaveBackendServerBos()));
        log.info("\u8d1f\u8f7d\u5747\u8861\u4e3b\u5907\u670d\u52a1\u5668\u7ec4\u6dfb\u52a0API\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)slaveServerGroupReqBO));
        McmpLoadBalanceCreateMasterSlaveServerGroupRspBO slaveServerGroupRspBO = this.mcmpLoadBalanceCreateMasterSlaveServerGroupService.createMasterSlaveServerGroup(slaveServerGroupReqBO);
        log.info("\u8d1f\u8f7d\u5747\u8861\u4e3b\u5907\u670d\u52a1\u5668\u7ec4\u6dfb\u52a0API\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)slaveServerGroupRspBO));
        if (!"0000".equals(slaveServerGroupRspBO.getRespCode())) {
            throw new McmpBusinessException(slaveServerGroupRspBO.getRespCode(), slaveServerGroupRspBO.getRespDesc());
        }
        abilityRspBo.setMasterSlaveServerGroupId(slaveServerGroupRspBO.getMasterSlaveServerGroupId());
        abilityRspBo.setRespCode("0000");
        abilityRspBo.setRespDesc("\u6dfb\u52a0\u6210\u529f");
        return abilityRspBo;
    }

    private void validParam(RsCreateMasterSlaveServerGroupAbilityReqBo abilityReqBo) {
        if (null == abilityReqBo) {
            throw new McmpBusinessException("24000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (abilityReqBo.getPlatformId() == null) {
            throw new McmpBusinessException("24001", "\u4e91\u5e73\u53f0ID\u3010platformId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBo.getAccountId() == null) {
            throw new McmpBusinessException("24001", "\u8d26\u6237ID\u3010accountId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getLoadBalancerId())) {
            throw new McmpBusinessException("24001", "\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8bID\u3010loadBalancerId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)abilityReqBo.getRsMasterSlaveBackendServerBos())) {
            throw new McmpBusinessException("24001", "\u4e3b\u5907\u670d\u52a1\u5668\u7ec4\u5217\u8868\u3010rsMasterSlaveBackendServerBos\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBo.getRsMasterSlaveBackendServerBos().size() != 2) {
            throw new McmpBusinessException("24001", "\u4e3b\u5907\u670d\u52a1\u5668\u7ec4\u5217\u8868\u5fc5\u987b\u5305\u542b2\u6761");
        }
        Boolean masterFlag = false;
        Boolean slaveFlag = false;
        for (RsMasterSlaveBackendServerBo rsMasterSlaveBackendServerBo : abilityReqBo.getRsMasterSlaveBackendServerBos()) {
            if (rsMasterSlaveBackendServerBo.getPort() == null) {
                throw new McmpBusinessException("24001", "\u540e\u7aef\u670d\u52a1\u5668\u4f7f\u7528\u7684\u7aef\u53e3\u3010port\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)rsMasterSlaveBackendServerBo.getServerId())) {
                throw new McmpBusinessException("24001", "\u540e\u7aef\u670d\u52a1\u5668\u5b9e\u4f8bID\u3010serverId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)rsMasterSlaveBackendServerBo.getServerType())) {
                throw new McmpBusinessException("24001", "\u540e\u7aef\u670d\u52a1\u5668\u7684\u4e3b\u5907\u7c7b\u578b\u3010serverType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if ("Master".equals(rsMasterSlaveBackendServerBo.getServerType())) {
                masterFlag = true;
                continue;
            }
            if ("Slave".equals(rsMasterSlaveBackendServerBo.getServerType())) {
                slaveFlag = true;
                continue;
            }
            throw new McmpBusinessException("24001", "\u540e\u7aef\u670d\u52a1\u5668\u7684\u4e3b\u5907\u7c7b\u578b\u3010serverType\u3011\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        if (!masterFlag.booleanValue()) {
            throw new McmpBusinessException("24001", "\u540e\u7aef\u670d\u52a1\u5668\u5fc5\u987b\u5305\u542b\u4e3b\u670d\u52a1\u5668");
        }
        if (!slaveFlag.booleanValue()) {
            throw new McmpBusinessException("24001", "\u540e\u7aef\u670d\u52a1\u5668\u5fc5\u987b\u5305\u542b\u4e3b\u5907\u670d\u52a1\u5668");
        }
    }
}

