/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.vpc.McmpCreateVSwitchService;
import com.tydic.mcmp.intf.api.vpc.McmpCreateVpcBusiService;
import com.tydic.mcmp.intf.api.vpc.McmpDescribeVpcsBusiService;
import com.tydic.mcmp.intf.api.vpc.bo.McmpCreateVSwitchReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpCreateVSwitchRspBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpCreateVpcReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpCreateVpcRspBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVpcsReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVpcsRspBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsCreateVpcAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateVpcAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsCreateVpcAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsInterchangerInfoBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoInterchangerMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoVpcMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoInterchangerPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoVpcPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsCreateVpcAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsCreateVpcAbilityService"})
public class RsCreateVpcAbilityServiceImpl
implements RsCreateVpcAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoVpcMapper rsInfoVpcMapper;
    @Autowired
    private RsInfoInterchangerMapper rsInfoInterchangerMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private McmpCreateVpcBusiService mcmpCreateVpcBusiService;
    @Autowired
    private McmpCreateVSwitchService mcmpCreateVSwitchService;
    @Autowired
    private McmpDescribeVpcsBusiService mcmpDescribeVpcsBusiService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"createVpc"})
    public RsCreateVpcAbilityRspBo createVpc(@RequestBody RsCreateVpcAbilityReqBo reqBo) {
        this.LOGGER.info("----------------------\u521b\u5efa\u4e13\u6709\u7f51\u7edc Ability\u670d\u52a1----------------------");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsCreateVpcAbilityRspBo rspBo = new RsCreateVpcAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("4065");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBo;
        }
        RsQueryAliParamAtomReqBo qryParam = new RsQueryAliParamAtomReqBo();
        qryParam.setTenementId(reqBo.getTenementId());
        qryParam.setPlatformId(reqBo.getPlatformId());
        qryParam.setAccountId(reqBo.getAccountId());
        RsQueryAliParamAtomRspBo paramAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(qryParam);
        if (!"0000".equals(paramAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsCreateVpcAbilityRspBo.class, paramAtomRspBo.getRespDesc(), paramAtomRspBo.getRespCode());
        }
        McmpDescribeVpcsReqBO mcmpDescribeVpcsReqBO = new McmpDescribeVpcsReqBO();
        mcmpDescribeVpcsReqBO.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)mcmpDescribeVpcsReqBO);
        mcmpDescribeVpcsReqBO.setRegionId(reqBo.getRegionId());
        this.LOGGER.debug("\u8c03\u7528\u63a5\u53e3\u7ec4\u67e5\u8be2\u4e13\u6709\u7f51\u7edc\u5165\u53c2\uff1a" + JSON.toJSON((Object)mcmpDescribeVpcsReqBO));
        McmpDescribeVpcsRspBO describeVpcsRspBO = this.mcmpDescribeVpcsBusiService.describeVpcs(mcmpDescribeVpcsReqBO);
        if (!"0000".equals(describeVpcsRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsCreateVpcAbilityRspBo.class, describeVpcsRspBO.getRespDesc(), describeVpcsRspBO.getRespCode());
        }
        if (describeVpcsRspBO.getVpcs().size() >= RsDictionaryValueConstants.RS_REGION_VPC_MAX) {
            rspBo.setRespCode("4065");
            rspBo.setRespDesc("\u8be5\u5730\u57df\u4e13\u6709\u7f51\u7edc\u5df2\u8fbe\u5230\u914d\u989d\u4e0a\u9650\uff0c\u8bf7\u66f4\u6362\u5730\u57df\u540e\u518d\u5c1d\u8bd5\u521b\u5efa");
            return rspBo;
        }
        McmpCreateVpcReqBO createVpcReqBO = new McmpCreateVpcReqBO();
        createVpcReqBO.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)createVpcReqBO);
        BeanUtils.copyProperties((Object)reqBo, (Object)createVpcReqBO);
        createVpcReqBO.setCidrBlock(reqBo.getNetScope());
        createVpcReqBO.setDescription(reqBo.getVpcDesc());
        createVpcReqBO.setResourceGroupId(reqBo.getResourceGroupId());
        this.LOGGER.debug("\u8c03\u7528\u63a5\u53e3\u7ec4\u521b\u5efa\u4e13\u6709\u7f51\u7edc\u5165\u53c2\uff1a" + JSON.toJSON((Object)createVpcReqBO));
        McmpCreateVpcRspBO mcmpCreateVpcRspBO = this.mcmpCreateVpcBusiService.createVpc(createVpcReqBO);
        if (!"0000".equals(mcmpCreateVpcRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsCreateVpcAbilityRspBo.class, mcmpCreateVpcRspBO.getRespDesc(), mcmpCreateVpcRspBO.getRespCode());
        }
        this.LOGGER.debug("\u8c03\u7528\u63a5\u53e3\u7ec4\u521b\u5efa\u4e13\u6709\u7f51\u7edc\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)mcmpCreateVpcRspBO));
        RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
        Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoResourcePo);
        rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
        rsInfoResourcePo.setResourceName("\u4e13\u6709\u7f51\u7edc");
        rsInfoResourcePo.setResourceId(resourceId);
        rsInfoResourcePo.setInstanceId(mcmpCreateVpcRspBO.getVpcId());
        rsInfoResourcePo.setServiceId(12L);
        rsInfoResourcePo.setCreateTime(new Date());
        int rsCount = this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
        if (rsCount > 0) {
            RsInfoVpcPo rsInfoVpcPo = new RsInfoVpcPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoVpcPo);
            rsInfoVpcPo.setResourceId(resourceId);
            rsInfoVpcPo.setVpcId(mcmpCreateVpcRspBO.getVpcId());
            rsInfoVpcPo.setDefaultVpc(RsDictionaryValueConstants.RS_INFO_VPC_DEFAULT_VPC_NO);
            rsInfoVpcPo.setResourceGroup(mcmpCreateVpcRspBO.getResourceGroupId());
            this.rsInfoVpcMapper.insertSelective(rsInfoVpcPo);
        }
        McmpDescribeVpcsReqBO describeVpcsReqBO = new McmpDescribeVpcsReqBO();
        describeVpcsReqBO.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)describeVpcsReqBO);
        BeanUtils.copyProperties((Object)reqBo, (Object)describeVpcsReqBO);
        describeVpcsReqBO.setVpcId(mcmpCreateVpcRspBO.getVpcId());
        this.LOGGER.debug("\u8c03\u7528\u63a5\u53e3\u7ec4\u67e5\u8be2\u4e13\u6709\u7f51\u7edc\u5165\u53c2\uff1a" + JSON.toJSON((Object)describeVpcsReqBO));
        McmpDescribeVpcsRspBO mcmpDescribeVpcsRspBO = this.mcmpDescribeVpcsBusiService.describeVpcs(describeVpcsReqBO);
        if (!"0000".equals(mcmpCreateVpcRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsCreateVpcAbilityRspBo.class, mcmpDescribeVpcsRspBO.getRespDesc(), mcmpDescribeVpcsRspBO.getRespCode());
        }
        while (!((McmpDescribeVpcsRspBO.Vpc)mcmpDescribeVpcsRspBO.getVpcs().get(0)).getStatus().equals("Available")) {
            mcmpDescribeVpcsRspBO = this.mcmpDescribeVpcsBusiService.describeVpcs(describeVpcsReqBO);
        }
        this.LOGGER.debug("\u4e13\u6709\u7f51\u7edc\u521b\u5efa\u6210\u529f,\u51c6\u5907\u521b\u5efa\u4ea4\u6362\u673a");
        for (RsInterchangerInfoBo rsInterchangerInfoBo : reqBo.getRsInterchangerInfoBoList()) {
            McmpCreateVSwitchReqBO createVSwitchReqBO = new McmpCreateVSwitchReqBO();
            createVSwitchReqBO.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
            RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)createVSwitchReqBO);
            BeanUtils.copyProperties((Object)reqBo, (Object)createVSwitchReqBO);
            createVSwitchReqBO.setCidrBlock(rsInterchangerInfoBo.getIpv4Scope());
            createVSwitchReqBO.setDescription(rsInterchangerInfoBo.getInterchangerDesc());
            createVSwitchReqBO.setVSwitchName(rsInterchangerInfoBo.getInterchangerName());
            createVSwitchReqBO.setZoneId(rsInterchangerInfoBo.getZoneId());
            createVSwitchReqBO.setVpcId(mcmpCreateVpcRspBO.getVpcId());
            this.LOGGER.debug("\u8c03\u7528\u63a5\u53e3\u7ec4\u521b\u5efa\u4ea4\u6362\u673a\u5165\u53c2\uff1a" + JSON.toJSON((Object)createVSwitchReqBO));
            McmpCreateVSwitchRspBO createVSwitchRspBO = this.mcmpCreateVSwitchService.createVSwitch(createVSwitchReqBO);
            if (!"0000".equals(mcmpCreateVpcRspBO.getRespCode())) {
                return RsRspBoUtil.genFailedBo(RsCreateVpcAbilityRspBo.class, createVSwitchRspBO.getRespDesc(), createVSwitchRspBO.getRespCode());
            }
            Long rsId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
            BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoResourcePo);
            rsInfoResourcePo.setResourceName("\u4ea4\u6362\u673a");
            rsInfoResourcePo.setResourceId(rsId);
            rsInfoResourcePo.setInstanceId(createVSwitchRspBO.getVSwitchId());
            rsInfoResourcePo.setServiceId(13L);
            rsInfoResourcePo.setCreateTime(new Date());
            this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
            RsInfoInterchangerPo rsInfoInterchangerPo = new RsInfoInterchangerPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoInterchangerPo);
            BeanUtils.copyProperties((Object)rsInterchangerInfoBo, (Object)rsInfoInterchangerPo);
            rsInfoInterchangerPo.setInterchangerId(createVSwitchRspBO.getVSwitchId());
            rsInfoInterchangerPo.setResourceId(rsId);
            rsInfoInterchangerPo.setVpcResourceId(resourceId);
            rsInfoInterchangerPo.setVpcId(mcmpCreateVpcRspBO.getVpcId());
            rsInfoInterchangerPo.setResourceGroup(mcmpCreateVpcRspBO.getResourceGroupId());
            this.rsInfoInterchangerMapper.insertSelective(rsInfoInterchangerPo);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        this.LOGGER.info("----------------------\u521b\u5efa\u4e13\u6709\u7f51\u7edc Ability\u670d\u52a1\u7ed3\u675f----------------------");
        return rspBo;
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

