/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.ability.api.RsInitializeVmareIpAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsInitializeVmareIpAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsInitializeVmareIpAbilityRspBo;
import com.tydic.mcmp.resource.common.bo.RsInfoResourceVmwareBo;
import com.tydic.mcmp.resource.common.bo.RsInfoVmIpPoolBo;
import com.tydic.mcmp.resource.common.bo.RsUpdateResourceStatusBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceVmwareMapper;
import com.tydic.mcmp.resource.dao.RsInfoVmIpPoolMapper;
import com.tydic.mcmp.resource.time.job.RsDealVmUpdateIpJob;
import com.tydic.starter.timing.job.bo.SendTaskBo;
import com.tydic.starter.timing.job.core.TimingTaskSender;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsInitializeVmareIpAbilityService"})
public class RsInitializeVmareIpAbilityServiceImpl
implements RsInitializeVmareIpAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsInitializeVmareIpAbilityServiceImpl.class);
    @Autowired
    private RsInfoResourceVmwareMapper rsInfoResourceVmwareMapper;
    @Autowired
    private RsInfoVmIpPoolMapper rsInfoVmIpPoolMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private TimingTaskSender rsTaskSender;

    @PostMapping(value={"dealInitializeVmareIp"})
    public RsInitializeVmareIpAbilityRspBo dealInitializeVmareIp(@RequestBody RsInitializeVmareIpAbilityReqBo abilityReqBo) {
        RsInitializeVmareIpAbilityRspBo abilityRspBo = new RsInitializeVmareIpAbilityRspBo();
        this.validParam(abilityReqBo);
        RsInfoResourceVmwareBo rsInfoResourceVmwareBo = this.rsInfoResourceVmwareMapper.selectById(abilityReqBo.getVmResourceId());
        if (rsInfoResourceVmwareBo == null) {
            throw new McmpBusinessException("24003", "\u865a\u62df\u673a\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        RsUpdateResourceStatusBo rsUpdateResourceStatusBo = new RsUpdateResourceStatusBo();
        if (StringUtils.hasText((String)rsInfoResourceVmwareBo.getInnerIpAddress())) {
            RsInfoVmIpPoolBo rsInfoVmIpPoolBoReq = new RsInfoVmIpPoolBo();
            rsInfoVmIpPoolBoReq.setVmDataCenterId(rsInfoResourceVmwareBo.getVmDataCenterId());
            rsInfoVmIpPoolBoReq.setVmSwitchId(rsInfoResourceVmwareBo.getVmSwitchId());
            rsInfoVmIpPoolBoReq.setIp(rsInfoResourceVmwareBo.getInnerIpAddress());
            RsInfoVmIpPoolBo rsInfoVmIpPoolBoRsp = this.rsInfoVmIpPoolMapper.selectForInitializeVmareIp(rsInfoVmIpPoolBoReq);
            if (rsInfoVmIpPoolBoRsp == null) {
                throw new McmpBusinessException("24003", "IP\u914d\u7f6e\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
            rsUpdateResourceStatusBo.setStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_IP_CONFIG);
            this.invokeSendVmCustomizationSet(rsInfoResourceVmwareBo, rsInfoVmIpPoolBoRsp);
        }
        rsUpdateResourceStatusBo.setResourceId(abilityReqBo.getVmResourceId());
        rsUpdateResourceStatusBo.setServiceId(Long.valueOf(11L));
        rsUpdateResourceStatusBo.setStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_STOP);
        int count1 = this.rsInfoResourceMapper.updateByStatus(rsUpdateResourceStatusBo);
        if (count1 != 1) {
            throw new McmpBusinessException("24012", "\u8d44\u6e90\u4fe1\u606f\u4fee\u6539\u5931\u8d25");
        }
        abilityRspBo.setRespCode("0000");
        abilityRspBo.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return abilityRspBo;
    }

    private void invokeSendVmCustomizationSet(RsInfoResourceVmwareBo rsInfoResourceVmwareBo, RsInfoVmIpPoolBo rsInfoVmIpPoolBoRsp) {
        SendTaskBo taskBo = new SendTaskBo();
        String jobGroup = "VM_UPDATE_IP_JOB_GROUP";
        String triggerGroup = "VM_UPDATE_IP_TRIGGER_GROUP";
        String suffix = System.currentTimeMillis() + "";
        int triggerTime = 1;
        taskBo.setJobGroupName(jobGroup);
        taskBo.setTriggerGroupName(triggerGroup);
        taskBo.setJobClass(RsDealVmUpdateIpJob.class);
        taskBo.setJsonKey("VM_UPDATE_IP_JSON_KEY");
        taskBo.setTriggerTime(triggerTime);
        taskBo.setJobKey(jobGroup + "_" + suffix);
        taskBo.setTriggerKey(triggerGroup + "_" + suffix);
        HashMap<String, Object> content = new HashMap<String, Object>();
        content.put("resourceId", rsInfoResourceVmwareBo.getVmResourceId());
        content.put("accountId", rsInfoResourceVmwareBo.getAccountId());
        content.put("instanceId", rsInfoResourceVmwareBo.getInstanceId());
        content.put("vmName", rsInfoResourceVmwareBo.getVmName());
        content.put("ip", rsInfoResourceVmwareBo.getInnerIpAddress());
        content.put("ipNetwork", rsInfoVmIpPoolBoRsp.getIpNetwork());
        content.put("ipNetmask", rsInfoVmIpPoolBoRsp.getIpNetmask());
        taskBo.setJsonValue(JSON.toJSONString(content));
        this.rsTaskSender.sendTask(taskBo);
    }

    private void validParam(RsInitializeVmareIpAbilityReqBo abilityReqBo) {
        if (null == abilityReqBo) {
            throw new McmpBusinessException("24000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (null == abilityReqBo.getVmResourceId()) {
            throw new McmpBusinessException("24001", "\u8d44\u6e90ID\u3010vmResourceId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

