/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceInsDescribeDetailService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceInsDescribeDetailReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceInsDescribeDetailRspBo;
import com.tydic.mcmp.resource.ability.api.RsLoadBalanceDetailQueryAblityService;
import com.tydic.mcmp.resource.ability.api.bo.RsLoadBalanceDetailQueryAblityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsLoadBalanceDetailQueryAblityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.dao.RsInfoAliSlbSpecMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoAliSlbSpecPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsLoadBalanceDetailQueryAblityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsLoadBalanceDetailQueryAblityService"})
public class RsLoadBalanceDetailQueryAblityServiceImpl
implements RsLoadBalanceDetailQueryAblityService {
    private static final Logger log = LoggerFactory.getLogger(RsLoadBalanceDetailQueryAblityServiceImpl.class);
    @Autowired
    private McmpLoadBalanceInsDescribeDetailService mcmpLoadBalanceInsDescribeDetailService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoAliSlbSpecMapper rsInfoAliSlbSpecMapper;

    @PostMapping(value={"qrySlbDetail"})
    public RsLoadBalanceDetailQueryAblityRspBo qrySlbDetail(@RequestBody RsLoadBalanceDetailQueryAblityReqBo reqBo) {
        List<RsInfoAliSlbSpecPo> specRetBos;
        log.info("=======================\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u8be6\u60c5\u67e5\u8be2Ability\u670d\u52a1\u5f00\u59cb=========================");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        RsLoadBalanceDetailQueryAblityRspBo retBo = new RsLoadBalanceDetailQueryAblityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        RsInfoResourcePo resourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(reqBo.getResourceId());
        if (null == resourcePo) {
            throw new McmpBusinessException("9000", "\u6ca1\u6709\u67e5\u8be2\u5230\u8d44\u6e90\uff08" + reqBo.getResourceId() + "\uff09\u7684\u4fe1\u606f");
        }
        McmpLoadBalanceInsDescribeDetailRspBo interfaceRetBo = this.invokeInf(reqBo, resourcePo);
        log.info("\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)interfaceRetBo));
        if (!"0000".equals(interfaceRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u67e5\u8be2\u5b9e\u4f8b\u8be6\u60c5\u5931\u8d25\uff1a" + interfaceRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)interfaceRetBo, (Object)retBo);
            return retBo;
        }
        BeanUtils.copyProperties((Object)interfaceRetBo, (Object)retBo);
        retBo.setLoadBalanceStatusDesc(RsInterfaceUtil.transAliSlbStatus(retBo.getLoadBalancerStatus()));
        retBo.setNetworkTypeDesc(RsInterfaceUtil.transAliSlbNetworkType(retBo.getNetworkType()));
        retBo.setInternetChargeTypeDesc(RsInterfaceUtil.transAliSlbChargeType(retBo.getInternetChargeType()));
        retBo.setPayTypeDesc(RsInterfaceUtil.transPayType(retBo.getPayType()));
        retBo.setAddressType(RsInterfaceUtil.transAddressType(retBo.getAddressType()));
        RsInfoAliSlbSpecPo specReqPo = new RsInfoAliSlbSpecPo();
        specReqPo.setLoadBalanceSpec("slb.share");
        if (!StringUtils.isEmpty((Object)retBo.getLoadBalancerSpec())) {
            specReqPo.setLoadBalanceSpec(retBo.getLoadBalancerSpec());
        }
        if (!CollectionUtils.isEmpty(specRetBos = this.rsInfoAliSlbSpecMapper.selectByCondition(specReqPo))) {
            RsInfoAliSlbSpecPo specPo = specRetBos.get(0);
            retBo.setLoadBalancerSpecDesc(specPo.getLoadBalanceName());
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        log.info("=======================\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u8be6\u60c5\u67e5\u8be2Ability\u670d\u52a1\u7ed3\u675f=========================");
        return retBo;
    }

    private McmpLoadBalanceInsDescribeDetailRspBo invokeInf(RsLoadBalanceDetailQueryAblityReqBo reqBo, RsInfoResourcePo resourcePo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u7528\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpLoadBalanceInsDescribeDetailReqBo invokeReqBo = new McmpLoadBalanceInsDescribeDetailReqBo();
        if (2L == reqBo.getPlatformId()) {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            invokeReqBo.setProxyHost(atomRetBo.getProxyHost());
            invokeReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        invokeReqBo.setRegion(resourcePo.getRegionId());
        invokeReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        invokeReqBo.setLoadBalancerId(resourcePo.getInstanceId());
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)invokeReqBo));
        return this.mcmpLoadBalanceInsDescribeDetailService.describeDetail(invokeReqBo);
    }
}

