/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceListenerCreateService;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceListenerModifyService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpAliLoadBalanceListenerDataBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceListenerCreateReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceListenerCreateRspBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceListenerModifyReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceListenerModifyRspBo;
import com.tydic.mcmp.resource.ability.api.RsLoadBalanceListenerAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsLoadBalanceListenerAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsLoadBalanceListenerAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsLoadBalanceListenerAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsLoadBalanceListenerAbilityService"})
public class RsLoadBalanceListenerAbilityServiceImpl
implements RsLoadBalanceListenerAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsLoadBalanceListenerAbilityServiceImpl.class);
    private final String[] listenerTypes = new String[]{"TCP", "UDP", "HTTP", "HTTPS"};
    private final String[] actionType = new String[]{"ADD", "MODIFY"};
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpLoadBalanceListenerCreateService mcmpLoadBalanceListenerCreateService;
    @Autowired
    private McmpLoadBalanceListenerModifyService mcmpLoadBalanceListenerModifyService;

    @PostMapping(value={"dealSlbListener"})
    public RsLoadBalanceListenerAbilityRspBo dealSlbListener(@RequestBody RsLoadBalanceListenerAbilityReqBo reqBo) {
        log.info("===================\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u76d1\u542c\u6dfb\u52a0/\u4fee\u6539\u670d\u52a1\u5f00\u59cb==================");
        log.info("\u5165\u53c2\uff1a" + reqBo);
        RsLoadBalanceListenerAbilityRspBo retBo = new RsLoadBalanceListenerAbilityRspBo();
        String validateStr = this.validateArgs(reqBo);
        if (!StringUtils.isEmpty((CharSequence)validateStr)) {
            log.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u5165\u53c2j\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return retBo;
        }
        RsInfoResourcePo resourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(reqBo.getResourceId());
        if (null == resourcePo) {
            log.error("\u672a\u67e5\u8be2\u5230\u8d44\u6e90ID(" + reqBo.getResourceId() + ")\u7684\u8bb0\u5f55");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8d44\u6e90ID(" + reqBo.getResourceId() + ")\u7684\u8bb0\u5f55");
            return retBo;
        }
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u7528\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        if (this.actionType[0].equals(reqBo.getAction())) {
            McmpLoadBalanceListenerCreateRspBo createRetBo = this.invokeCreateInf(reqBo, resourcePo, atomRetBo);
            log.info("\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)createRetBo));
            if (!"0000".equals(createRetBo.getRespCode())) {
                log.error("\u8c03\u7528\u63a5\u53e3\u6dfb\u52a0\u8d1f\u8f7d\u5747\u8861\u76d1\u542c\u5931\u8d25\uff1a" + createRetBo.getRespDesc());
                BeanUtils.copyProperties((Object)createRetBo, (Object)retBo);
                return retBo;
            }
        } else {
            McmpLoadBalanceListenerModifyRspBo modifyRetBo = this.invokeModifyInf(reqBo, resourcePo, atomRetBo);
            log.info("\u63a5\u53e3\u8fd4\u56de\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)modifyRetBo));
            if (!"0000".equals(modifyRetBo.getRespCode())) {
                log.error("\u8c03\u7528\u63a5\u53e3\u6dfb\u52a0\u8d1f\u8f7d\u5747\u8861\u76d1\u542c\u5931\u8d25\uff1a" + modifyRetBo.getRespDesc());
                BeanUtils.copyProperties((Object)modifyRetBo, (Object)retBo);
                return retBo;
            }
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        log.info("===================\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u76d1\u542c\u6dfb\u52a0/\u4fee\u6539\u670d\u52a1\u7ed3\u675f==================");
        return retBo;
    }

    private McmpLoadBalanceListenerModifyRspBo invokeModifyInf(RsLoadBalanceListenerAbilityReqBo reqBo, RsInfoResourcePo resourcePo, RsQueryAliParamAtomRspBo atomRetBo) {
        log.info("\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u76d1\u542c-\u4fee\u6539");
        McmpLoadBalanceListenerModifyReqBo invokeModifyReqBo = new McmpLoadBalanceListenerModifyReqBo();
        if (2L == reqBo.getPlatformId()) {
            invokeModifyReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeModifyReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeModifyReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            invokeModifyReqBo.setProxyHost(atomRetBo.getProxyHost());
            invokeModifyReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            invokeModifyReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeModifyReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeModifyReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        invokeModifyReqBo.setRegion(resourcePo.getRegionId());
        invokeModifyReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        invokeModifyReqBo.setListenerType(reqBo.getListenerType());
        McmpAliLoadBalanceListenerDataBo dataBo = new McmpAliLoadBalanceListenerDataBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)dataBo);
        dataBo.setLoadBalancerId(resourcePo.getInstanceId());
        invokeModifyReqBo.setMcmpAliLoadBalanceListenerDataBo(dataBo);
        log.info("\u8c03\u7528\u8d1f\u8f7d\u5747\u8861\u76d1\u542c\u4fee\u6539\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)invokeModifyReqBo));
        return this.mcmpLoadBalanceListenerModifyService.modifyListener(invokeModifyReqBo);
    }

    private McmpLoadBalanceListenerCreateRspBo invokeCreateInf(RsLoadBalanceListenerAbilityReqBo reqBo, RsInfoResourcePo resourcePo, RsQueryAliParamAtomRspBo atomRetBo) {
        log.info("\u672c\u6b21\u6267\u884c\u7684\u64cd\u4f5c\u4e3a\uff1a\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u76d1\u542c-\u6dfb\u52a0");
        McmpLoadBalanceListenerCreateReqBo invokeReqBo = new McmpLoadBalanceListenerCreateReqBo();
        if (2L == reqBo.getPlatformId()) {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            invokeReqBo.setProxyHost(atomRetBo.getProxyHost());
            invokeReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        invokeReqBo.setRegion(resourcePo.getRegionId());
        invokeReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        invokeReqBo.setListenerType(reqBo.getListenerType());
        McmpAliLoadBalanceListenerDataBo dataInfo = new McmpAliLoadBalanceListenerDataBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)dataInfo);
        dataInfo.setLoadBalancerId(resourcePo.getInstanceId());
        invokeReqBo.setMcmpAliLoadBalanceListenerCreateReqBo(dataInfo);
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)invokeReqBo));
        return this.mcmpLoadBalanceListenerCreateService.createListener(invokeReqBo);
    }

    private String validateArgs(RsLoadBalanceListenerAbilityReqBo reqBo) {
        String result = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((CharSequence)result)) {
            return result;
        }
        if (!Arrays.asList(this.listenerTypes).contains(reqBo.getListenerType())) {
            return "\u76d1\u542c\u7c7b\u578b\u53d6\u503c\u53ea\u80fd\u662f\uff1a[TCP, UDP, HTTP, HTTPS]";
        }
        if (!Arrays.asList(this.actionType).contains(reqBo.getAction())) {
            return "\u64cd\u4f5c\u7c7b\u578b\u53d6\u503c\uff1a[ADD\uff0c MODIFY]";
        }
        return null;
    }
}

