/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.tydic.mcmp.resource.ability.api.RsPlatformEditAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformEditAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformEditAbilityRspBo;
import com.tydic.mcmp.resource.dao.RsInfoPlatformMapper;
import com.tydic.mcmp.resource.dao.RsRelPlatformServiceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPlatformPo;
import com.tydic.mcmp.resource.dao.po.RsRelPlatformServicePo;
import com.tydic.mcmp.resource.utils.DateUtils;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsPlatformEditAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsPlatformEditAbilityService"})
public class RsPlatformEditAbilityServiceImpl
implements RsPlatformEditAbilityService {
    @Autowired
    private RsInfoPlatformMapper rsInfoPlatformMapper;
    @Autowired
    private RsRelPlatformServiceMapper rsRelPlatformServiceMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsPlatformEditAbilityServiceImpl.class);

    @PostMapping(value={"dealPlatformEdit"})
    public RsPlatformEditAbilityRspBo dealPlatformEdit(@RequestBody RsPlatformEditAbilityReqBo reqBo) {
        RsPlatformEditAbilityRspBo rspBo = new RsPlatformEditAbilityRspBo();
        String check = this.checkReq(reqBo);
        if (!"".equals(check)) {
            rspBo.setRespDesc(check);
            rspBo.setRespCode("4059");
            return rspBo;
        }
        try {
            RsInfoPlatformPo rsInfoPlatformPo = new RsInfoPlatformPo();
            BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoPlatformPo);
            this.rsInfoPlatformMapper.updateByPrimaryKeySelective(rsInfoPlatformPo);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("4059");
            rspBo.setRespDesc("\u4fee\u6539\u5931\u8d25");
            return rspBo;
        }
        try {
            this.rsRelPlatformServiceMapper.deleteByPlatformId(reqBo.getPlatformId());
            if (!CollectionUtils.isEmpty((Collection)reqBo.getServiceIdList())) {
                for (Long serviceId : reqBo.getServiceIdList()) {
                    RsRelPlatformServicePo rsRelPlatformServicePo = new RsRelPlatformServicePo();
                    rsRelPlatformServicePo.setPlatformId(reqBo.getPlatformId());
                    rsRelPlatformServicePo.setServiceId(serviceId);
                    rsRelPlatformServicePo.setRemark(DateUtils.dateToStr(new Date()));
                    this.rsRelPlatformServiceMapper.insert(rsRelPlatformServicePo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("4059");
            rspBo.setRespDesc("\u4fee\u6539\u5e73\u53f0\u4e0e\u670d\u52a1\u7684\u5173\u7cfb\u5931\u8d25");
            return rspBo;
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String checkReq(RsPlatformEditAbilityReqBo reqBo) {
        String s = "";
        if (reqBo.getPlatformName() == null) {
            s = "\u8bf7\u8f93\u5165\u4e91\u5e73\u53f0\u540d\u79f0";
        }
        return s;
    }
}

