/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.intf.api.vpc.McmpDescribeVpcsBusiService;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVpcsReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpDescribeVpcsRspBO;
import com.tydic.mcmp.resource.ability.api.RsPlatformNetworkTypesQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformNetworkTypesQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsPlatformNetworkTypesQueryAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.common.bo.RsPlatformVpcInfoDataBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsPlatformNetworkTypesQueryAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsPlatformNetworkTypesQueryAbilityService"})
public class RsPlatformNetworkTypesQueryAbilityServiceImpl
implements RsPlatformNetworkTypesQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private McmpDescribeVpcsBusiService mcmpDescribeVpcsBusiService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"qryVpc"})
    public RsPlatformNetworkTypesQueryAbilityRspBo qryVpc(@RequestBody RsPlatformNetworkTypesQueryAbilityReqBo reqBo) {
        this.LOGGER.info("==========================\u5e73\u53f0\u4e0bVPC\u53caVPC\u4e0b\u4ea4\u6362\u673a\u67e5\u8be2=============================");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsPlatformNetworkTypesQueryAbilityRspBo retBo = new RsPlatformNetworkTypesQueryAbilityRspBo();
        ArrayList<RsPlatformVpcInfoDataBo> vpcs = new ArrayList<RsPlatformVpcInfoDataBo>();
        retBo.setVpcs(vpcs);
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        atomReqBo.setAccountId(reqBo.getAccountId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)((Object)atomRetBo), (Object)retBo);
            return retBo;
        }
        McmpDescribeVpcsReqBO vpcReqBo = new McmpDescribeVpcsReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)vpcReqBo);
        vpcReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        vpcReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
        vpcReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
        if (1L == reqBo.getPlatformId()) {
            vpcReqBo.setRegion(atomRetBo.getAccountRegionId());
        } else {
            vpcReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            vpcReqBo.setProxyHost(atomRetBo.getProxyHost());
            vpcReqBo.setProxyPort(atomRetBo.getProxyPort());
        }
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u5165\u53c2\uff1a" + JSON.toJSONString((Object)vpcReqBo));
        McmpDescribeVpcsRspBO vpcRetBo = this.mcmpDescribeVpcsBusiService.describeVpcs(vpcReqBo);
        this.LOGGER.info("\u5916\u90e8\u63a5\u53e3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)vpcRetBo));
        if (!"0000".equals(vpcRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u67e5\u8be2VPC\u4fe1\u606f\u5931\u8d25");
            retBo.setRespCode("4033");
            retBo.setRespDesc(vpcRetBo.getRespDesc());
            return retBo;
        }
        List vpcList = vpcRetBo.getVpcs();
        if (CollectionUtils.isEmpty((Collection)vpcList)) {
            this.LOGGER.error("\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u5230\u7684VPC\u5217\u8868\u4e3a\u7a7a");
            retBo.setRespCode("0000");
            retBo.setRespDesc("\u8c03\u7528\u63a5\u53e3\u67e5\u8be2\u5230\u7684VPC\u5217\u8868\u4e3a\u7a7a");
            return retBo;
        }
        for (McmpDescribeVpcsRspBO.Vpc vpc : vpcList) {
            RsPlatformVpcInfoDataBo dataBo = new RsPlatformVpcInfoDataBo();
            BeanUtils.copyProperties((Object)vpc, (Object)dataBo);
            vpcs.add(dataBo);
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }
}

