/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceDescribeMasterSlaveServerGroupsService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceDescribeMasterSlaveServerGroupsReqBO;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceDescribeMasterSlaveServerGroupsRspBO;
import com.tydic.mcmp.resource.ability.api.RsQryMasterSlaveServerGroupsAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsQryMasterSlaveServerGroupsAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsQryMasterSlaveServerGroupsAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.common.bo.RsListenerBo;
import com.tydic.mcmp.resource.common.bo.RsMasterSlaveServerGroupInfoBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsQryMasterSlaveServerGroupsAbilityService"})
public class RsQryMasterSlaveServerGroupsAbilityServiceImpl
implements RsQryMasterSlaveServerGroupsAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsQryMasterSlaveServerGroupsAbilityServiceImpl.class);
    @Autowired
    private McmpLoadBalanceDescribeMasterSlaveServerGroupsService mcmpLoadBalanceDescribeMasterSlaveServerGroupsService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"qryMasterSlaveServerGroups"})
    public RsQryMasterSlaveServerGroupsAbilityRspBo qryMasterSlaveServerGroups(@RequestBody RsQryMasterSlaveServerGroupsAbilityReqBo abilityReqBo) {
        RsQryMasterSlaveServerGroupsAbilityRspBo abilityRspBo = new RsQryMasterSlaveServerGroupsAbilityRspBo();
        this.validParam(abilityReqBo);
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(abilityReqBo.getAccountId());
        atomReqBo.setPlatformId(abilityReqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRspBo.getRespCode())) {
            throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
        }
        McmpLoadBalanceDescribeMasterSlaveServerGroupsReqBO serverGroupsReqBO = new McmpLoadBalanceDescribeMasterSlaveServerGroupsReqBO();
        serverGroupsReqBO.setCloudType(RsInterfaceUtil.convertCloudType(abilityReqBo.getPlatformId()));
        serverGroupsReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        serverGroupsReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        serverGroupsReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        serverGroupsReqBO.setProxyHost(atomRspBo.getProxyHost());
        serverGroupsReqBO.setProxyPort(atomRspBo.getProxyPort());
        if (StringUtils.hasText((String)abilityReqBo.getRegionId())) {
            serverGroupsReqBO.setRegion(abilityReqBo.getRegionId());
        }
        serverGroupsReqBO.setLoadBalancerId(abilityReqBo.getLoadBalancerId());
        serverGroupsReqBO.setIncludeListener(abilityReqBo.getIncludeListener());
        log.info("\u8c03\u7528\u8d1f\u8f7d\u5747\u8861\u4e3b\u5907\u670d\u52a1\u5668\u7ec4\u5217\u8868\u67e5\u8be2API\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)serverGroupsReqBO));
        McmpLoadBalanceDescribeMasterSlaveServerGroupsRspBO serverGroupsRspBO = this.mcmpLoadBalanceDescribeMasterSlaveServerGroupsService.describeMasterSlaveServerGroups(serverGroupsReqBO);
        log.info("\u8c03\u7528\u8d1f\u8f7d\u5747\u8861\u4e3b\u5907\u670d\u52a1\u5668\u7ec4\u5217\u8868\u67e5\u8be2API\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)serverGroupsRspBO));
        if (!"0000".equals(serverGroupsRspBO.getRespCode())) {
            throw new McmpBusinessException(serverGroupsRspBO.getRespCode(), serverGroupsRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)serverGroupsRspBO.getMasterSlaveServerGroups())) {
            ArrayList<RsMasterSlaveServerGroupInfoBo> rows = new ArrayList<RsMasterSlaveServerGroupInfoBo>();
            List masterSlaveServerGroups = serverGroupsRspBO.getMasterSlaveServerGroups();
            for (McmpLoadBalanceDescribeMasterSlaveServerGroupsRspBO.MasterSlaveServerGroup bo : masterSlaveServerGroups) {
                RsMasterSlaveServerGroupInfoBo rsBo = new RsMasterSlaveServerGroupInfoBo();
                rsBo.setMasterSlaveServerGroupId(bo.getMasterSlaveServerGroupId());
                rsBo.setMasterSlaveServerGroupName(bo.getMasterSlaveServerGroupName());
                if (bo.getAssociatedObjects() != null && !CollectionUtils.isEmpty((Collection)bo.getAssociatedObjects().getListeners())) {
                    ArrayList<RsListenerBo> listeners = new ArrayList<RsListenerBo>();
                    for (McmpLoadBalanceDescribeMasterSlaveServerGroupsRspBO.Listener listener : bo.getAssociatedObjects().getListeners()) {
                        RsListenerBo rsListenerBo = new RsListenerBo();
                        rsListenerBo.setPort(listener.getPort());
                        rsListenerBo.setProtocol(listener.getProtocol());
                        listeners.add(rsListenerBo);
                    }
                    rsBo.setListeners(listeners);
                }
                rows.add(rsBo);
            }
            abilityRspBo.setRows(rows);
        }
        abilityRspBo.setRespCode("0000");
        abilityRspBo.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return abilityRspBo;
    }

    private void validParam(RsQryMasterSlaveServerGroupsAbilityReqBo abilityReqBo) {
        if (null == abilityReqBo) {
            throw new McmpBusinessException("24000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (abilityReqBo.getPlatformId() == null) {
            throw new McmpBusinessException("24001", "\u4e91\u5e73\u53f0ID\u3010platformId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (abilityReqBo.getAccountId() == null) {
            throw new McmpBusinessException("24001", "\u8d26\u6237ID\u3010accountId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getLoadBalancerId())) {
            throw new McmpBusinessException("24001", "\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8bID\u3010loadBalancerId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

