/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.resource.ability.api.RsDictionaryQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.RsRedisListPageQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsDictionaryQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsDictionaryQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsDictionaryQueryAbilityRspDicBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRedisDataBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRedisListPageQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRedisListQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRedisListQueryAbilityRspInfoBo;
import com.tydic.mcmp.resource.busi.api.RsRedisListPageQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsRedisListPageQueryBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsRedisListPageQueryBusiRspBo;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsRedisListPageQueryAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsRedisListPageQueryAbilityService"})
public class RsRedisListPageQueryAbilityServiceImpl
implements RsRedisListPageQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsRedisListPageQueryBusiService rsRedisListPageQueryBusiService;
    @Autowired
    private RsDictionaryQueryAbilityService rsDictionaryQueryAbilityService;

    @PostMapping(value={"queryRedisList"})
    public RsRedisListQueryAbilityRspBo queryRedisList(@RequestBody RsRedisListPageQueryAbilityReqBo reqBo) {
        this.LOGGER.info("----------------------\u7f13\u5b58\u5217\u8868\u67e5\u8be2 Ability\u670d\u52a1----------------------");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsRedisListQueryAbilityRspBo rspBo = new RsRedisListQueryAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("4011");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25:" + validateStr);
            return rspBo;
        }
        RsRedisListPageQueryBusiReqBo busiReqBo = new RsRedisListPageQueryBusiReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
        RsRedisListPageQueryBusiRspBo busiRspBo = this.rsRedisListPageQueryBusiService.queryRedisList(busiReqBo);
        ArrayList<RsRedisListQueryAbilityRspInfoBo> rspInfoBos = new ArrayList<RsRedisListQueryAbilityRspInfoBo>();
        if (!CollectionUtils.isEmpty((Collection)busiRspBo.getRows())) {
            for (RsRedisDataBo dataBo : busiRspBo.getRows()) {
                RsRedisListQueryAbilityRspInfoBo redisBo = new RsRedisListQueryAbilityRspInfoBo();
                BeanUtils.copyProperties((Object)dataBo, (Object)redisBo);
                RsRedisListQueryAbilityRspInfoBo translateRedisBo = this.translate(redisBo);
                redisBo.setNetTypeStr(translateRedisBo.getNetTypeStr());
                redisBo.setInstanceVersionStr(translateRedisBo.getInstanceVersionStr());
                redisBo.setPayTypeStr(translateRedisBo.getPayTypeStr());
                redisBo.setResourceStatusStr(translateRedisBo.getResourceStatusStr());
                DecimalFormat df = new DecimalFormat("#.00");
                redisBo.setMemory(df.format(dataBo.getMemory() / 1024.0) + "GB");
                rspInfoBos.add(redisBo);
            }
        }
        rspBo.setRows(rspInfoBos);
        rspBo.setPageNo(busiRspBo.getPageNo());
        rspBo.setTotal(busiRspBo.getTotal());
        rspBo.setRecordsTotal(busiRspBo.getRecordsTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        this.LOGGER.info("----------------------\u7f13\u5b58\u5217\u8868\u67e5\u8be2 Ability\u670d\u52a1\u7ed3\u675f----------------------");
        return rspBo;
    }

    private RsRedisListQueryAbilityRspInfoBo translate(RsRedisListQueryAbilityRspInfoBo reqBo) {
        RsDictionaryQueryAbilityReqBo rsDictionaryQueryAbilityReqBo = new RsDictionaryQueryAbilityReqBo();
        RsRedisListQueryAbilityRspInfoBo rspInfoBo = new RsRedisListQueryAbilityRspInfoBo();
        rsDictionaryQueryAbilityReqBo.setDicCode(String.valueOf(reqBo.getResourceStatus()));
        rsDictionaryQueryAbilityReqBo.setDicType("RS_INFO_RESOURCE_STATUS");
        RsDictionaryQueryAbilityRspBo rspBo = this.rsDictionaryQueryAbilityService.queryDic(rsDictionaryQueryAbilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getDicList())) {
            rspInfoBo.setResourceStatusStr(((RsDictionaryQueryAbilityRspDicBo)rspBo.getDicList().get(0)).getDicValue());
        }
        rsDictionaryQueryAbilityReqBo.setDicCode(String.valueOf(reqBo.getPayType()));
        rsDictionaryQueryAbilityReqBo.setDicType("RS_INFO_RESOURCE_REDIS_PAY_TYPE");
        rspBo = this.rsDictionaryQueryAbilityService.queryDic(rsDictionaryQueryAbilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getDicList())) {
            rspInfoBo.setPayTypeStr(((RsDictionaryQueryAbilityRspDicBo)rspBo.getDicList().get(0)).getDicValue());
        }
        rsDictionaryQueryAbilityReqBo.setDicCode(String.valueOf(reqBo.getInstanceVersion()));
        rsDictionaryQueryAbilityReqBo.setDicType("RS_INFO_RESOURCE_REDIS_INSTANCE_VERSION");
        rspBo = this.rsDictionaryQueryAbilityService.queryDic(rsDictionaryQueryAbilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getDicList())) {
            rspInfoBo.setInstanceVersionStr(((RsDictionaryQueryAbilityRspDicBo)rspBo.getDicList().get(0)).getDicValue());
        }
        rsDictionaryQueryAbilityReqBo.setDicCode(String.valueOf(reqBo.getNetType()));
        rsDictionaryQueryAbilityReqBo.setDicType("RS_INFO_RESOURCE_REDIS_NET_TYPE");
        rspBo = this.rsDictionaryQueryAbilityService.queryDic(rsDictionaryQueryAbilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getDicList())) {
            rspInfoBo.setNetTypeStr(((RsDictionaryQueryAbilityRspDicBo)rspBo.getDicList().get(0)).getDicValue());
        }
        return rspInfoBo;
    }
}

