/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.tydic.mcmp.resource.ability.api.RsResourceOverviewAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsResourceOverviewAbilityBo;
import com.tydic.mcmp.resource.ability.api.bo.RsResourceOverviewAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsResourceOverviewAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsServiceCountInfoBo;
import com.tydic.mcmp.resource.dao.RsInfoPlatformMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoPlatformPo;
import com.tydic.mcmp.resource.dao.po.RsServiceCountInfoPo;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsResourceOverviewAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsResourceOverviewAbilityService"})
public class RsResourceOverviewAbilityServiceImpl
implements RsResourceOverviewAbilityService {
    @Autowired
    private RsInfoPlatformMapper rsInfoPlatformMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsResourceOverviewAbilityServiceImpl.class);

    @PostMapping(value={"getRsResourceOverview"})
    public RsResourceOverviewAbilityRspBo getRsResourceOverview(@RequestBody RsResourceOverviewAbilityReqBo reqBo) {
        RsResourceOverviewAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsResourceOverviewAbilityRspBo.class);
        ArrayList<RsResourceOverviewAbilityBo> rsResourceOverviewAbilityBos = new ArrayList<RsResourceOverviewAbilityBo>();
        try {
            List<RsInfoPlatformPo> rsInfoPlatformPos = this.rsInfoPlatformMapper.queryStatisticsInfo(null);
            if (!CollectionUtils.isEmpty(rsInfoPlatformPos)) {
                for (RsInfoPlatformPo rsInfoPlatformPo : rsInfoPlatformPos) {
                    RsResourceOverviewAbilityBo rsResourceOverviewAbilityBo = new RsResourceOverviewAbilityBo();
                    rsResourceOverviewAbilityBo.setPlatformId(rsInfoPlatformPo.getPlatformId());
                    rsResourceOverviewAbilityBo.setPlatformName(rsInfoPlatformPo.getPlatformName());
                    rsResourceOverviewAbilityBos.add(rsResourceOverviewAbilityBo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u5e73\u53f0\u5931\u8d25");
            return rspBo;
        }
        try {
            if (!CollectionUtils.isEmpty(rsResourceOverviewAbilityBos)) {
                for (RsResourceOverviewAbilityBo rsResourceOverviewAbilityBo : rsResourceOverviewAbilityBos) {
                    ArrayList<RsServiceCountInfoBo> rsServiceCountInfoBos = new ArrayList<RsServiceCountInfoBo>();
                    List<RsServiceCountInfoPo> rsServiceCountInfoPos = this.rsInfoPlatformMapper.queryCount(rsResourceOverviewAbilityBo.getPlatformId());
                    if (!CollectionUtils.isEmpty(rsServiceCountInfoPos)) {
                        for (RsServiceCountInfoPo rsServiceCountInfoPo : rsServiceCountInfoPos) {
                            RsServiceCountInfoBo rsServiceCountInfoBo = new RsServiceCountInfoBo();
                            rsServiceCountInfoBo.setServiceId(rsServiceCountInfoPo.getServiceId());
                            rsServiceCountInfoBo.setServiceName(rsServiceCountInfoPo.getServiceName());
                            rsServiceCountInfoBo.setServiceTotalCount(rsServiceCountInfoPo.getServiceTotalCount());
                            rsServiceCountInfoBos.add(rsServiceCountInfoBo);
                        }
                    }
                    rsResourceOverviewAbilityBo.setRsServiceCountInfoBos(rsServiceCountInfoBos);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u67e5\u8be2\u6570\u91cf\u5931\u8d25");
            return rspBo;
        }
        rspBo.setData(rsResourceOverviewAbilityBos);
        return rspBo;
    }
}

