/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.mcmp.intf.api.routable.McmpDescribeRouteTableListService;
import com.tydic.mcmp.intf.api.routable.bo.McmpDescribeRouteTableListReqBo;
import com.tydic.mcmp.intf.api.routable.bo.McmpDescribeRouteTableListRspBo;
import com.tydic.mcmp.intf.util.PageList;
import com.tydic.mcmp.resource.ability.api.RsRoutingTableListQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.RsVpcListPageQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsRoutingTableListQueryAbilityBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRoutingTableListQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRoutingTableListQueryAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.utils.ListUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsRoutingTableListQueryAbilityService"})
public class RsRoutingTableListQueryAbilityServiceImpl
implements RsRoutingTableListQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsRoutingTableListQueryAbilityServiceImpl.class);
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private McmpDescribeRouteTableListService mcmpDescribeRouteTableListService;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsVpcListPageQueryAbilityService rsVpcListPageQueryAbilityService;

    @PostMapping(value={"getRsRoutingTableList"})
    public RsRoutingTableListQueryAbilityRspBo getRsRoutingTableList(@RequestBody RsRoutingTableListQueryAbilityReqBo reqBo) {
        RsRoutingTableListQueryAbilityRspBo rspBo = new RsRoutingTableListQueryAbilityRspBo();
        Map<Object, Object> map = new HashMap();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getReqInfos())) {
            map = reqBo.getReqInfos().stream().collect(Collectors.groupingBy(RsRoutingTableListQueryAbilityReqBo.ReqInfo::getAccountId));
        }
        ArrayList rsRoutingTableListQueryAbilityBos = new ArrayList();
        for (Map.Entry each : map.entrySet()) {
            List reqInfos = (List)each.getValue();
            List regions = reqInfos.stream().map(RsRoutingTableListQueryAbilityReqBo.ReqInfo::getRegionId).collect(Collectors.toList());
            List<String> onlyRegions = ListUtils.duplicateRemovalToList(regions);
            for (String region : onlyRegions) {
                reqBo.setAccountId((Long)each.getKey());
                reqBo.setRegionId(region);
                rspBo = this.getInfo(reqBo);
                if (CollectionUtils.isEmpty((Collection)rspBo.getRows())) continue;
                rsRoutingTableListQueryAbilityBos.addAll(rspBo.getRows());
            }
        }
        List list = PageList.startPage(rsRoutingTableListQueryAbilityBos, (Integer)reqBo.getPageNo(), (Integer)reqBo.getPageSize());
        rspBo.setRecordsTotal(Integer.valueOf(rsRoutingTableListQueryAbilityBos.size()));
        rspBo.setPageNo(reqBo.getPageNo());
        Integer pageCount = 0;
        pageCount = rspBo.getRecordsTotal() % reqBo.getPageSize() == 0 ? Integer.valueOf(rspBo.getRecordsTotal() / reqBo.getPageSize()) : Integer.valueOf(rspBo.getRecordsTotal() / reqBo.getPageSize() + 1);
        rspBo.setTotal(pageCount);
        rspBo.setRows(list);
        return rspBo;
    }

    private RsRoutingTableListQueryAbilityRspBo getInfo(RsRoutingTableListQueryAbilityReqBo reqBo) {
        RsRoutingTableListQueryAbilityRspBo rspBo = new RsRoutingTableListQueryAbilityRspBo();
        RsQueryAliParamAtomReqBo rsQueryAliParamAtomReqBo = new RsQueryAliParamAtomReqBo();
        rsQueryAliParamAtomReqBo.setAccountId(reqBo.getAccountId());
        rsQueryAliParamAtomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo rsQueryAliParamAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(rsQueryAliParamAtomReqBo);
        if (!"0000".equals(rsQueryAliParamAtomRspBo.getRespCode())) {
            rspBo.setRespCode("4052");
            rspBo.setRespDesc("\u67e5\u8be2\u79d8\u94a5\u5931\u8d25");
            return rspBo;
        }
        McmpDescribeRouteTableListReqBo mcmpDescribeRouteTableListReqBo = new McmpDescribeRouteTableListReqBo();
        mcmpDescribeRouteTableListReqBo.setCloudType(reqBo.getPlatformId().toString());
        mcmpDescribeRouteTableListReqBo.setAccessKeyId(rsQueryAliParamAtomRspBo.getAccessKeyId());
        mcmpDescribeRouteTableListReqBo.setAccessKeySecret(rsQueryAliParamAtomRspBo.getAccessKeySecret());
        mcmpDescribeRouteTableListReqBo.setEndpointPriv(rsQueryAliParamAtomRspBo.getEndpoint());
        mcmpDescribeRouteTableListReqBo.setProxyHost(rsQueryAliParamAtomRspBo.getProxyHost());
        mcmpDescribeRouteTableListReqBo.setProxyPort(rsQueryAliParamAtomRspBo.getProxyPort());
        mcmpDescribeRouteTableListReqBo.setRegion(reqBo.getRegionId());
        mcmpDescribeRouteTableListReqBo.setVpcId(reqBo.getVpcId());
        mcmpDescribeRouteTableListReqBo.setRouteTableId(reqBo.getRouteInstanceId());
        mcmpDescribeRouteTableListReqBo.setRouteTableName(reqBo.getRouteName());
        log.info("\u8c03\u7528\u5916\u90e8\u67e5\u8be2\u8def\u7531\u5217\u8868\u4f20\u9012\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)mcmpDescribeRouteTableListReqBo));
        McmpDescribeRouteTableListRspBo mcmpDescribeRouteTableListRspBo = this.mcmpDescribeRouteTableListService.getMcmpDescribeRouteTableList(mcmpDescribeRouteTableListReqBo);
        log.info("\u8c03\u7528\u5916\u90e8\u67e5\u8be2\u8def\u7531\u5217\u8868\u8fd4\u56de\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)mcmpDescribeRouteTableListRspBo));
        if (!"0000".equals(mcmpDescribeRouteTableListRspBo.getRespCode())) {
            rspBo.setRespCode("4052");
            rspBo.setRespDesc("\u5916\u90e8\u67e5\u8be2\u8def\u7531\u5217\u8868\u5931\u8d25");
            return rspBo;
        }
        ArrayList<RsRoutingTableListQueryAbilityBo> rsRoutingTableListQueryAbilityBos = new ArrayList<RsRoutingTableListQueryAbilityBo>();
        if (!CollectionUtils.isEmpty((Collection)mcmpDescribeRouteTableListRspBo.getRouterTableList())) {
            for (McmpDescribeRouteTableListRspBo.RouterTableListType routerTableListType : mcmpDescribeRouteTableListRspBo.getRouterTableList()) {
                RsRoutingTableListQueryAbilityBo rsRoutingTableListQueryAbilityBo = new RsRoutingTableListQueryAbilityBo();
                rsRoutingTableListQueryAbilityBo.setInstanceId(routerTableListType.getRouteTableId());
                rsRoutingTableListQueryAbilityBo.setInstanceName(routerTableListType.getRouteTableName());
                rsRoutingTableListQueryAbilityBo.setResourceGroup(routerTableListType.getResourceGroupId());
                rsRoutingTableListQueryAbilityBo.setRouteId(routerTableListType.getRouterId());
                rsRoutingTableListQueryAbilityBo.setRoutTableType(routerTableListType.getRouteTableType());
                rsRoutingTableListQueryAbilityBo.setVpcId(routerTableListType.getVpcId());
                RsInfoResourcePo rsInfoResourcePo = this.rsInfoResourceMapper.selectByInstanceId(null, routerTableListType.getVpcId());
                if (rsInfoResourcePo != null) {
                    rsRoutingTableListQueryAbilityBo.setPlatformId(rsInfoResourcePo.getPlatformId());
                    rsRoutingTableListQueryAbilityBo.setAccountId(rsInfoResourcePo.getAccountId());
                    rsRoutingTableListQueryAbilityBo.setRegionId(rsInfoResourcePo.getRegionId());
                }
                rsRoutingTableListQueryAbilityBos.add(rsRoutingTableListQueryAbilityBo);
            }
        }
        rspBo.setRows(rsRoutingTableListQueryAbilityBos);
        return rspBo;
    }
}

