/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeInstanceStatusService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeInstanceStatusReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeInstanceStatusRspBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerInstanceStatusBO;
import com.tydic.mcmp.resource.ability.api.RsUpdateEcsInstanceStatusAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsUpdateEcsInstanceStatusAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsUpdateEcsInstanceStatusAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.common.bo.RsUpdateResourceStatusBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsUpdateEcsInstanceStatusAbilityService"})
public class RsUpdateEcsInstanceStatusAbilityServiceImpl
implements RsUpdateEcsInstanceStatusAbilityService {
    private static final Logger log = LoggerFactory.getLogger(RsUpdateEcsInstanceStatusAbilityServiceImpl.class);
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private McmpCloudSerDescribeInstanceStatusService mcmpCloudSerDescribeInstanceStatusService;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"updateEcsInstanceStatus"})
    public RsUpdateEcsInstanceStatusAbilityRspBo updateEcsInstanceStatus(@RequestBody RsUpdateEcsInstanceStatusAbilityReqBo abilityReqBo) {
        List<RsInfoResourcePo> rsInfoResourcePos;
        RsUpdateEcsInstanceStatusAbilityRspBo abilityRspBo = new RsUpdateEcsInstanceStatusAbilityRspBo();
        RsDicMapQueryAtomReqBo rsDicMapQueryAtomReqBo = new RsDicMapQueryAtomReqBo();
        rsDicMapQueryAtomReqBo.setType("RS_UPDATE_ECS_STATUS_SHARD_NUM");
        RsDicMapQueryAtomRspBo bo1 = this.rsDicMapQueryAtomService.qryDicMap(rsDicMapQueryAtomReqBo);
        Map<String, String> configShardValueMap = bo1.getDicMap();
        String configShardValue = configShardValueMap.get("configShardValue");
        if (null == configShardValue) {
            configShardValue = "1";
        }
        if (StringUtils.isEmpty((Object)abilityReqBo.getShardingItem())) {
            abilityReqBo.setShardingItem("0");
        }
        if (!CollectionUtils.isEmpty(rsInfoResourcePos = this.rsInfoResourceMapper.selectForUpateStatus(configShardValue, abilityReqBo.getShardingItem(), 1L))) {
            HashSet<String> instanceIdInResourceSet = new HashSet<String>();
            HashMap<String, ArrayList<String>> statusInstanceIdMap = new HashMap<String, ArrayList<String>>();
            HashMap accountIdPlatfromIdMap = new HashMap();
            for (RsInfoResourcePo po : rsInfoResourcePos) {
                HashSet<String> regionIds;
                if (!StringUtils.hasText((String)po.getRegionId())) continue;
                instanceIdInResourceSet.add(po.getInstanceId());
                HashMap<Long, HashSet<String>> platfromIdRegionIdMapTemp = (HashMap<Long, HashSet<String>>)accountIdPlatfromIdMap.get(po.getAccountId());
                if (null == platfromIdRegionIdMapTemp) {
                    platfromIdRegionIdMapTemp = new HashMap<Long, HashSet<String>>();
                    accountIdPlatfromIdMap.put(po.getAccountId(), platfromIdRegionIdMapTemp);
                    platfromIdRegionIdMapTemp.put(po.getPlatformId(), null);
                }
                if (null == (regionIds = (HashSet<String>)platfromIdRegionIdMapTemp.get(po.getPlatformId()))) {
                    regionIds = new HashSet<String>();
                    platfromIdRegionIdMapTemp.put(po.getPlatformId(), regionIds);
                }
                regionIds.add(po.getRegionId());
            }
            for (Long accountId : accountIdPlatfromIdMap.keySet()) {
                RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
                McmpCloudSerDescribeInstanceStatusReqBO describeInstanceStatusReqBO = new McmpCloudSerDescribeInstanceStatusReqBO();
                Map platfromIdRegionIdMap = (Map)accountIdPlatfromIdMap.get(accountId);
                for (Long platfromId : platfromIdRegionIdMap.keySet()) {
                    atomReqBo.setAccountId(accountId);
                    atomReqBo.setPlatformId(platfromId);
                    RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
                    if (!"0000".equals(atomRspBo.getRespCode())) {
                        throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
                    }
                    describeInstanceStatusReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
                    describeInstanceStatusReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
                    describeInstanceStatusReqBO.setEndpointPriv(atomRspBo.getEndpoint());
                    describeInstanceStatusReqBO.setProxyHost(atomRspBo.getProxyHost());
                    describeInstanceStatusReqBO.setProxyPort(atomRspBo.getProxyPort());
                    describeInstanceStatusReqBO.setCloudType(RsInterfaceUtil.convertCloudType(platfromId));
                    Set regionIdSet = (Set)platfromIdRegionIdMap.get(platfromId);
                    for (String regionId : regionIdSet) {
                        if (1L == platfromId) {
                            describeInstanceStatusReqBO.setRegion(regionId);
                        } else if (2L == platfromId) {
                            describeInstanceStatusReqBO.setRegionId(regionId);
                        }
                        describeInstanceStatusReqBO.setPageNumber(Integer.valueOf(1));
                        describeInstanceStatusReqBO.setPageSize(Integer.valueOf(1));
                        log.info("\u8c03\u7528\u4e91\u4e3b\u673a\u67e5\u8be2\u5b9e\u4f8b\u72b6\u6001\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)describeInstanceStatusReqBO));
                        McmpCloudSerDescribeInstanceStatusRspBO mcmpCloudSerDescribeInstanceStatusRspBO = this.mcmpCloudSerDescribeInstanceStatusService.describeInstanceStatus(describeInstanceStatusReqBO);
                        log.info("\u8c03\u7528\u4e91\u4e3b\u673a\u67e5\u8be2\u5b9e\u4f8b\u72b6\u6001\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDescribeInstanceStatusRspBO));
                        if (!"0000".equals(mcmpCloudSerDescribeInstanceStatusRspBO.getRespCode())) {
                            throw new McmpBusinessException(mcmpCloudSerDescribeInstanceStatusRspBO.getRespCode(), mcmpCloudSerDescribeInstanceStatusRspBO.getRespDesc());
                        }
                        Integer totalCount = mcmpCloudSerDescribeInstanceStatusRspBO.getTotalCount();
                        if (totalCount <= 0) continue;
                        int totalPage = (totalCount + 50 - 1) / 50;
                        for (int i = 1; i <= totalPage; ++i) {
                            describeInstanceStatusReqBO.setPageNumber(Integer.valueOf(i));
                            describeInstanceStatusReqBO.setPageSize(Integer.valueOf(50));
                            log.info("\u8c03\u7528\u4e91\u4e3b\u673a\u67e5\u8be2\u5b9e\u4f8b\u72b6\u6001\u4fe1\u606f\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)describeInstanceStatusReqBO));
                            McmpCloudSerDescribeInstanceStatusRspBO mcmpCloudSerDescribeInstanceStatusRspBO1 = this.mcmpCloudSerDescribeInstanceStatusService.describeInstanceStatus(describeInstanceStatusReqBO);
                            log.info("\u8c03\u7528\u4e91\u4e3b\u673a\u67e5\u8be2\u5b9e\u4f8b\u72b6\u6001\u4fe1\u606f\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDescribeInstanceStatusRspBO1));
                            if (!"0000".equals(mcmpCloudSerDescribeInstanceStatusRspBO1.getRespCode())) {
                                throw new McmpBusinessException(mcmpCloudSerDescribeInstanceStatusRspBO1.getRespCode(), mcmpCloudSerDescribeInstanceStatusRspBO1.getRespDesc());
                            }
                            List instanceStatuses = mcmpCloudSerDescribeInstanceStatusRspBO1.getInstanceStatuses();
                            for (McmpCloudSerInstanceStatusBO mcmpCloudSerInstanceStatusBO : instanceStatuses) {
                                if (!instanceIdInResourceSet.contains(mcmpCloudSerInstanceStatusBO.getInstanceId())) continue;
                                ArrayList<String> instanceIds = (ArrayList<String>)statusInstanceIdMap.get(mcmpCloudSerInstanceStatusBO.getStatus());
                                if (instanceIds == null) {
                                    instanceIds = new ArrayList<String>();
                                    statusInstanceIdMap.put(mcmpCloudSerInstanceStatusBO.getStatus(), instanceIds);
                                }
                                instanceIds.add(mcmpCloudSerInstanceStatusBO.getInstanceId());
                            }
                        }
                    }
                }
            }
            for (String status : statusInstanceIdMap.keySet()) {
                List instanceIdUpdate = (List)statusInstanceIdMap.get(status);
                Integer updateStatus = null;
                if (status.equals("Running")) {
                    updateStatus = RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN;
                } else if (status.equals("Stopped")) {
                    updateStatus = RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_STOP;
                }
                if (updateStatus == null) continue;
                RsUpdateResourceStatusBo rsUpdateResourceStatusBo = new RsUpdateResourceStatusBo();
                rsUpdateResourceStatusBo.setInstanceIds(instanceIdUpdate);
                rsUpdateResourceStatusBo.setStatus(updateStatus);
                rsUpdateResourceStatusBo.setServiceId(Long.valueOf(1L));
                this.rsInfoResourceMapper.updateByStatus(rsUpdateResourceStatusBo);
            }
        }
        abilityRspBo.setRespCode("0000");
        abilityRspBo.setRespDesc("\u5b9e\u4f8b\u72b6\u6001\u66f4\u65b0\u6210\u529f");
        return abilityRspBo;
    }
}

