/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.resource.ability.api.RsDictionaryQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.RsRoutingTableListQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.RsVpcListPageQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsDictionaryQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsDictionaryQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsDictionaryQueryAbilityRspDicBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRoutingTableListQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsRoutingTableListQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVpcDataBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVpcListPageQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVpcListPageQueryAbilityRspBo;
import com.tydic.mcmp.resource.dao.RsInfoInterchangerMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoVpcMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoInterchangerPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsVpcListPageQueryAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsVpcListPageQueryAbilityService"})
public class RsVpcListPageQueryAbilityServiceImpl
implements RsVpcListPageQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoVpcMapper rsInfoVpcMapper;
    @Autowired
    private RsInfoInterchangerMapper rsInfoInterchangerMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsRoutingTableListQueryAbilityService rsRoutingTableListQueryAbilityService;
    @Autowired
    private RsDictionaryQueryAbilityService rsDictionaryQueryAbilityService;

    @PostMapping(value={"queryVpcList"})
    public RsVpcListPageQueryAbilityRspBo queryVpcList(@RequestBody RsVpcListPageQueryAbilityReqBo reqBo) {
        this.LOGGER.info("----------------------\u4e13\u6709\u7f51\u7edc\u5206\u9875\u67e5\u8be2\u670d\u52a1 Ability\u670d\u52a1----------------------");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsVpcListPageQueryAbilityRspBo rspBo = new RsVpcListPageQueryAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("4060");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBo;
        }
        Page page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        RsVpcDataBo vpcDataBo = new RsVpcDataBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)vpcDataBo);
        List<RsVpcDataBo> rsVpcDataBoList = this.rsInfoVpcMapper.queryListPage(page, vpcDataBo);
        ArrayList<RsVpcDataBo> vpcDataBos = new ArrayList<RsVpcDataBo>();
        if (!CollectionUtils.isEmpty(rsVpcDataBoList)) {
            for (RsVpcDataBo rsVpcDataBo : rsVpcDataBoList) {
                RsInfoResourcePo rsInfoResourcePo;
                RsVpcDataBo dataBo = new RsVpcDataBo();
                BeanUtils.copyProperties((Object)rsVpcDataBo, (Object)dataBo);
                if (null != rsVpcDataBo.getVpcId()) {
                    RsInfoInterchangerPo interchangerPo = new RsInfoInterchangerPo();
                    interchangerPo.setVpcId(rsVpcDataBo.getVpcId());
                    List<RsInfoInterchangerPo> infoInterchangerPoList = this.rsInfoInterchangerMapper.queryList(interchangerPo);
                    if (!CollectionUtils.isEmpty(infoInterchangerPoList)) {
                        dataBo.setInterchangerNo(Integer.valueOf(infoInterchangerPoList.size()));
                    } else {
                        dataBo.setInterchangerNo(Integer.valueOf(0));
                    }
                    RsRoutingTableListQueryAbilityReqBo.ReqInfo reqInfo = new RsRoutingTableListQueryAbilityReqBo.ReqInfo();
                    reqInfo.setAccountId(rsVpcDataBo.getAccountId());
                    reqInfo.setRegionId(rsVpcDataBo.getRegionId());
                    ArrayList<RsRoutingTableListQueryAbilityReqBo.ReqInfo> reqInfos = new ArrayList<RsRoutingTableListQueryAbilityReqBo.ReqInfo>();
                    reqInfos.add(reqInfo);
                    RsRoutingTableListQueryAbilityReqBo tableReqBo = new RsRoutingTableListQueryAbilityReqBo();
                    tableReqBo.setVpcId(rsVpcDataBo.getVpcId());
                    tableReqBo.setPlatformId(rsVpcDataBo.getPlatformId());
                    tableReqBo.setReqInfos(reqInfos);
                    RsRoutingTableListQueryAbilityRspBo tableRspBo = this.rsRoutingTableListQueryAbilityService.getRsRoutingTableList(tableReqBo);
                    if (!CollectionUtils.isEmpty((Collection)tableRspBo.getRows())) {
                        dataBo.setRouterTableNo(tableRspBo.getRecordsTotal());
                    } else {
                        dataBo.setRouterTableNo(Integer.valueOf(0));
                    }
                }
                if (null != rsVpcDataBo.getResourceId() && null != (rsInfoResourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(rsVpcDataBo.getResourceId()))) {
                    dataBo.setRegionId(rsInfoResourcePo.getRegionId());
                }
                RsVpcDataBo translateRspBo = this.translate(dataBo);
                dataBo.setDefaultVpcStr(translateRspBo.getDefaultVpcStr());
                dataBo.setVpcStatusStr(translateRspBo.getVpcStatusStr());
                vpcDataBos.add(dataBo);
            }
        }
        rspBo.setRows(vpcDataBos);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBo.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        this.LOGGER.info("----------------------\u4e13\u6709\u7f51\u7edc\u5206\u9875\u67e5\u8be2\u670d\u52a1 Ability\u670d\u52a1\u7ed3\u675f----------------------");
        return rspBo;
    }

    private RsVpcDataBo translate(RsVpcDataBo reqBo) {
        RsDictionaryQueryAbilityReqBo rsDictionaryQueryAbilityReqBo = new RsDictionaryQueryAbilityReqBo();
        RsVpcDataBo rspBo = new RsVpcDataBo();
        rsDictionaryQueryAbilityReqBo.setDicCode(String.valueOf(reqBo.getDefaultVpc()));
        rsDictionaryQueryAbilityReqBo.setDicType("RS_INFO_VPC_DEFAULT_VPC");
        RsDictionaryQueryAbilityRspBo dicRspBo = this.rsDictionaryQueryAbilityService.queryDic(rsDictionaryQueryAbilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)dicRspBo.getDicList())) {
            rspBo.setDefaultVpcStr(((RsDictionaryQueryAbilityRspDicBo)dicRspBo.getDicList().get(0)).getDicValue());
        }
        rsDictionaryQueryAbilityReqBo.setDicCode(String.valueOf(reqBo.getVpcStatus()));
        rsDictionaryQueryAbilityReqBo.setDicType("RS_INFO_VPC_STATUS");
        dicRspBo = this.rsDictionaryQueryAbilityService.queryDic(rsDictionaryQueryAbilityReqBo);
        if (!CollectionUtils.isEmpty((Collection)dicRspBo.getDicList())) {
            rspBo.setVpcStatusStr(((RsDictionaryQueryAbilityRspDicBo)dicRspBo.getDicList().get(0)).getDicValue());
        }
        return rspBo;
    }
}

