/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.intf.api.vpc.McmpVpcDescribeRegionsService;
import com.tydic.mcmp.intf.api.vpc.bo.McmpVpcDescribeRegionsReqBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpVpcDescribeRegionsRspBO;
import com.tydic.mcmp.intf.api.vpc.bo.McmpVpcSerRegionsBO;
import com.tydic.mcmp.intf.base.McmpIntfReqBaseBO;
import com.tydic.mcmp.resource.ability.api.RsVpcRegionListQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsVpcRegionBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVpcRegionListQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsVpcRegionListQueryAbilityRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.utils.generatedoc.util.ArgValidator;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service(value="rsVpcRegionListQueryAbilityService")
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsVpcRegionListQueryAbilityService"})
public class RsVpcRegionListQueryAbilityServiceImpl
implements RsVpcRegionListQueryAbilityService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private McmpVpcDescribeRegionsService mcmpVpcDescribeRegionsService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    @PostMapping(value={"queryVpcRegionList"})
    public RsVpcRegionListQueryAbilityRspBo queryVpcRegionList(@RequestBody RsVpcRegionListQueryAbilityReqBo reqBo) {
        this.LOGGER.info("----------------------\u67e5\u8be2\u4e13\u6709\u7f51\u7edc\u5730\u57df Ability\u670d\u52a1----------------------");
        this.LOGGER.info("\u5165\u53c2\uff1a" + reqBo);
        RsVpcRegionListQueryAbilityRspBo rspBo = new RsVpcRegionListQueryAbilityRspBo();
        String validateStr = ArgValidator.validateArg((Object)reqBo);
        if (!StringUtils.isEmpty((Object)validateStr)) {
            this.LOGGER.error("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            rspBo.setRespCode("4066");
            rspBo.setRespDesc("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1a" + validateStr);
            return rspBo;
        }
        RsQueryAliParamAtomReqBo qryParam = new RsQueryAliParamAtomReqBo();
        qryParam.setTenementId(reqBo.getTenementId());
        qryParam.setPlatformId(reqBo.getPlatformId());
        qryParam.setAccountId(reqBo.getAccountId());
        RsQueryAliParamAtomRspBo paramAtomRspBo = this.rsQueryAliParamAtomService.queryAliParam(qryParam);
        if (!"0000".equals(paramAtomRspBo.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsVpcRegionListQueryAbilityRspBo.class, paramAtomRspBo.getRespDesc(), paramAtomRspBo.getRespCode());
        }
        McmpVpcDescribeRegionsReqBO vpcDescribeRegionsReqBO = new McmpVpcDescribeRegionsReqBO();
        vpcDescribeRegionsReqBO.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        RsInterfaceUtil.setAliParamToIntReqBo(paramAtomRspBo, (McmpIntfReqBaseBO)vpcDescribeRegionsReqBO);
        BeanUtils.copyProperties((Object)reqBo, (Object)vpcDescribeRegionsReqBO);
        McmpVpcDescribeRegionsRspBO vpcDescribeRegionsRspBO = this.mcmpVpcDescribeRegionsService.describeRegions(vpcDescribeRegionsReqBO);
        if (!"0000".equals(vpcDescribeRegionsRspBO.getRespCode())) {
            return RsRspBoUtil.genFailedBo(RsVpcRegionListQueryAbilityRspBo.class, vpcDescribeRegionsRspBO.getRespDesc(), vpcDescribeRegionsRspBO.getRespCode());
        }
        ArrayList<RsVpcRegionBo> rsVpcRegionBos = new ArrayList<RsVpcRegionBo>();
        for (McmpVpcSerRegionsBO mcmpVpcSerRegionsBO : vpcDescribeRegionsRspBO.getRows()) {
            RsVpcRegionBo rsVpcRegionBo = new RsVpcRegionBo();
            BeanUtils.copyProperties((Object)mcmpVpcSerRegionsBO, (Object)rsVpcRegionBo);
            rsVpcRegionBos.add(rsVpcRegionBo);
        }
        rspBo.setRows(rsVpcRegionBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        this.LOGGER.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)rspBo));
        this.LOGGER.info("----------------------\u67e5\u8be2\u4e13\u6709\u7f51\u7edc\u5730\u57df Ability\u670d\u52a1\u7ed3\u675f----------------------");
        return rspBo;
    }
}

