/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.ability.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.tydic.mcmp.resource.ability.api.RsWebSshService;
import com.tydic.mcmp.resource.ability.api.bo.RsWebSshConnectInfoBo;
import com.tydic.mcmp.resource.ability.api.bo.RsWebSshDataBo;
import com.tydic.mcmp.resource.ability.api.bo.RsWebSshServiceRecvHandleBo;
import com.tydic.mcmp.resource.ability.api.bo.RsWebSshServiceSendMsgBo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsWebSshService"})
public class RsWebSshServiceImpl
implements RsWebSshService {
    private static final Logger log = LoggerFactory.getLogger(RsWebSshServiceImpl.class);
    private static Map<String, RsWebSshConnectInfoBo> sshMap = new ConcurrentHashMap<String, RsWebSshConnectInfoBo>();
    private ExecutorService executorService = Executors.newCachedThreadPool();

    @PostMapping(value={"initConnection"})
    public void initConnection(@RequestBody WebSocketSession session) {
        JSch jSch = new JSch();
        RsWebSshConnectInfoBo webSshConnectInfoBo = new RsWebSshConnectInfoBo();
        webSshConnectInfoBo.setjSch(jSch);
        webSshConnectInfoBo.setWebSocketSession(session);
        String uuid = String.valueOf(session.getAttributes().get("user_uuid"));
        sshMap.put(uuid, webSshConnectInfoBo);
    }

    @PostMapping(value={"recvHandle"})
    public void recvHandle(@RequestBody RsWebSshServiceRecvHandleBo recvHandleBo) {
        String buffer = recvHandleBo.getBuffer();
        final WebSocketSession session = recvHandleBo.getSession();
        ObjectMapper objectMapper = new ObjectMapper();
        RsWebSshDataBo webSSHDataBo = null;
        try {
            webSSHDataBo = (RsWebSshDataBo)objectMapper.readValue(buffer, RsWebSshDataBo.class);
        }
        catch (IOException e) {
            log.error("Json\u8f6c\u6362\u5f02\u5e38");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
            return;
        }
        String userId = String.valueOf(session.getAttributes().get("user_uuid"));
        if ("connect".equals(webSSHDataBo.getOperate())) {
            final RsWebSshConnectInfoBo webSshConnectInfoBo = sshMap.get(userId);
            final RsWebSshDataBo finalWebSSHDataBo = webSSHDataBo;
            this.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        RsWebSshServiceImpl.this.connectToSSH(webSshConnectInfoBo, finalWebSSHDataBo, session);
                    }
                    catch (JSchException | IOException e) {
                        log.error("webssh\u8fde\u63a5\u5f02\u5e38");
                        log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
                        RsWebSshServiceImpl.this.close(session);
                    }
                }
            });
        } else if ("command".equals(webSSHDataBo.getOperate())) {
            String command = webSSHDataBo.getCommand();
            RsWebSshConnectInfoBo webSshConnectInfoBo = sshMap.get(userId);
            if (webSshConnectInfoBo != null) {
                try {
                    this.transToSSH(webSshConnectInfoBo.getChannel(), command);
                }
                catch (IOException e) {
                    log.error("webssh\u8fde\u63a5\u5f02\u5e38");
                    log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)e.getMessage());
                    this.close(session);
                }
            }
        } else {
            log.error("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c");
            this.close(session);
        }
    }

    @PostMapping(value={"sendMessage"})
    public void sendMessage(@RequestBody RsWebSshServiceSendMsgBo sendMsgBo) throws IOException {
        WebSocketSession session = sendMsgBo.getSession();
        byte[] buffer = sendMsgBo.getBuffer();
        session.sendMessage((WebSocketMessage)new TextMessage(buffer));
    }

    @PostMapping(value={"close"})
    public void close(@RequestBody WebSocketSession session) {
        String userId = String.valueOf(session.getAttributes().get("user_uuid"));
        RsWebSshConnectInfoBo webSshConnectInfoBo = sshMap.get(userId);
        if (webSshConnectInfoBo != null) {
            if (webSshConnectInfoBo.getChannel() != null) {
                webSshConnectInfoBo.getChannel().disconnect();
            }
            sshMap.remove(userId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectToSSH(RsWebSshConnectInfoBo webSshConnectInfoBo, RsWebSshDataBo webSSHDataBo, WebSocketSession webSocketSession) throws JSchException, IOException {
        Session session = null;
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session = webSshConnectInfoBo.getjSch().getSession(webSSHDataBo.getUsername(), webSSHDataBo.getHost(), webSSHDataBo.getPort().intValue());
        session.setConfig(config);
        session.setPassword(webSSHDataBo.getPassword());
        session.connect(30000);
        Channel channel = session.openChannel("shell");
        channel.connect(3000);
        webSshConnectInfoBo.setChannel(channel);
        InputStream inputStream = channel.getInputStream();
        try {
            byte[] buffer = new byte[1024];
            int i = 0;
            while ((i = inputStream.read(buffer)) != -1) {
                RsWebSshServiceSendMsgBo serviceSendMsgBo = new RsWebSshServiceSendMsgBo();
                serviceSendMsgBo.setBuffer(Arrays.copyOfRange(buffer, 0, i));
                serviceSendMsgBo.setSession(webSocketSession);
                this.sendMessage(serviceSendMsgBo);
            }
        }
        finally {
            session.disconnect();
            channel.disconnect();
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    private void transToSSH(Channel channel, String command) throws IOException {
        if (channel != null) {
            OutputStream outputStream = channel.getOutputStream();
            outputStream.write(command.getBytes());
            outputStream.flush();
        }
    }
}

