/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.ability.api.RsAccountNetworkQueryAbilityService;
import com.tydic.mcmp.resource.ability.api.bo.RsAccountNetworkQueryAbilityReqBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAccountNetworkQueryAbilityRspBo;
import com.tydic.mcmp.resource.ability.api.bo.RsAccountNetworkQueryAbilityRspNetworkBo;
import com.tydic.mcmp.resource.dao.RsInfoNetworkCardMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoNetworkCardPo;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.ability.api.RsAccountNetworkQueryAbilityService"})
public class RsAccountNetworkQueryAbilityServiceImpl
implements RsAccountNetworkQueryAbilityService {
    @Autowired
    private RsInfoNetworkCardMapper rsInfoNetworkCardMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(RsAccountNetworkQueryAbilityServiceImpl.class);

    @PostMapping(value={"queryNetwork"})
    public RsAccountNetworkQueryAbilityRspBo queryNetwork(@RequestBody RsAccountNetworkQueryAbilityReqBo reqBo) {
        RsAccountNetworkQueryAbilityRspBo rspBo = RsRspBoUtil.genSuccessBo(RsAccountNetworkQueryAbilityRspBo.class);
        String check = this.checkReq(reqBo);
        if (!"".equals(check)) {
            rspBo.setRespCode("8887");
            rspBo.setRespDesc(check);
            return rspBo;
        }
        ArrayList<RsAccountNetworkQueryAbilityRspNetworkBo> rsAccountNetworkQueryAbilityRspNetworkBos = new ArrayList<RsAccountNetworkQueryAbilityRspNetworkBo>();
        try {
            List<RsInfoNetworkCardPo> rsInfoNetworkCardPos = this.rsInfoNetworkCardMapper.selectNotRelHostCard(reqBo.getHostResourceId(), reqBo.getRegionId(), reqBo.getZoneId());
            if (!CollectionUtils.isEmpty(rsInfoNetworkCardPos)) {
                for (RsInfoNetworkCardPo rsInfoNetworkCardPo : rsInfoNetworkCardPos) {
                    RsAccountNetworkQueryAbilityRspNetworkBo rsAccountNetworkQueryAbilityRspNetworkBo = new RsAccountNetworkQueryAbilityRspNetworkBo();
                    BeanUtils.copyProperties((Object)rsInfoNetworkCardPo, (Object)rsAccountNetworkQueryAbilityRspNetworkBo);
                    rsAccountNetworkQueryAbilityRspNetworkBos.add(rsAccountNetworkQueryAbilityRspNetworkBo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBo.setRespCode("8887");
            rspBo.setRespDesc("\u67e5\u8be2\u5931\u8d25");
            return rspBo;
        }
        rspBo.setNetworks(rsAccountNetworkQueryAbilityRspNetworkBos);
        return rspBo;
    }

    private List<RsAccountNetworkQueryAbilityRspNetworkBo> mockData() {
        ArrayList<RsAccountNetworkQueryAbilityRspNetworkBo> rsAccountNetworkQueryAbilityRspNetworkBos = new ArrayList<RsAccountNetworkQueryAbilityRspNetworkBo>();
        RsAccountNetworkQueryAbilityRspNetworkBo rsAccountNetworkQueryAbilityRspNetworkBo1 = new RsAccountNetworkQueryAbilityRspNetworkBo();
        rsAccountNetworkQueryAbilityRspNetworkBo1.setCardResourceId(Long.valueOf(10001L));
        rsAccountNetworkQueryAbilityRspNetworkBo1.setCardName("\u5b9e\u4f8b\u7f51\u5361\u6d4b\u8bd51");
        rsAccountNetworkQueryAbilityRspNetworkBos.add(rsAccountNetworkQueryAbilityRspNetworkBo1);
        RsAccountNetworkQueryAbilityRspNetworkBo rsAccountNetworkQueryAbilityRspNetworkBo2 = new RsAccountNetworkQueryAbilityRspNetworkBo();
        rsAccountNetworkQueryAbilityRspNetworkBo2.setCardResourceId(Long.valueOf(10002L));
        rsAccountNetworkQueryAbilityRspNetworkBo2.setCardName("\u5b9e\u4f8b\u7f51\u5361\u6d4b\u8bd52");
        rsAccountNetworkQueryAbilityRspNetworkBos.add(rsAccountNetworkQueryAbilityRspNetworkBo2);
        RsAccountNetworkQueryAbilityRspNetworkBo rsAccountNetworkQueryAbilityRspNetworkBo3 = new RsAccountNetworkQueryAbilityRspNetworkBo();
        rsAccountNetworkQueryAbilityRspNetworkBo3.setCardResourceId(Long.valueOf(10003L));
        rsAccountNetworkQueryAbilityRspNetworkBo3.setCardName("\u5b9e\u4f8b\u7f51\u5361\u6d4b\u8bd53");
        rsAccountNetworkQueryAbilityRspNetworkBos.add(rsAccountNetworkQueryAbilityRspNetworkBo3);
        return rsAccountNetworkQueryAbilityRspNetworkBos;
    }

    private String checkReq(RsAccountNetworkQueryAbilityReqBo reqBo) {
        String s = "";
        if (reqBo.getAccountId() == null && reqBo.getHostResourceId() == null) {
            s = "\u4e3b\u673a\u8d44\u6e90id\u548c\u8d26\u6237id\u5fc5\u4f20\u4e00\u4e2a";
        }
        return s;
    }
}

