/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.ability.api.bo.RsCertificateCreateAbilityReqBo;
import com.tydic.mcmp.resource.busi.api.RsCertificateCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCertificateCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCertificateCreateBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoCertificateMapper;
import com.tydic.mcmp.resource.dao.RsRelCertificateRegionMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoCertificatePo;
import com.tydic.mcmp.resource.dao.po.RsRelCertificateRegionPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RsCertificateCreateBusiServiceImpl
implements RsCertificateCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsCertificateCreateBusiServiceImpl.class);
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoCertificateMapper rsInfoCertificateMapper;
    @Autowired
    private RsRelCertificateRegionMapper rsRelCertificateRegionMapper;

    public RsCertificateCreateBusiRspBo dealRsCertificateCreate(RsCertificateCreateBusiReqBo reqBo) {
        RsCertificateCreateBusiRspBo rspBo = RsRspBoUtil.genSuccessBo(RsCertificateCreateBusiRspBo.class);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getRegionInfoList())) {
            for (RsCertificateCreateAbilityReqBo.RegionInfo regionInfo : reqBo.getRegionInfoList()) {
                RsInfoCertificatePo rsInfoCertificatePo1 = new RsInfoCertificatePo();
                rsInfoCertificatePo1.setCertificateId(regionInfo.getCertificateId());
                List<RsInfoCertificatePo> rsInfoCertificatePos = this.rsInfoCertificateMapper.selectList(rsInfoCertificatePo1);
                Long dataId = 0L;
                if (CollectionUtils.isEmpty(rsInfoCertificatePos)) {
                    RsInfoCertificatePo rsInfoCertificatePo = new RsInfoCertificatePo();
                    BeanUtils.copyProperties((Object)reqBo, (Object)rsInfoCertificatePo);
                    try {
                        dataId = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_CERTIFICATE.toString());
                        rsInfoCertificatePo.setDataId(dataId);
                        rsInfoCertificatePo.setCertificateId(regionInfo.getCertificateId());
                        rsInfoCertificatePo.setCertificateName(reqBo.getCertificateName());
                        rsInfoCertificatePo.setRegionId(((RsCertificateCreateAbilityReqBo.RegionInfo)reqBo.getRegionInfoList().get(0)).getRegionId());
                        rsInfoCertificatePo.setRegionName(((RsCertificateCreateAbilityReqBo.RegionInfo)reqBo.getRegionInfoList().get(0)).getRegionName());
                        rsInfoCertificatePo.setDelFlag(1);
                        rsInfoCertificatePo.setCreateTime(new Date());
                        rsInfoCertificatePo.setCertificateType(reqBo.getCertificateType());
                        if (reqBo.getOperType() != null && reqBo.getOperType() == 1) {
                            rsInfoCertificatePo.setCertificateSource(1);
                        } else {
                            rsInfoCertificatePo.setCertificateSource(2);
                        }
                        this.rsInfoCertificateMapper.insertSelective(rsInfoCertificatePo);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                        throw new McmpBusinessException("8888", "\u63d2\u5165\u5931\u8d25");
                    }
                }
                RsRelCertificateRegionPo rsRelCertificateRegionPo1 = new RsRelCertificateRegionPo();
                rsRelCertificateRegionPo1.setCertificateId(regionInfo.getCertificateId());
                rsRelCertificateRegionPo1.setRegionId(regionInfo.getRegionId());
                List<RsRelCertificateRegionPo> rsRelCertificateRegionPos = this.rsRelCertificateRegionMapper.selectList(rsRelCertificateRegionPo1);
                if (!CollectionUtils.isEmpty(rsRelCertificateRegionPos)) continue;
                try {
                    Long relId = this.sequenceManagement.nextId(RsSequencesEnum.RS_REL_CERTIFICATE_REGION.toString());
                    RsRelCertificateRegionPo rsRelCertificateRegionPo = new RsRelCertificateRegionPo();
                    rsRelCertificateRegionPo.setRelId(relId);
                    rsRelCertificateRegionPo.setCertificateDataId(dataId);
                    rsRelCertificateRegionPo.setCertificateId(regionInfo.getCertificateId());
                    rsRelCertificateRegionPo.setRegionId(regionInfo.getRegionId());
                    rsRelCertificateRegionPo.setRegionName(regionInfo.getRegionName());
                    this.rsRelCertificateRegionMapper.insertSelective(rsRelCertificateRegionPo);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new McmpBusinessException("8888", "\u63d2\u5165\u5931\u8d25");
                }
            }
        }
        return rspBo;
    }
}

