/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.busi.api.RsCheckIpPoolBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCheckIpPoolBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCheckIpPoolBusiRspBo;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RsCheckIpPoolBusiServiceImpl
implements RsCheckIpPoolBusiService {
    public RsCheckIpPoolBusiRspBo checkIpPool(RsCheckIpPoolBusiReqBo busiReqBo) {
        RsCheckIpPoolBusiRspBo busiRspBo = new RsCheckIpPoolBusiRspBo();
        this.valid(busiReqBo);
        List<String> ips = this.getIp(busiReqBo.getIpStart(), busiReqBo.getIpEnd());
        busiRspBo.setIps(ips);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u6821\u9a8c\u6210\u529f");
        return busiRspBo;
    }

    private List<String> getIp(String startIp, String endIp) {
        ArrayList<String> result = new ArrayList<String>();
        Long startIpLong = this.ipToNumber(startIp);
        Long endIpLong = this.ipToNumber(endIp);
        int i = 0;
        while ((long)i <= endIpLong - startIpLong) {
            String ip = this.numberToIp(startIpLong + (long)i);
            String[] iptemp = ip.split("\\.");
            String ipResult = iptemp[3] + "." + iptemp[2] + "." + iptemp[1] + "." + iptemp[0];
            result.add(ipResult);
            ++i;
        }
        if (CollectionUtils.isEmpty(result)) {
            throw new McmpBusinessException("24001", "\u53ef\u7528ip\u4e3a\u7a7a");
        }
        return result;
    }

    private String numberToIp(Long number) {
        String ipStr = "";
        for (int i = 3; i >= 0; --i) {
            ipStr = ipStr + String.valueOf(number & 0xFFL);
            if (i != 0) {
                ipStr = ipStr + ".";
            }
            number = number >> 8;
        }
        return ipStr;
    }

    private Long ipToNumber(String ip) {
        Long ipLong = 0L;
        String[] numbers = ip.split("\\.");
        for (int i = 0; i < 4; ++i) {
            ipLong = ipLong << 8 | (long)Integer.parseInt(numbers[i]);
        }
        return ipLong;
    }

    private void valid(RsCheckIpPoolBusiReqBo busiReqBo) {
        if (!this.isIp(busiReqBo.getIpStart())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u5f00\u59cbIP\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!this.isIp(busiReqBo.getIpEnd())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u7ed3\u675fIP\u5730\u5740\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        if (!this.isIpMask(busiReqBo.getIpNetmask())) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u63a9\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        int maskLen = this.getMaskLen(busiReqBo.getIpNetmask());
        if (!this.isInRange(busiReqBo.getIpEnd(), busiReqBo.getIpStart() + "/" + maskLen)) {
            throw new McmpBusinessException("24001", "\u5165\u53c2\u5f00\u59cbIP\u548c\u7ed3\u675fIP\u4e0d\u5728\u4e00\u4e2a\u7f51\u6bb5\u5185");
        }
    }

    private boolean isInRange(String ip, String cidr) {
        String cidrIp;
        String[] cidrIps;
        int cidrIpAddr;
        int type;
        int mask;
        String[] ips = ip.split("\\.");
        int ipAddr = Integer.parseInt(ips[0]) << 24 | Integer.parseInt(ips[1]) << 16 | Integer.parseInt(ips[2]) << 8 | Integer.parseInt(ips[3]);
        return (ipAddr & (mask = -1 << 32 - (type = Integer.parseInt(cidr.replaceAll(".*/", ""))))) == ((cidrIpAddr = Integer.parseInt((cidrIps = (cidrIp = cidr.replaceAll("/.*", "")).split("\\."))[0]) << 24 | Integer.parseInt(cidrIps[1]) << 16 | Integer.parseInt(cidrIps[2]) << 8 | Integer.parseInt(cidrIps[3])) & mask);
    }

    private boolean isIp(String ip) {
        String IPV4 = "^((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}$";
        if (ip == null) {
            return false;
        }
        Pattern patt = Pattern.compile(IPV4);
        return patt.matcher(ip).matches();
    }

    private boolean isIpMask(String mask) {
        String IP_MASK = "^((128|192)|2(24|4[08]|5[245]))(\\.(0|(128|192)|2((24)|(4[08])|(5[245])))){3}$";
        if (mask == null) {
            return false;
        }
        Pattern patt = Pattern.compile(IP_MASK);
        return patt.matcher(mask).matches();
    }

    private String[] getIpBinary(String ip) {
        String[] strs = ip.split("\\.");
        for (int i = 0; i < 4; ++i) {
            strs[i] = Integer.toBinaryString(Integer.parseInt(strs[i]));
            if (strs[i].length() >= 8) continue;
            StringBuilder zero = new StringBuilder();
            for (int j = 0; j < 8 - strs[i].length(); ++j) {
                zero.append("0");
            }
            strs[i] = zero.toString() + strs[i];
        }
        return strs;
    }

    private byte[] toBinary(String[] binaryStrArr) {
        int bl = binaryStrArr[0].length();
        byte[] bytes = new byte[bl * binaryStrArr.length];
        for (int i = 0; i < binaryStrArr.length; ++i) {
            for (int j = 0; j < bl; ++j) {
                bytes[i * bl + j] = (byte)(binaryStrArr[i].charAt(j) == '1' ? 1 : 0);
            }
        }
        return bytes;
    }

    private int getMaskLen(String mask) {
        String[] maskBinary = this.getIpBinary(mask);
        byte[] maskArr = this.toBinary(maskBinary);
        int maskLen = 0;
        for (int i = 0; i < maskArr.length; ++i) {
            maskLen += maskArr[i];
        }
        return maskLen;
    }
}

