/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDeleteDiskService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDeleteDiskReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDeleteDiskRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsCloudHdReleaseBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdReleaseBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCloudHdReleaseBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelHostHardDiskMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskQueryPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostHardDiskPo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsCloudHdReleaseBusiService")
public class RsCloudHdReleaseBusiServiceImpl
implements RsCloudHdReleaseBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsRelHostHardDiskMapper rsRelHostHardDiskMapper;
    @Autowired
    private McmpCloudSerDeleteDiskService mcmpCloudSerDeleteDiskService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsCloudHdReleaseBusiRspBo deleteHd(RsCloudHdReleaseBusiReqBo reqBo) {
        this.LOGGER.info("\u4e91\u76d8\u91ca\u653e busi\u670d\u52a1:" + reqBo);
        RsCloudHdReleaseBusiRspBo retBo = new RsCloudHdReleaseBusiRspBo();
        RsInfoHardDiskQueryPo hdPo = this.rsInfoHardDiskMapper.selectByQuery(reqBo.getResourceId());
        if (hdPo == null) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230resourceId=" + reqBo.getResourceId() + "\u7684\u4fe1\u606f");
            retBo.setRespCode("2009");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230resourceId=" + reqBo.getResourceId() + "\u7684\u4fe1\u606f");
            return retBo;
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_PROPERTY_SYS.equals(hdPo.getHdProperty())) {
            this.LOGGER.error("\u7cfb\u7edf\u76d8\u4e0d\u53ef\u91ca\u653e");
            retBo.setRespCode("2009");
            retBo.setRespDesc("\u7cfb\u7edf\u76d8\u4e0d\u53ef\u91ca\u653e");
            return retBo;
        }
        if (RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_STATUS_USING.equals(hdPo.getHdStatus())) {
            this.LOGGER.error("\u4e91\u76d8\u4f7f\u7528\u4e2d\uff0c\u4e0d\u53ef\u91ca\u653e");
            retBo.setRespCode("2009");
            retBo.setRespDesc("\u4e91\u76d8\u4f7f\u7528\u4e2d\uff0c\u4e0d\u53ef\u91ca\u653e\uff0c\u5982\u9700\u91ca\u653e\u8bf7\u5148\u89e3\u7ed1\u4e91\u76d8\u3002");
            return retBo;
        }
        McmpCloudSerDeleteDiskRspBO diskRetBo = this.invokeExtInterface(reqBo, hdPo);
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8fd4\u56de\u7684\u53c2\u6570\u4e3a:" + JSON.toJSONString((Object)diskRetBo));
        if (!"0000".equals(diskRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5220\u9664\u4e91\u76d8\u5b9e\u4f8b\u5931\u8d25\uff1a" + diskRetBo.getRespDesc());
            throw new McmpBusinessException("6003", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5220\u9664\u4e91\u76d8\u5b9e\u4f8b\u5931\u8d25\uff1a" + diskRetBo.getRespDesc());
        }
        int result = this.rsInfoHardDiskMapper.deleteByPrimaryKey(reqBo.getResourceId());
        if (result < 1) {
            this.LOGGER.error("\u5220\u9664\u4e91\u76d8\u8bb0\u5f55\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("6003", "\u5220\u9664\u4e91\u76d8\u8bb0\u5f55\u5931\u8d25");
        }
        result = this.rsInfoResourceMapper.deleteByPrimaryKey(reqBo.getResourceId());
        if (result < 1) {
            this.LOGGER.error("\u5220\u9664\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("6003", "\u5220\u9664\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
        this.deletRelHostHd(reqBo);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void deletRelHostHd(RsCloudHdReleaseBusiReqBo reqBo) {
        int result;
        RsRelHostHardDiskPo relPo = new RsRelHostHardDiskPo();
        relPo.setHdResourceId(reqBo.getResourceId());
        List<RsRelHostHardDiskPo> retPo = this.rsRelHostHardDiskMapper.selectBySelective(relPo);
        if (!CollectionUtils.isEmpty(retPo) && (result = this.rsRelHostHardDiskMapper.deleteByRecord(relPo)) < 1) {
            this.LOGGER.error("\u5220\u9664\u5173\u7cfb\u8868\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            throw new McmpBusinessException("6003", "\u5220\u9664\u5173\u7cfb\u8868\u4fe1\u606f\u8fd4\u56de\u503c\u5c0f\u4e8e1");
        }
    }

    private McmpCloudSerDeleteDiskRspBO invokeExtInterface(RsCloudHdReleaseBusiReqBo reqBo, RsInfoHardDiskQueryPo hdPo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)atomReqBo));
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u8d26\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
            throw new McmpBusinessException("6003", "\u67e5\u8be2\u8d26\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpCloudSerDeleteDiskReqBO diskReqBo = new McmpCloudSerDeleteDiskReqBO();
        if (2L == reqBo.getPlatformId()) {
            diskReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            diskReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            diskReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            diskReqBo.setProxyHost(atomRetBo.getProxyHost());
            diskReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            diskReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            diskReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            diskReqBo.setRegion(hdPo.getRegionId());
        }
        diskReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        diskReqBo.setDiskId(hdPo.getInstanceId());
        this.LOGGER.info("\u8c03\u7528\u63a5\u53e3\u7684\u5165\u53c2\uff1a" + JSON.toJSONString((Object)diskReqBo));
        return this.mcmpCloudSerDeleteDiskService.deleteDisk(diskReqBo);
    }
}

