/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.cloudser.McmpCloudSerDescribeDisksService;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeDisksBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeDisksReqBO;
import com.tydic.mcmp.intf.api.cloudser.bo.McmpCloudSerDescribeDisksRspBO;
import com.tydic.mcmp.resource.ability.api.bo.RsHostInstanceCreateAbilityReqHdBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsCreateHostHardDiskBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateHostHardDiskBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateHostHardDiskBusiRspBo;
import com.tydic.mcmp.resource.config.RsPropertiesManager;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsRelHostHardDiskMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsRelHostHardDiskPo;
import com.tydic.mcmp.resource.enums.RsPropertiesEnum;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import com.tydic.starter.timing.job.core.TimingTaskSender;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RsCreateHostHardDiskBusiServiceImpl
implements RsCreateHostHardDiskBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsCreateHostHardDiskBusiServiceImpl.class);
    @Autowired
    private McmpCloudSerDescribeDisksService mcmpCloudSerDescribeDisksService;
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsRelHostHardDiskMapper rsRelHostHardDiskMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsPropertiesManager rsPropertiesManager;
    @Autowired
    private TimingTaskSender rsTaskSender;

    public RsCreateHostHardDiskBusiRspBo createHostHardDisk(RsCreateHostHardDiskBusiReqBo busiReqBo) {
        RsCreateHostHardDiskBusiRspBo busiRspBo = new RsCreateHostHardDiskBusiRspBo();
        RsInfoResourcePo rsInfoResourcePo = this.rsInfoResourceMapper.selectByInstanceId(1L, busiReqBo.getInstanceId());
        if (null != rsInfoResourcePo) {
            RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
            atomReqBo.setAccountId(rsInfoResourcePo.getAccountId());
            atomReqBo.setPlatformId(rsInfoResourcePo.getPlatformId());
            RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
            if (!"0000".equals(atomRspBo.getRespCode())) {
                throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
            }
            ArrayList<RsInfoResourcePo> resourceIds = new ArrayList<RsInfoResourcePo>();
            List<RsHostInstanceCreateAbilityReqHdBo> hdBos = null;
            for (int circleNum = Integer.parseInt(this.rsPropertiesManager.getValue(RsPropertiesEnum.RESOURCE_UPDATE_HOST_DISK_CIRCLE_NUM.getName())); circleNum > 0 && (hdBos = this.invokeDescribeDisks(busiReqBo.getInstanceId(), rsInfoResourcePo, atomRspBo)).size() <= 0; --circleNum) {
                try {
                    Thread.currentThread();
                    Thread.sleep(Integer.parseInt(this.rsPropertiesManager.getValue(RsPropertiesEnum.RESOURCE_UPDATE_HOST_DISK_TRIGGER_TIME.getName())) * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            if (!CollectionUtils.isEmpty(hdBos)) {
                this.insertHdInfo(hdBos, rsInfoResourcePo, resourceIds);
                this.insertResourceInfo(rsInfoResourcePo, resourceIds);
            }
        }
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return busiRspBo;
    }

    private void insertResourceInfo(RsInfoResourcePo rsInfoResourcePoParam, List<RsInfoResourcePo> resourceIds) {
        ArrayList<RsInfoResourcePo> rsInfoResourcePos = new ArrayList<RsInfoResourcePo>();
        for (RsInfoResourcePo po : resourceIds) {
            RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
            BeanUtils.copyProperties((Object)rsInfoResourcePoParam, (Object)rsInfoResourcePo);
            rsInfoResourcePo.setResourceId(po.getResourceId());
            rsInfoResourcePo.setCreateTime(new Date());
            rsInfoResourcePo.setInstanceId(po.getInstanceId());
            rsInfoResourcePo.setResourceName(po.getResourceName());
            rsInfoResourcePo.setServiceId(po.getServiceId());
            rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
            rsInfoResourcePos.add(rsInfoResourcePo);
        }
        int count = this.rsInfoResourceMapper.insertBatch(rsInfoResourcePos);
        if (count != rsInfoResourcePos.size()) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
    }

    private List<RsHostInstanceCreateAbilityReqHdBo> invokeDescribeDisks(String instanceId, RsInfoResourcePo rsInfoResourcePo, RsQueryAliParamAtomRspBo atomRspBo) {
        ArrayList<RsHostInstanceCreateAbilityReqHdBo> rsHostInstanceCreateAbilityReqHdBos = new ArrayList<RsHostInstanceCreateAbilityReqHdBo>();
        McmpCloudSerDescribeDisksReqBO mcmpCloudSerDescribeDisksReqBO = new McmpCloudSerDescribeDisksReqBO();
        mcmpCloudSerDescribeDisksReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpCloudSerDescribeDisksReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpCloudSerDescribeDisksReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpCloudSerDescribeDisksReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpCloudSerDescribeDisksReqBO.setProxyPort(atomRspBo.getProxyPort());
        if (StringUtils.hasText((String)rsInfoResourcePo.getRegionId())) {
            mcmpCloudSerDescribeDisksReqBO.setRegion(rsInfoResourcePo.getRegionId());
        }
        mcmpCloudSerDescribeDisksReqBO.setCloudType(RsInterfaceUtil.convertCloudType(rsInfoResourcePo.getPlatformId()));
        mcmpCloudSerDescribeDisksReqBO.setInstanceId(instanceId);
        log.info("\u4e91\u4e3b\u673a\u4e91\u76d8\u5217\u8868\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDescribeDisksReqBO));
        McmpCloudSerDescribeDisksRspBO mcmpCloudSerDescribeDisksRspBO = this.mcmpCloudSerDescribeDisksService.describeDisks(mcmpCloudSerDescribeDisksReqBO);
        log.info("\u4e91\u4e3b\u673a\u4e91\u76d8\u5217\u8868\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpCloudSerDescribeDisksRspBO));
        if (!"0000".equals(mcmpCloudSerDescribeDisksRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpCloudSerDescribeDisksRspBO.getRespCode(), mcmpCloudSerDescribeDisksRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)mcmpCloudSerDescribeDisksRspBO.getRows())) {
            for (McmpCloudSerDescribeDisksBO mcmpCloudSerDescribeDisksBO : mcmpCloudSerDescribeDisksRspBO.getRows()) {
                RsHostInstanceCreateAbilityReqHdBo rsHostInstanceCreateAbilityReqHdBo = new RsHostInstanceCreateAbilityReqHdBo();
                rsHostInstanceCreateAbilityReqHdBo.setHdDesc(mcmpCloudSerDescribeDisksBO.getDescription());
                rsHostInstanceCreateAbilityReqHdBo.setHdName(mcmpCloudSerDescribeDisksBO.getDiskName());
                rsHostInstanceCreateAbilityReqHdBo.setHdPayType(RsInterfaceUtil.convertAliDiskChargeTypeHdPayType(mcmpCloudSerDescribeDisksBO.getDiskChargeType()));
                rsHostInstanceCreateAbilityReqHdBo.setHdType(RsInterfaceUtil.convertAliDiskCategoryHdType(mcmpCloudSerDescribeDisksBO.getCategory()));
                rsHostInstanceCreateAbilityReqHdBo.setHdProperty(RsInterfaceUtil.convertAliDiskTypeHdProperty(mcmpCloudSerDescribeDisksBO.getType()));
                rsHostInstanceCreateAbilityReqHdBo.setHdSize(mcmpCloudSerDescribeDisksBO.getSize());
                rsHostInstanceCreateAbilityReqHdBo.setInstanceId(mcmpCloudSerDescribeDisksBO.getDiskId());
                rsHostInstanceCreateAbilityReqHdBos.add(rsHostInstanceCreateAbilityReqHdBo);
            }
        }
        return rsHostInstanceCreateAbilityReqHdBos;
    }

    private void insertHdInfo(List<RsHostInstanceCreateAbilityReqHdBo> hdBos, RsInfoResourcePo rsInfoResourcePo, List<RsInfoResourcePo> resourceIds) {
        int count1;
        int count;
        ArrayList<RsInfoHardDiskPo> rsInfoHardDiskPos = new ArrayList<RsInfoHardDiskPo>();
        ArrayList<RsRelHostHardDiskPo> rsRelHostHardDiskPos = new ArrayList<RsRelHostHardDiskPo>();
        if (!CollectionUtils.isEmpty(hdBos)) {
            for (RsHostInstanceCreateAbilityReqHdBo hdBo : hdBos) {
                Long hdResourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
                RsInfoHardDiskPo po = new RsInfoHardDiskPo();
                BeanUtils.copyProperties((Object)hdBo, (Object)po);
                po.setAccountId(rsInfoResourcePo.getAccountId());
                po.setPlatformId(rsInfoResourcePo.getPlatformId());
                po.setHdResourceId(hdResourceId);
                po.setHdStatus(RsDictionaryValueConstants.RS_INFO_HARD_DISK_HD_STATUS_USING);
                rsInfoHardDiskPos.add(po);
                RsRelHostHardDiskPo po1 = new RsRelHostHardDiskPo();
                po1.setHdResourceId(hdResourceId);
                po1.setHostResourceId(rsInfoResourcePo.getResourceId());
                po1.setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_HOST_HARD_DISK.toString()));
                rsRelHostHardDiskPos.add(po1);
                RsInfoResourcePo rsInfoResourcePoNew = new RsInfoResourcePo();
                rsInfoResourcePoNew.setResourceId(hdResourceId);
                rsInfoResourcePoNew.setResourceName("\u4e91\u76d8");
                rsInfoResourcePoNew.setInstanceId(hdBo.getInstanceId());
                rsInfoResourcePoNew.setServiceId(7L);
                resourceIds.add(rsInfoResourcePoNew);
            }
        }
        if (!CollectionUtils.isEmpty(rsInfoHardDiskPos) && (count = this.rsInfoHardDiskMapper.insertBatch(rsInfoHardDiskPos)) != rsInfoHardDiskPos.size()) {
            throw new McmpBusinessException("24010", "\u4e91\u76d8\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(rsRelHostHardDiskPos) && (count1 = this.rsRelHostHardDiskMapper.insertBatch(rsRelHostHardDiskPos)) != rsRelHostHardDiskPos.size()) {
            throw new McmpBusinessException("24010", "\u4e3b\u673a\u4e91\u76d8\u5173\u7cfb\u65b0\u589e\u5931\u8d25");
        }
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

