/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.network.McmpDescribeNetworkBusiService;
import com.tydic.mcmp.intf.api.network.bo.McmpDescribeNetworkReqBO;
import com.tydic.mcmp.intf.api.network.bo.McmpDescribeNetworkRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsCreateHostNetworkBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateHostNetworkBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateHostNetworkBusiRspBo;
import com.tydic.mcmp.resource.config.RsPropertiesManager;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoNetworkCardMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.RsRelHostNetworkMapper;
import com.tydic.mcmp.resource.dao.RsRelNetworkCardSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoNetworkCardPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoSecurityGroupPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostNetworkPo;
import com.tydic.mcmp.resource.dao.po.RsRelNetworkCardSecurityGroupPo;
import com.tydic.mcmp.resource.enums.RsPropertiesEnum;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import com.tydic.starter.timing.job.core.TimingTaskSender;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class RsCreateHostNetworkBusiServiceImpl
implements RsCreateHostNetworkBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsCreateHostNetworkBusiServiceImpl.class);
    @Autowired
    private RsInfoNetworkCardMapper rsInfoNetworkCardMapper;
    @Autowired
    private RsRelHostNetworkMapper rsRelHostNetworkMapper;
    @Autowired
    private McmpDescribeNetworkBusiService mcmpDescribeNetworkBusiService;
    @Autowired
    private TimingTaskSender rsTaskSender;
    @Autowired
    private RsPropertiesManager rsPropertiesManager;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoSecurityGroupMapper rsInfoSecurityGroupMapper;
    @Autowired
    private RsRelNetworkCardSecurityGroupMapper rsRelNetworkCardSecurityGroupMapper;

    public RsCreateHostNetworkBusiRspBo createHostNetwork(RsCreateHostNetworkBusiReqBo busiReqBo) {
        RsCreateHostNetworkBusiRspBo busiRspBo = new RsCreateHostNetworkBusiRspBo();
        RsInfoResourcePo rsInfoResourcePo = this.rsInfoResourceMapper.selectByInstanceId(1L, busiReqBo.getInstanceId());
        if (null != rsInfoResourcePo) {
            RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
            atomReqBo.setAccountId(rsInfoResourcePo.getAccountId());
            atomReqBo.setPlatformId(rsInfoResourcePo.getPlatformId());
            RsQueryAliParamAtomRspBo atomRspBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
            if (!"0000".equals(atomRspBo.getRespCode())) {
                throw new McmpBusinessException(atomRspBo.getRespCode(), atomRspBo.getRespDesc());
            }
            ArrayList<RsInfoResourcePo> resourceIds = new ArrayList<RsInfoResourcePo>();
            List<RsInfoNetworkCardPo> rsInfoNetworkCardPos = null;
            for (int circleNum = Integer.parseInt(this.rsPropertiesManager.getValue(RsPropertiesEnum.RESOURCE_UPDATE_NETWORK_CIRCLE_NUM.getName())); circleNum > 0 && (rsInfoNetworkCardPos = this.invokeDescribeNetwork(busiReqBo.getInstanceId(), rsInfoResourcePo, atomRspBo)).size() <= 0; --circleNum) {
                try {
                    Thread.currentThread();
                    Thread.sleep(Integer.parseInt(this.rsPropertiesManager.getValue(RsPropertiesEnum.RESOURCE_UPDATE_NETWORK_TRIGGER_TIME.getName())) * 1000);
                    continue;
                }
                catch (InterruptedException ie) {
                    ie.printStackTrace();
                }
            }
            if (!CollectionUtils.isEmpty(rsInfoNetworkCardPos)) {
                this.insertNetworkInfo(rsInfoNetworkCardPos, rsInfoResourcePo, resourceIds);
                this.insertResourceInfo(rsInfoResourcePo, resourceIds);
            }
        }
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u64cd\u4f5c\u6210\u529f");
        return busiRspBo;
    }

    private void insertResourceInfo(RsInfoResourcePo rsInfoResourcePoParam, List<RsInfoResourcePo> resourceIds) {
        ArrayList<RsInfoResourcePo> rsInfoResourcePos = new ArrayList<RsInfoResourcePo>();
        for (RsInfoResourcePo po : resourceIds) {
            RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
            BeanUtils.copyProperties((Object)rsInfoResourcePoParam, (Object)rsInfoResourcePo);
            rsInfoResourcePo.setResourceId(po.getResourceId());
            rsInfoResourcePo.setInstanceId(po.getInstanceId());
            rsInfoResourcePo.setResourceName(po.getResourceName());
            rsInfoResourcePo.setServiceId(po.getServiceId());
            rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
            rsInfoResourcePo.setCreateTime(new Date());
            rsInfoResourcePos.add(rsInfoResourcePo);
        }
        int count = this.rsInfoResourceMapper.insertBatch(rsInfoResourcePos);
        if (count != rsInfoResourcePos.size()) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
    }

    private void insertNetworkInfo(List<RsInfoNetworkCardPo> rsInfoNetworkCardPos, RsInfoResourcePo rsInfoResourcePo, List<RsInfoResourcePo> resourceIds) {
        int count1;
        int count;
        ArrayList<RsRelHostNetworkPo> rsRelHostNetworkPos = new ArrayList<RsRelHostNetworkPo>();
        ArrayList<RsRelNetworkCardSecurityGroupPo> rsRelNetworkCardSecurityGroupPos = new ArrayList<RsRelNetworkCardSecurityGroupPo>();
        HashMap<Long, List<String>> cardResourceIdSecurityGroupIdsMap = new HashMap<Long, List<String>>();
        ArrayList<String> securityGroupIdList = new ArrayList<String>();
        for (RsInfoNetworkCardPo po : rsInfoNetworkCardPos) {
            Iterator rsRelHostNetworkPo = new RsRelHostNetworkPo();
            ((RsRelHostNetworkPo)((Object)rsRelHostNetworkPo)).setCardResourceId(po.getCardResourceId());
            ((RsRelHostNetworkPo)((Object)rsRelHostNetworkPo)).setHostResourceId(rsInfoResourcePo.getResourceId());
            ((RsRelHostNetworkPo)((Object)rsRelHostNetworkPo)).setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_HOST_NETWORK.toString()));
            rsRelHostNetworkPos.add((RsRelHostNetworkPo)((Object)rsRelHostNetworkPo));
            List<String> securityGroupIds = po.getSecurityGroupIds();
            if (!CollectionUtils.isEmpty(securityGroupIds)) {
                cardResourceIdSecurityGroupIdsMap.put(po.getCardResourceId(), securityGroupIds);
                securityGroupIdList.addAll(securityGroupIds);
            }
            RsInfoResourcePo rsInfoResourcePoNew = new RsInfoResourcePo();
            rsInfoResourcePoNew.setResourceId(po.getCardResourceId());
            rsInfoResourcePoNew.setResourceName("\u7f51\u5361");
            rsInfoResourcePoNew.setInstanceId(po.getInstanceId());
            rsInfoResourcePoNew.setServiceId(5L);
            resourceIds.add(rsInfoResourcePoNew);
        }
        if (!CollectionUtils.isEmpty(rsInfoNetworkCardPos) && (count = this.rsInfoNetworkCardMapper.insertBatch(rsInfoNetworkCardPos)) != rsInfoNetworkCardPos.size()) {
            throw new McmpBusinessException("24010", "\u7f51\u5361\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(rsRelHostNetworkPos) && (count1 = this.rsRelHostNetworkMapper.insertBatch(rsRelHostNetworkPos)) != rsRelHostNetworkPos.size()) {
            throw new McmpBusinessException("24010", "\u7f51\u5361\u5173\u7cfb\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(securityGroupIdList)) {
            int count2;
            List<RsInfoSecurityGroupPo> rsInfoSecurityGroupPos = this.rsInfoSecurityGroupMapper.queryByInstanceIds(securityGroupIdList);
            HashMap<String, Long> tempMap = new HashMap<String, Long>();
            if (!CollectionUtils.isEmpty(rsInfoSecurityGroupPos)) {
                for (RsInfoSecurityGroupPo po2 : rsInfoSecurityGroupPos) {
                    tempMap.put(po2.getSecurityGroupInstanceId(), po2.getSecurityGroupResourceId());
                }
                for (Long cardResourceId : cardResourceIdSecurityGroupIdsMap.keySet()) {
                    List securityGroupIds1 = (List)cardResourceIdSecurityGroupIdsMap.get(cardResourceId);
                    for (String securityGroupId : securityGroupIds1) {
                        Long securityGroupResourceId = (Long)tempMap.get(securityGroupId);
                        if (null == securityGroupResourceId) continue;
                        RsRelNetworkCardSecurityGroupPo rsRelNetworkCardSecurityGroupPo = new RsRelNetworkCardSecurityGroupPo();
                        rsRelNetworkCardSecurityGroupPo.setSecurityGroupResourceId(securityGroupResourceId);
                        rsRelNetworkCardSecurityGroupPo.setCardResourceId(cardResourceId);
                        rsRelNetworkCardSecurityGroupPo.setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_NETWORK_CARD_SECURITY_GROUP.toString()));
                        rsRelNetworkCardSecurityGroupPos.add(rsRelNetworkCardSecurityGroupPo);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(rsRelNetworkCardSecurityGroupPos) && (count2 = this.rsRelNetworkCardSecurityGroupMapper.insertBatch(rsRelNetworkCardSecurityGroupPos)) != rsRelNetworkCardSecurityGroupPos.size()) {
                throw new McmpBusinessException("24010", "\u7f51\u5361-\u5b89\u5168\u7ec4\u5173\u7cfb\u8868\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }

    private List<RsInfoNetworkCardPo> invokeDescribeNetwork(String instanceId, RsInfoResourcePo rsInfoResourcePo, RsQueryAliParamAtomRspBo atomRspBo) {
        ArrayList<RsInfoNetworkCardPo> rsInfoNetworkCardPos = new ArrayList<RsInfoNetworkCardPo>();
        McmpDescribeNetworkReqBO mcmpDescribeNetworkReqBO = new McmpDescribeNetworkReqBO();
        mcmpDescribeNetworkReqBO.setAccessKeyId(atomRspBo.getAccessKeyId());
        mcmpDescribeNetworkReqBO.setAccessKeySecret(atomRspBo.getAccessKeySecret());
        mcmpDescribeNetworkReqBO.setEndpointPriv(atomRspBo.getEndpoint());
        mcmpDescribeNetworkReqBO.setProxyHost(atomRspBo.getProxyHost());
        mcmpDescribeNetworkReqBO.setProxyPort(atomRspBo.getProxyPort());
        if (StringUtils.hasText((String)rsInfoResourcePo.getRegionId())) {
            mcmpDescribeNetworkReqBO.setRegion(rsInfoResourcePo.getRegionId());
        }
        mcmpDescribeNetworkReqBO.setCloudType(RsInterfaceUtil.convertCloudType(rsInfoResourcePo.getPlatformId()));
        mcmpDescribeNetworkReqBO.setInstanceId(instanceId);
        log.info("\u4e91\u4e3b\u673a\u5f39\u6027\u7f51\u5361\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u5165\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpDescribeNetworkReqBO));
        McmpDescribeNetworkRspBO mcmpDescribeNetworkRspBO = this.mcmpDescribeNetworkBusiService.describeNetwork(mcmpDescribeNetworkReqBO);
        log.info("\u4e91\u4e3b\u673a\u5f39\u6027\u7f51\u5361\u4fe1\u606f\u5217\u8868\u67e5\u8be2\u51fa\u53c2\u4e3a\uff1a" + JSON.toJSONString((Object)mcmpDescribeNetworkRspBO));
        if (!"0000".equals(mcmpDescribeNetworkRspBO.getRespCode())) {
            throw new McmpBusinessException(mcmpDescribeNetworkRspBO.getRespCode(), mcmpDescribeNetworkRspBO.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)mcmpDescribeNetworkRspBO.getNetworkInterfaceSets())) {
            for (McmpDescribeNetworkRspBO.NetworkInterfaceSetsBO bo : mcmpDescribeNetworkRspBO.getNetworkInterfaceSets()) {
                RsInfoNetworkCardPo rsInfoNetworkCardPo = new RsInfoNetworkCardPo();
                Long cardResourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
                rsInfoNetworkCardPo.setInstanceId(bo.getNetworkInterfaceId());
                rsInfoNetworkCardPo.setCardName(bo.getNetworkInterfaceName());
                rsInfoNetworkCardPo.setCardResourceId(cardResourceId);
                rsInfoNetworkCardPo.setCardType(RsInterfaceUtil.convertAliNetworkType(bo.getType()));
                rsInfoNetworkCardPo.setMacAddress(bo.getMacAddress());
                rsInfoNetworkCardPo.setExclusiveNetwork(bo.getVpcId());
                rsInfoNetworkCardPo.setInterchange(bo.getvSwitchId());
                rsInfoNetworkCardPo.setInnerAddress(bo.getPrivateIpAddress());
                rsInfoNetworkCardPo.setPublicAddress(bo.getAssociatedPublicIp().getPublicIpAddress());
                rsInfoNetworkCardPo.setSecurityGroupIds(rsInfoNetworkCardPo.getSecurityGroupIds());
                rsInfoNetworkCardPos.add(rsInfoNetworkCardPo);
            }
        }
        return rsInfoNetworkCardPos;
    }
}

