/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.busi.api.RsCreateIpPoolBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateIpPoolBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateIpPoolBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoVmIpDetailMapper;
import com.tydic.mcmp.resource.dao.RsInfoVmIpPoolMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoVmIpDetailPo;
import com.tydic.mcmp.resource.dao.po.RsInfoVmIpPoolPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsCreateIpPoolBusiServiceImpl
implements RsCreateIpPoolBusiService {
    @Autowired
    private RsInfoVmIpPoolMapper rsInfoVmIpPoolMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoVmIpDetailMapper rsInfoVmIpDetailMapper;

    public RsCreateIpPoolBusiRspBo createIpPool(RsCreateIpPoolBusiReqBo busiReqBo) {
        RsCreateIpPoolBusiRspBo busiRspBo = new RsCreateIpPoolBusiRspBo();
        RsInfoVmIpPoolPo rsInfoVmIpPoolPo = new RsInfoVmIpPoolPo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoVmIpPoolPo);
        rsInfoVmIpPoolPo.setCreateNo(busiReqBo.getOperNo());
        rsInfoVmIpPoolPo.setCreateTime(new Date());
        rsInfoVmIpPoolPo.setIpPoolId(this.getSequenceId(RsSequencesEnum.RS_INFO_VM_IP_POOL.toString()));
        int count = this.rsInfoVmIpPoolMapper.insertSelective(rsInfoVmIpPoolPo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "ip\u5730\u5740\u6c60\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        ArrayList<RsInfoVmIpDetailPo> rsInfoVmIpDetailPos = new ArrayList<RsInfoVmIpDetailPo>();
        List ips = busiReqBo.getIps();
        for (String ip : ips) {
            RsInfoVmIpDetailPo po = new RsInfoVmIpDetailPo();
            po.setIp(ip);
            po.setIpStatus(RsDictionaryValueConstants.RS_INFO_VM_IP_DETAIL_STATUS_TO_USED);
            po.setVmDataCenterId(busiReqBo.getVmDataCenterId());
            po.setVmSwitchId(busiReqBo.getVmSwitchId());
            po.setIpPoolId(rsInfoVmIpPoolPo.getIpPoolId());
            rsInfoVmIpDetailPos.add(po);
        }
        int count1 = this.rsInfoVmIpDetailMapper.insertBatch(rsInfoVmIpDetailPos);
        if (count1 != ips.size()) {
            throw new McmpBusinessException("24010", "\u865a\u62df\u673a-IP\u660e\u7ec6\u8868\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u65b0\u589e\u6210\u529f");
        return busiRspBo;
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

