/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.busi.api.RsCreatePyhsicsHostBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreatePyhsicsHostBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreatePyhsicsHostBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourcePyhsicsHostMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePyhsicsHostPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RsCreatePyhsicsHostBusiServiceImpl
implements RsCreatePyhsicsHostBusiService {
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourcePyhsicsHostMapper rsInfoResourcePyhsicsHostMapper;
    @Autowired
    private SequenceManagement sequenceManagement;

    public RsCreatePyhsicsHostBusiRspBo createPyhsicsHost(RsCreatePyhsicsHostBusiReqBo busiReqBo) {
        RsCreatePyhsicsHostBusiRspBo busiRspBo = new RsCreatePyhsicsHostBusiRspBo();
        Long resourceId = this.insertResourceInfo(busiReqBo);
        this.insertPyhsicsHostMapper(busiReqBo, resourceId);
        busiRspBo.setPyResourceId(resourceId);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u521b\u5efa\u6210\u529f");
        return busiRspBo;
    }

    private Long insertResourceInfo(RsCreatePyhsicsHostBusiReqBo busiReqBo) {
        Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoResourcePo);
        rsInfoResourcePo.setResourceId(resourceId);
        rsInfoResourcePo.setServiceId(9L);
        rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
        rsInfoResourcePo.setPlatformId(4L);
        int count = this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        return resourceId;
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }

    private void insertPyhsicsHostMapper(RsCreatePyhsicsHostBusiReqBo busiReqBo, Long resourceId) {
        RsInfoResourcePyhsicsHostPo pyhsicsHostPo = new RsInfoResourcePyhsicsHostPo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)pyhsicsHostPo);
        pyhsicsHostPo.setPyResourceId(resourceId);
        pyhsicsHostPo.setCreateTime(new Date());
        int count = this.rsInfoResourcePyhsicsHostMapper.insert(pyhsicsHostPo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u7269\u7406\u673a\u8868\u4fe1\u606f\u8868\u65b0\u589e\u5931\u8d25");
        }
    }
}

