/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.atom.api.RsSyncResourceInfoToTicketAtomService;
import com.tydic.mcmp.resource.atom.bo.RsSyncResourceInfoToTicketAtomReqBo;
import com.tydic.mcmp.resource.busi.api.RsCreateVmwareBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateVmwareBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsCreateVmwareBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceVmwareMapper;
import com.tydic.mcmp.resource.dao.RsInfoVmIpDetailMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceVmwarePo;
import com.tydic.mcmp.resource.dao.po.RsInfoVmIpDetailPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.time.job.RsDealVmUpdateIpJob;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import com.tydic.starter.timing.job.bo.SendTaskBo;
import com.tydic.starter.timing.job.core.TimingTaskSender;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RsCreateVmwareBusiServiceImpl
implements RsCreateVmwareBusiService {
    @Autowired
    private RsSyncResourceInfoToTicketAtomService rsSyncResourceInfoToTicketAtomService;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceVmwareMapper rsInfoResourceVmwareMapper;
    @Autowired
    private RsInfoVmIpDetailMapper rsInfoVmIpDetailMapper;
    @Autowired
    private TimingTaskSender rsTaskSender;

    public RsCreateVmwareBusiRspBo createVmware(RsCreateVmwareBusiReqBo busiReqBo) {
        RsCreateVmwareBusiRspBo busiRspBo = new RsCreateVmwareBusiRspBo();
        Long resourceId = this.insertResourceInfo(busiReqBo);
        this.insertVmwareInfo(busiReqBo, resourceId);
        this.syncResourceInfoToTicket(busiReqBo, resourceId);
        this.invokeSendVmCustomizationSet(resourceId);
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u521b\u5efa\u6210\u529f");
        busiRspBo.setVmResourceId(resourceId);
        return busiRspBo;
    }

    private String getIp(RsCreateVmwareBusiReqBo busiReqBo) {
        RsInfoVmIpDetailPo rsInfoVmIpDetailPo = new RsInfoVmIpDetailPo();
        rsInfoVmIpDetailPo.setVmSwitchId(busiReqBo.getVmSwitchId());
        rsInfoVmIpDetailPo.setVmDataCenterId(busiReqBo.getVmDataCenterId());
        rsInfoVmIpDetailPo.setIpStatus(RsDictionaryValueConstants.RS_INFO_VM_IP_DETAIL_STATUS_TO_USED);
        List<RsInfoVmIpDetailPo> ips = this.rsInfoVmIpDetailMapper.getIp(rsInfoVmIpDetailPo);
        if (!CollectionUtils.isEmpty(ips)) {
            for (RsInfoVmIpDetailPo po : ips) {
                RsInfoVmIpDetailPo rsInfoVmIpDetailPo1 = new RsInfoVmIpDetailPo();
                rsInfoVmIpDetailPo1.setIpDetailId(po.getIpDetailId());
                rsInfoVmIpDetailPo1.setIpStatus(RsDictionaryValueConstants.RS_INFO_VM_IP_DETAIL_STATUS_USED);
                rsInfoVmIpDetailPo1.setOldIpStatus(RsDictionaryValueConstants.RS_INFO_VM_IP_DETAIL_STATUS_TO_USED);
                int count = this.rsInfoVmIpDetailMapper.updateByPrimaryKeySelective(rsInfoVmIpDetailPo1);
                if (count != 1) continue;
                String ip = po.getIp();
                return ip;
            }
        }
        return null;
    }

    private void invokeSendVmCustomizationSet(Long vmResourceId) {
        SendTaskBo taskBo = new SendTaskBo();
        String jobGroup = "VM_UPDATE_IP_JOB_GROUP";
        String triggerGroup = "VM_UPDATE_IP_TRIGGER_GROUP";
        String suffix = System.currentTimeMillis() + "";
        int triggerTime = 600;
        taskBo.setJobGroupName(jobGroup);
        taskBo.setTriggerGroupName(triggerGroup);
        taskBo.setJobClass(RsDealVmUpdateIpJob.class);
        taskBo.setJsonKey("VM_UPDATE_IP_JSON_KEY");
        taskBo.setTriggerTime(triggerTime);
        taskBo.setJobKey(jobGroup + "_" + suffix);
        taskBo.setTriggerKey(triggerGroup + "_" + suffix);
        taskBo.setJsonValue(vmResourceId.toString());
        this.rsTaskSender.sendTask(taskBo);
    }

    private void insertVmwareInfo(RsCreateVmwareBusiReqBo busiReqBo, Long resourceId) {
        String ip = this.getIp(busiReqBo);
        RsInfoResourceVmwarePo rsInfoResourceVmwarePo = new RsInfoResourceVmwarePo();
        BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoResourceVmwarePo);
        rsInfoResourceVmwarePo.setVmResourceId(resourceId);
        rsInfoResourceVmwarePo.setInstanceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_INSTALL_OS.toString());
        rsInfoResourceVmwarePo.setInstanceSpecId(busiReqBo.getInstanceSpecId().toString());
        rsInfoResourceVmwarePo.setInnerIpAddress(ip);
        int count = this.rsInfoResourceVmwareMapper.insertSelective(rsInfoResourceVmwarePo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u865a\u62df\u673a\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
    }

    private Long insertResourceInfo(RsCreateVmwareBusiReqBo busiReqBo) {
        RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
        Long resourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoResourcePo);
        rsInfoResourcePo.setCreateTime(new Date());
        rsInfoResourcePo.setResourceId(resourceId);
        rsInfoResourcePo.setServiceId(11L);
        rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_INSTALL_OS);
        int count = this.rsInfoResourceMapper.insertSelective(rsInfoResourcePo);
        if (count != 1) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        return resourceId;
    }

    private void syncResourceInfoToTicket(RsCreateVmwareBusiReqBo busiReqBo, Long resourceId) {
        RsSyncResourceInfoToTicketAtomReqBo rsSyncResourceInfoToTicketAtomReqBo = new RsSyncResourceInfoToTicketAtomReqBo();
        rsSyncResourceInfoToTicketAtomReqBo.setResourceId(resourceId);
        rsSyncResourceInfoToTicketAtomReqBo.setTicketNo(busiReqBo.getTicketNo());
        this.rsSyncResourceInfoToTicketAtomService.syncResourceInfoToTicket(rsSyncResourceInfoToTicketAtomReqBo);
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }
}

