/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.rds.McmpIntfDatabaseOperDBInstancesService;
import com.tydic.mcmp.intf.api.rds.bo.McmpIntfDatabaseOperDBInstancesReqBO;
import com.tydic.mcmp.intf.api.rds.bo.McmpIntfDatabaseOperDBInstancesRspBO;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsDatabaseReleaseBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabaseReleaseBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsDatabaseReleaseBusiRspBo;
import com.tydic.mcmp.resource.dao.RsInfoResourceDatabaseMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsDatabaseReleaseBusiService")
public class RsDatabaseReleaseBusiServiceImpl
implements RsDatabaseReleaseBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final String OPERATION_TYPE_DELETE = "2";
    @Autowired
    private RsInfoResourceDatabaseMapper rsInfoResourceDatabaseMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private McmpIntfDatabaseOperDBInstancesService mcmpIntfDatabaseOperDBInstancesService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;

    public RsDatabaseReleaseBusiRspBo deleteDbIns(RsDatabaseReleaseBusiReqBo reqBo) {
        this.LOGGER.info("\u6570\u636e\u5e93\u5b9e\u4f8b\u91ca\u653ebusi\u670d\u52a1\uff1a" + reqBo);
        RsDatabaseReleaseBusiRspBo retBo = new RsDatabaseReleaseBusiRspBo();
        RsInfoResourcePo resourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(reqBo.getResourceId());
        if (resourcePo == null) {
            this.LOGGER.error("\u8d44\u6e90ID\uff1a(" + reqBo.getResourceId() + ")\u4e0d\u5b58\u5728");
            retBo.setRespCode("2010");
            retBo.setRespDesc("\u8d44\u6e90ID\uff1a(" + reqBo.getResourceId() + ")\u4e0d\u5b58\u5728");
            return retBo;
        }
        McmpIntfDatabaseOperDBInstancesRspBO dbInsRetBo = this.invokeExtInterface(reqBo, resourcePo);
        this.LOGGER.info("\u8c03\u7528\u63a5\u53e3\u8fd4\u56de\u7684\u53c2\u6570\uff1a" + JSON.toJSONString((Object)dbInsRetBo));
        if (!"0000".equals(dbInsRetBo.getRespCode())) {
            this.LOGGER.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u64cd\u4f5c\u6570\u636e\u5e93\u5b9e\u4f8b\u5931\u8d25\uff1a" + dbInsRetBo.getRespDesc());
            throw new McmpBusinessException("6005", dbInsRetBo.getMessage());
        }
        if (OPERATION_TYPE_DELETE.equals(reqBo.getOperType())) {
            this.LOGGER.info("\u6267\u884c\u7684\u662f\u6570\u636e\u5e93\u5220\u9664\uff0c\u5373\u5c06\u5220\u9664\u6570\u636e");
            int result = this.rsInfoResourceMapper.deleteByPrimaryKey(reqBo.getResourceId());
            if (result < 1) {
                throw new McmpBusinessException("6005", "\u5220\u9664\u6570\u636e\u5e93\u65f6\uff0c\u5220\u9664\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
            result = this.rsInfoResourceDatabaseMapper.deleteByPrimaryKey(reqBo.getResourceId());
            if (result < 1) {
                throw new McmpBusinessException("6005", "\u5220\u9664\u6570\u636e\u5e93\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            }
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private McmpIntfDatabaseOperDBInstancesRspBO invokeExtInterface(RsDatabaseReleaseBusiReqBo reqBo, RsInfoResourcePo resourcePo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            this.LOGGER.error("\u67e5\u8be2\u8d26\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
            throw new McmpBusinessException("6005", "\u67e5\u8be2\u8d26\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpIntfDatabaseOperDBInstancesReqBO dabInsReqBo = new McmpIntfDatabaseOperDBInstancesReqBO();
        if (2L == reqBo.getPlatformId()) {
            dabInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            dabInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            dabInsReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            dabInsReqBo.setProxyHost(atomRetBo.getProxyHost());
            dabInsReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            dabInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            dabInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            dabInsReqBo.setRegion(resourcePo.getRegionId());
        }
        dabInsReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        dabInsReqBo.setOperType(reqBo.getOperType());
        dabInsReqBo.setDBInstanceId(resourcePo.getInstanceId());
        this.LOGGER.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u5165\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)dabInsReqBo));
        return this.mcmpIntfDatabaseOperDBInstancesService.operDBInstances(dabInsReqBo);
    }
}

