/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsHostDiskCapacityQueryBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsHostDiskCapacityQueryBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsHostDiskCapacityQueryBusiRspBo;
import com.tydic.mcmp.resource.common.bo.RsHostDiskInfoDataBo;
import com.tydic.mcmp.resource.dao.RsInfoHardDiskMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceHostMapper;
import com.tydic.mcmp.resource.dao.RsRelHostHardDiskMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHardDiskPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostHardDiskPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsHostDiskCapacityQueryBusiService")
public class RsHostDiskCapacityQueryBusiServiceImpl
implements RsHostDiskCapacityQueryBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoResourceHostMapper rsInfoResourceHostMapper;
    @Autowired
    private RsRelHostHardDiskMapper rsRelHostHardDiskMapper;
    @Autowired
    private RsInfoHardDiskMapper rsInfoHardDiskMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public RsHostDiskCapacityQueryBusiRspBo qryDiskCapacity(RsHostDiskCapacityQueryBusiReqBo reqBo) {
        this.LOGGER.info("\u4e3b\u673a\u78c1\u76d8\u5bb9\u91cf\u67e5\u8be2Busi\u670d\u52a1\uff1a" + reqBo);
        RsHostDiskCapacityQueryBusiRspBo retBo = new RsHostDiskCapacityQueryBusiRspBo();
        RsRelHostHardDiskPo relDiskReqPo = new RsRelHostHardDiskPo();
        relDiskReqPo.setHostResourceId(reqBo.getHostResourceId());
        List<RsRelHostHardDiskPo> relDiskPos = this.rsRelHostHardDiskMapper.selectBySelective(relDiskReqPo);
        if (CollectionUtils.isEmpty(relDiskPos)) {
            this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u4e3b\u673a\uff08" + reqBo.getHostResourceId() + "\uff09\u7684\u78c1\u76d8\u4fe1\u606f");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e3b\u673a\uff08" + reqBo.getHostResourceId() + "\uff09\u7684\u78c1\u76d8\u4fe1\u606f");
            return retBo;
        }
        ArrayList<RsInfoHardDiskPo> hardDiskInfos = new ArrayList<RsInfoHardDiskPo>();
        RsInfoHardDiskPo qryHardDiskPo = new RsInfoHardDiskPo();
        qryHardDiskPo.setHdProperty(reqBo.getHdProperty());
        for (RsRelHostHardDiskPo relDiskPo : relDiskPos) {
            qryHardDiskPo.setHdResourceId(relDiskPo.getHdResourceId());
            List<RsInfoHardDiskPo> hardDiskPoList = this.rsInfoHardDiskMapper.selectByCondition(qryHardDiskPo);
            if (CollectionUtils.isEmpty(hardDiskPoList)) {
                this.LOGGER.error("\u672a\u67e5\u8be2\u5230\u78c1\u76d8(" + relDiskPo.getHdResourceId() + ")\u7684\u4fe1\u606f");
                retBo.setRespCode("8887");
                retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u78c1\u76d8(" + relDiskPo.getHdResourceId() + ")\u7684\u4fe1\u606f");
                return retBo;
            }
            hardDiskInfos.add(hardDiskPoList.get(0));
        }
        Map<String, Map<String, String>> dicMap = this.getDicMap();
        ArrayList<RsHostDiskInfoDataBo> diskInfos = new ArrayList<RsHostDiskInfoDataBo>();
        for (RsInfoHardDiskPo po : hardDiskInfos) {
            RsHostDiskInfoDataBo dataBo = new RsHostDiskInfoDataBo();
            BeanUtils.copyProperties((Object)po, (Object)dataBo);
            dataBo.setHdStatusName(dicMap.get("RS_INFO_HARD_DISK_HD_STATUS").get(dataBo.getHdStatus().toString()));
            dataBo.setHdPayTypeName(dicMap.get("RS_INFO_HARD_DISK_HD_PAY_TYPE").get(dataBo.getHdPayType().toString()));
            dataBo.setHdPropertyName(dicMap.get("RS_INFO_HARD_DISK_HD_PROPERTY").get(dataBo.getHdProperty().toString()));
            dataBo.setHdTypeName(dicMap.get("RS_INFO_HARD_DISK_HD_TYPE").get(dataBo.getHdType().toString()));
            diskInfos.add(dataBo);
        }
        retBo.setHostResourceId(reqBo.getHostResourceId());
        retBo.setDiskInfos(diskInfos);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("RS_INFO_HARD_DISK_HD_STATUS");
        codes.add("RS_INFO_HARD_DISK_HD_PROPERTY");
        codes.add("RS_INFO_HARD_DISK_HD_PAY_TYPE");
        codes.add("RS_INFO_HARD_DISK_HD_TYPE");
        RsDicMapQueryAtomReqBo atomReqBo = new RsDicMapQueryAtomReqBo();
        for (String code : codes) {
            atomReqBo.setType(code);
            RsDicMapQueryAtomRspBo atomRetBo = this.rsDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(code, atomRetBo.getDicMap());
        }
        return dicMap;
    }
}

