/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.ability.api.bo.RsHostInstanceCreateAbilityReqSecurityGroupBo;
import com.tydic.mcmp.resource.atom.api.RsSyncResourceInfoToTicketAtomService;
import com.tydic.mcmp.resource.atom.bo.RsSyncResourceInfoToTicketAtomReqBo;
import com.tydic.mcmp.resource.busi.api.RsHostInstanceCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsHostInstanceCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsHostInstanceCreateBusiRspBo;
import com.tydic.mcmp.resource.config.RsPropertiesManager;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsHostSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceHostMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.RsRelHostSecurityKeyMapper;
import com.tydic.mcmp.resource.dao.po.RsHostSecurityGroupPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceHostPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoSecurityGroupPo;
import com.tydic.mcmp.resource.dao.po.RsRelHostSecurityKeyPo;
import com.tydic.mcmp.resource.enums.RsPropertiesEnum;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.time.job.RsDealHostHardDiskJob;
import com.tydic.mcmp.resource.time.job.RsDealHostNetworkJob;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import com.tydic.starter.timing.job.bo.SendTaskBo;
import com.tydic.starter.timing.job.core.TimingTaskSender;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RsHostInstanceCreateBusiServiceImpl
implements RsHostInstanceCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsHostInstanceCreateBusiServiceImpl.class);
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private RsInfoResourceHostMapper rsInfoResourceHostMapper;
    @Autowired
    private RsInfoSecurityGroupMapper rsInfoSecurityGroupMapper;
    @Autowired
    private RsHostSecurityGroupMapper rsHostSecurityGroupMapper;
    @Autowired
    private RsRelHostSecurityKeyMapper rsRelHostSecurityKeyMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsSyncResourceInfoToTicketAtomService rsSyncResourceInfoToTicketAtomService;
    @Autowired
    private TimingTaskSender rsTaskSender;
    @Autowired
    private RsPropertiesManager rsPropertiesManager;

    public RsHostInstanceCreateBusiRspBo createHost(RsHostInstanceCreateBusiReqBo busiReqBo) {
        RsHostInstanceCreateBusiRspBo busiRspBo = new RsHostInstanceCreateBusiRspBo();
        ArrayList<RsInfoResourcePo> resourceIds = new ArrayList<RsInfoResourcePo>();
        Map<Long, String> hostResourceIdMap = this.insertHostInfo(busiReqBo, resourceIds);
        this.insertSecurityGroupInfo(busiReqBo, hostResourceIdMap.keySet(), resourceIds);
        this.insertSecurityInfo(busiReqBo, hostResourceIdMap.keySet());
        this.insertResourceInfo(busiReqBo, resourceIds);
        this.syncResourceInfoToTicket(null, hostResourceIdMap.keySet(), busiReqBo.getTicketNo());
        this.invokeSendHardDiskTask(busiReqBo.getInstanceIdSets());
        this.invokeSendNetworkTask(busiReqBo.getInstanceIdSets());
        BeanUtils.copyProperties((Object)busiReqBo, (Object)busiRspBo);
        busiRspBo.setResourceId(hostResourceIdMap.keySet());
        busiRspBo.setRespCode("0000");
        busiRspBo.setRespDesc("\u5b9e\u4f8b\u521b\u5efa\u6210\u529f");
        return busiRspBo;
    }

    private void invokeSendNetworkTask(List<String> instanceIdSets) {
        for (String instanceId : instanceIdSets) {
            SendTaskBo taskBo = new SendTaskBo();
            String jobGroup = "RESOURCE_UPDATE_NETWORK_JOB_GROUP";
            String triggerGroup = "RESOURCE_UPDATE_NETWORK_TRIGGER_GROUP";
            String suffix = System.currentTimeMillis() + "";
            int triggerTime = Integer.parseInt(this.rsPropertiesManager.getValue(RsPropertiesEnum.RESOURCE_UPDATE_NETWORK_TRIGGER_TIME.getName()));
            taskBo.setJobGroupName(jobGroup);
            taskBo.setTriggerGroupName(triggerGroup);
            taskBo.setJobClass(RsDealHostNetworkJob.class);
            taskBo.setJsonKey("RESOURCE_UPDATE_NETWORK_JSON_KEY");
            taskBo.setJsonValue(instanceId);
            taskBo.setTriggerTime(triggerTime);
            taskBo.setJobKey(jobGroup + "_" + suffix);
            taskBo.setTriggerKey(triggerGroup + "_" + suffix);
            this.rsTaskSender.sendTask(taskBo);
        }
    }

    private void invokeSendHardDiskTask(List<String> instanceIdSets) {
        for (String instanceId : instanceIdSets) {
            SendTaskBo taskBo = new SendTaskBo();
            String jobGroup = "RESOURCE_UPDATE_HOST_DISK_JOB_GROUP";
            String triggerGroup = "RESOURCE_UPDATE_HOST_DISK_TRIGGER_GROUP";
            String suffix = System.currentTimeMillis() + "";
            int triggerTime = Integer.parseInt(this.rsPropertiesManager.getValue(RsPropertiesEnum.RESOURCE_UPDATE_HOST_DISK_TRIGGER_TIME.getName()));
            taskBo.setJobGroupName(jobGroup);
            taskBo.setTriggerGroupName(triggerGroup);
            taskBo.setJobClass(RsDealHostHardDiskJob.class);
            taskBo.setJsonKey("RESOURCE_UPDATE_HOST_DISK_JSON_KEY");
            taskBo.setJsonValue(instanceId);
            taskBo.setTriggerTime(triggerTime);
            taskBo.setJobKey(jobGroup + "_" + suffix);
            taskBo.setTriggerKey(triggerGroup + "_" + suffix);
            this.rsTaskSender.sendTask(taskBo);
        }
    }

    private void syncResourceInfoToTicket(Long resourceId, Set<Long> resourceIds, String ticketNo) {
        RsSyncResourceInfoToTicketAtomReqBo rsSyncResourceInfoToTicketAtomReqBo = new RsSyncResourceInfoToTicketAtomReqBo();
        rsSyncResourceInfoToTicketAtomReqBo.setResourceId(resourceId);
        rsSyncResourceInfoToTicketAtomReqBo.setTicketNo(ticketNo);
        rsSyncResourceInfoToTicketAtomReqBo.setResourceIds(resourceIds);
        this.rsSyncResourceInfoToTicketAtomService.syncResourceInfoToTicket(rsSyncResourceInfoToTicketAtomReqBo);
    }

    private Long getSequenceId(String sequenceName) {
        try {
            Long sequenceId = this.sequenceManagement.nextId(sequenceName);
            return sequenceId;
        }
        catch (SQLException e) {
            throw new McmpBusinessException("24013", "\u83b7\u53d6\u5e8f\u5217\u5f02\u5e38");
        }
    }

    private void insertResourceInfo(RsHostInstanceCreateBusiReqBo busiReqBo, List<RsInfoResourcePo> resourceIds) {
        ArrayList<RsInfoResourcePo> rsInfoResourcePos = new ArrayList<RsInfoResourcePo>();
        for (RsInfoResourcePo po : resourceIds) {
            RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
            BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoResourcePo);
            rsInfoResourcePo.setCreateTime(new Date());
            rsInfoResourcePo.setResourceId(po.getResourceId());
            rsInfoResourcePo.setInstanceId(po.getInstanceId());
            rsInfoResourcePo.setResourceName(po.getResourceName());
            rsInfoResourcePo.setServiceId(po.getServiceId());
            rsInfoResourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
            rsInfoResourcePos.add(rsInfoResourcePo);
        }
        int count = this.rsInfoResourceMapper.insertBatch(rsInfoResourcePos);
        if (count != rsInfoResourcePos.size()) {
            throw new McmpBusinessException("24010", "\u8d44\u6e90\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
    }

    private Map<Long, String> insertHostInfo(RsHostInstanceCreateBusiReqBo busiReqBo, List<RsInfoResourcePo> resourceIds) {
        HashMap<Long, String> hostResourceIdMap = new HashMap<Long, String>();
        ArrayList<RsInfoResourceHostPo> rsInfoResourceHostPos = new ArrayList<RsInfoResourceHostPo>();
        for (String instanceId : busiReqBo.getInstanceIdSets()) {
            Long hostResourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
            RsInfoResourceHostPo rsInfoResourceHostPo = new RsInfoResourceHostPo();
            BeanUtils.copyProperties((Object)busiReqBo, (Object)rsInfoResourceHostPo);
            rsInfoResourceHostPo.setHostResourceId(hostResourceId);
            rsInfoResourceHostPo.setInstanceCreateTime(new Date());
            rsInfoResourceHostPo.setInstanceId(instanceId);
            rsInfoResourceHostPo.setInstanceStatus("Running");
            rsInfoResourceHostPos.add(rsInfoResourceHostPo);
            RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
            rsInfoResourcePo.setResourceId(hostResourceId);
            rsInfoResourcePo.setInstanceId(instanceId);
            rsInfoResourcePo.setResourceName("\u4e3b\u673a");
            rsInfoResourcePo.setServiceId(1L);
            resourceIds.add(rsInfoResourcePo);
            hostResourceIdMap.put(hostResourceId, instanceId);
        }
        int count = this.rsInfoResourceHostMapper.insertBatch(rsInfoResourceHostPos);
        if (count != rsInfoResourceHostPos.size()) {
            throw new McmpBusinessException("24010", "\u4e3b\u673a\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
        }
        return hostResourceIdMap;
    }

    private void insertSecurityGroupInfo(RsHostInstanceCreateBusiReqBo busiReqBo, Set<Long> hostResourceIdSet, List<RsInfoResourcePo> resourceIds) {
        if (!CollectionUtils.isEmpty((Collection)busiReqBo.getSecurityGroups())) {
            int count;
            List securityGroups = busiReqBo.getSecurityGroups();
            ArrayList<RsHostSecurityGroupPo> rsHostSecurityGroupPos = new ArrayList<RsHostSecurityGroupPo>();
            ArrayList<RsInfoSecurityGroupPo> rsInfoSecurityGroupPos = new ArrayList<RsInfoSecurityGroupPo>();
            for (Long hostResourceId : hostResourceIdSet) {
                for (RsHostInstanceCreateAbilityReqSecurityGroupBo securityGroupBo : securityGroups) {
                    RsInfoSecurityGroupPo record = new RsInfoSecurityGroupPo();
                    record.setTenementId(busiReqBo.getTenementId());
                    record.setAccountId(busiReqBo.getAccountId());
                    record.setPlatformId(busiReqBo.getPlatformId());
                    record.setSecurityGroupInstanceId(securityGroupBo.getSecurityGroupInstanceId());
                    RsInfoSecurityGroupPo rsInfoSecurityGroupPo = this.rsInfoSecurityGroupMapper.selectByInstanceId(record);
                    if (rsInfoSecurityGroupPo == null) {
                        Long securityGroupResourceId = this.getSequenceId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
                        RsInfoSecurityGroupPo po = new RsInfoSecurityGroupPo();
                        BeanUtils.copyProperties((Object)securityGroupBo, (Object)po);
                        po.setAccountId(busiReqBo.getAccountId());
                        po.setPlatformId(busiReqBo.getPlatformId());
                        po.setSecurityGroupResourceId(securityGroupResourceId);
                        po.setTenementId(busiReqBo.getTenementId());
                        securityGroupBo.setSecurityGroupResourceId(securityGroupResourceId);
                        rsInfoSecurityGroupPos.add(po);
                        RsInfoResourcePo rsInfoResourcePo = new RsInfoResourcePo();
                        rsInfoResourcePo.setResourceId(securityGroupResourceId);
                        rsInfoResourcePo.setInstanceId(securityGroupBo.getSecurityGroupInstanceId());
                        rsInfoResourcePo.setResourceName("\u5b89\u5168\u7ec4");
                        rsInfoResourcePo.setServiceId(6L);
                        resourceIds.add(rsInfoResourcePo);
                    } else {
                        securityGroupBo.setSecurityGroupResourceId(rsInfoSecurityGroupPo.getSecurityGroupResourceId());
                    }
                    RsHostSecurityGroupPo po1 = new RsHostSecurityGroupPo();
                    BeanUtils.copyProperties((Object)securityGroupBo, (Object)po1);
                    po1.setSecurityGroupResourceId(securityGroupBo.getSecurityGroupResourceId());
                    po1.setHostResourceId(hostResourceId);
                    po1.setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_NETWORK_CARD_SECURITY_GROUP.toString()));
                    rsHostSecurityGroupPos.add(po1);
                }
            }
            if (!CollectionUtils.isEmpty(rsInfoSecurityGroupPos) && (count = this.rsInfoSecurityGroupMapper.insertBatch(rsInfoSecurityGroupPos)) != rsInfoSecurityGroupPos.size()) {
                throw new McmpBusinessException("24010", "\u4e91\u76d8\u4fe1\u606f\u65b0\u589e\u5931\u8d25");
            }
            int count1 = this.rsHostSecurityGroupMapper.insertBatch(rsHostSecurityGroupPos);
            if (count1 != rsHostSecurityGroupPos.size()) {
                throw new McmpBusinessException("24010", "\u4e3b\u673a\u4e91\u76d8\u5173\u7cfb\u65b0\u589e\u5931\u8d25");
            }
        }
    }

    private void insertSecurityInfo(RsHostInstanceCreateBusiReqBo busiReqBo, Set<Long> hostResourceIdSet) {
        if (busiReqBo.getSecurityId() != null) {
            ArrayList<RsRelHostSecurityKeyPo> rsRelHostSecurityKeyPos = new ArrayList<RsRelHostSecurityKeyPo>();
            for (Long hostResourceId : hostResourceIdSet) {
                RsRelHostSecurityKeyPo rsRelHostSecurityKeyPo = new RsRelHostSecurityKeyPo();
                rsRelHostSecurityKeyPo.setHostResourceId(hostResourceId);
                rsRelHostSecurityKeyPo.setSecurityKeyId(busiReqBo.getSecurityId());
                rsRelHostSecurityKeyPo.setRelId(this.getSequenceId(RsSequencesEnum.RS_REL_HOST_SECURITY_KEY.toString()));
                rsRelHostSecurityKeyPos.add(rsRelHostSecurityKeyPo);
            }
            int count = this.rsRelHostSecurityKeyMapper.insertBatch(rsRelHostSecurityKeyPos);
            if (count != rsRelHostSecurityKeyPos.size()) {
                throw new McmpBusinessException("24010", "\u4e3b\u673a-\u5bc6\u94a5\u5bf9-\u5173\u7cfb\u8868\u65b0\u589e\u5931\u8d25");
            }
        }
    }
}

