/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.resource.busi.api.RsHostRelSecurityGroupModifyBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsHostRelSecurityGroupModifyBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsHostRelSecurityGroupModifyBusiRspBo;
import com.tydic.mcmp.resource.dao.RsHostSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceHostMapper;
import com.tydic.mcmp.resource.dao.RsInfoSecurityGroupMapper;
import com.tydic.mcmp.resource.dao.po.RsHostSecurityGroupPo;
import com.tydic.mcmp.resource.dao.po.RsInfoResourceHostPo;
import com.tydic.mcmp.resource.dao.po.RsInfoSecurityGroupPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsRspBoUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"MCMP_GROUP/1.0.0/com.tydic.mcmp.resource.busi.api.RsHostRelSecurityGroupModifyBusiService"})
public class RsHostRelSecurityGroupModifyBusiServiceImpl
implements RsHostRelSecurityGroupModifyBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsHostRelSecurityGroupModifyBusiServiceImpl.class);
    @Autowired
    private RsInfoResourceHostMapper rsInfoResourceHostMapper;
    @Autowired
    private RsInfoSecurityGroupMapper rsInfoSecurityGroupMapper;
    @Autowired
    private SequenceManagement sequenceManagement;
    @Autowired
    private RsHostSecurityGroupMapper rsHostSecurityGroupMapper;

    @PostMapping(value={"dealRsHostRelSecurityGroupModify"})
    public RsHostRelSecurityGroupModifyBusiRspBo dealRsHostRelSecurityGroupModify(@RequestBody RsHostRelSecurityGroupModifyBusiReqBo reqBo) {
        RsHostRelSecurityGroupModifyBusiRspBo rspBo = RsRspBoUtil.genSuccessBo(RsHostRelSecurityGroupModifyBusiRspBo.class);
        ArrayList<Long> hostIds = new ArrayList<Long>();
        for (Object id : reqBo.getHostInstanceIds()) {
            RsInfoResourceHostPo rsInfoResourceHostPo = new RsInfoResourceHostPo();
            rsInfoResourceHostPo.setInstanceId((String)id);
            List<RsInfoResourceHostPo> rsInfoResourceHostPos = this.rsInfoResourceHostMapper.selectList(rsInfoResourceHostPo);
            if (CollectionUtils.isEmpty(rsInfoResourceHostPos)) {
                throw new McmpBusinessException("8888", "\u8bf7\u8f93\u5165\u6b63\u786e\u5b9e\u4f8bID");
            }
            hostIds.add(rsInfoResourceHostPos.get(0).getHostResourceId());
        }
        ArrayList<RsInfoSecurityGroupPo> rsInfoSecurityGroupPos = new ArrayList<RsInfoSecurityGroupPo>();
        for (String string : reqBo.getSecurityGroupInstanceIds()) {
            RsInfoSecurityGroupPo rsInfoSecurityGroupPo = new RsInfoSecurityGroupPo();
            rsInfoSecurityGroupPo.setSecurityGroupInstanceId(string);
            RsInfoSecurityGroupPo rsInfoSecurityGroupPo1 = this.rsInfoSecurityGroupMapper.selectByInstanceId(rsInfoSecurityGroupPo);
            if (rsInfoSecurityGroupPo1 == null || rsInfoSecurityGroupPo1.getSecurityGroupInstanceId() == null) {
                throw new McmpBusinessException("8888", "\u8bf7\u8f93\u5165\u6b63\u786e\u5b89\u5168\u7ec4\u5b9e\u4f8bID");
            }
            rsInfoSecurityGroupPos.add(rsInfoSecurityGroupPo1);
        }
        try {
            this.rsHostSecurityGroupMapper.deleteByHostIds(hostIds);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new McmpBusinessException("8888", "\u66ff\u6362\u5931\u8d25");
        }
        try {
            for (Long l : hostIds) {
                ArrayList<RsHostSecurityGroupPo> rsHostSecurityGroupPos = new ArrayList<RsHostSecurityGroupPo>();
                for (RsInfoSecurityGroupPo rsInfoSecurityGroupPo : rsInfoSecurityGroupPos) {
                    RsHostSecurityGroupPo rsHostSecurityGroupPo = new RsHostSecurityGroupPo();
                    Long relId = this.sequenceManagement.nextId(RsSequencesEnum.RS_HOST_SECURITY_GROUP.toString());
                    rsHostSecurityGroupPo.setRelId(relId);
                    rsHostSecurityGroupPo.setHostResourceId(l);
                    rsHostSecurityGroupPo.setSecurityGroupResourceId(rsInfoSecurityGroupPo.getSecurityGroupResourceId());
                    rsHostSecurityGroupPo.setSecurityGroupInstanceId(rsInfoSecurityGroupPo.getSecurityGroupInstanceId());
                    rsHostSecurityGroupPo.setSecurityGroupName(rsInfoSecurityGroupPo.getSecurityGroupName());
                    rsHostSecurityGroupPo.setSecurityGroupDesc(rsInfoSecurityGroupPo.getSecurityGroupDesc());
                    rsHostSecurityGroupPos.add(rsHostSecurityGroupPo);
                }
                this.rsHostSecurityGroupMapper.insertBatch(rsHostSecurityGroupPos);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new McmpBusinessException("8888", "\u66ff\u6362\u5931\u8d25");
        }
        return rspBo;
    }
}

