/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageBo;
import com.tydic.mcmp.cloud.common.base.bo.McmpRspPageDataBo;
import com.tydic.mcmp.resource.atom.api.RsDicMapQueryAtomService;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsDicMapQueryAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsHostSnapshotQueryPageBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsHostSnapshotQueryPageBusiReqBo;
import com.tydic.mcmp.resource.common.bo.RsHostSnapshotQueryDataBo;
import com.tydic.mcmp.resource.dao.RsInfoHostSnapshotMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoHostSnapshotQueryPo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="rsHostSnapshotQueryPageBusiService")
public class RsHostSnapshotQueryPageBusiServiceImpl
implements RsHostSnapshotQueryPageBusiService {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RsInfoHostSnapshotMapper rsInfoHostSnapshotMapper;
    @Autowired
    private RsDicMapQueryAtomService rsDicMapQueryAtomService;

    public McmpRspPageBo<McmpRspPageDataBo<RsHostSnapshotQueryDataBo>> querySnapshot(RsHostSnapshotQueryPageBusiReqBo reqBo) {
        this.LOGGER.info("\u5feb\u7167\u5217\u8868\u67e5\u8be2busi\u670d\u52a1\uff1a" + reqBo);
        McmpRspPageBo retBo = new McmpRspPageBo();
        McmpRspPageDataBo data = new McmpRspPageDataBo();
        ArrayList<RsHostSnapshotQueryDataBo> rows = new ArrayList<RsHostSnapshotQueryDataBo>();
        retBo.setData((Object)data);
        Page<RsInfoHostSnapshotQueryPo> page = this.getPage(reqBo);
        RsInfoHostSnapshotQueryPo queryPo = new RsInfoHostSnapshotQueryPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryPo);
        List<RsInfoHostSnapshotQueryPo> snapshotPos = this.rsInfoHostSnapshotMapper.selectPageByQuery(queryPo, page);
        if (!CollectionUtils.isEmpty(snapshotPos)) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            for (RsInfoHostSnapshotQueryPo snapshotPo : snapshotPos) {
                RsHostSnapshotQueryDataBo dataBo = new RsHostSnapshotQueryDataBo();
                BeanUtils.copyProperties((Object)snapshotPo, (Object)dataBo);
                dataBo.setSnapshotStatusName(dicMap.get("RS_INFO_HOST_SNAPSHOT_STATUS").get(dataBo.getSnapshotStatus().toString()));
                dataBo.setSnapshotTypeName(dicMap.get("RS_INFO_HOST_SNAPSHOT_TYPE").get(dataBo.getSnapshotType().toString()));
                rows.add(dataBo);
            }
        }
        data.setRows(rows);
        data.setPageNo(Integer.valueOf(page.getPageNo()));
        data.setTotal(Integer.valueOf(page.getTotalPages()));
        data.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private Page<RsInfoHostSnapshotQueryPo> getPage(RsHostSnapshotQueryPageBusiReqBo reqBo) {
        Page page;
        if (reqBo.getPageNo() != 1) {
            page = new Page(reqBo.getPageNo().intValue(), reqBo.getPageSize().intValue());
        } else {
            page = new Page();
            BeanUtils.copyProperties((Object)reqBo, (Object)page);
            if (reqBo.getPageNo() < 1) {
                page.setPageNo(1);
            }
            if (reqBo.getPageSize() < 1) {
                page.setPageSize(10);
            }
        }
        return page;
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> codes = new ArrayList<String>();
        codes.add("RS_INFO_HOST_SNAPSHOT_TYPE");
        codes.add("RS_INFO_HOST_SNAPSHOT_STATUS");
        RsDicMapQueryAtomReqBo atomReqBo = new RsDicMapQueryAtomReqBo();
        for (String code : codes) {
            atomReqBo.setType(code);
            RsDicMapQueryAtomRspBo atomRetBo = this.rsDicMapQueryAtomService.qryDicMap(atomReqBo);
            dicMap.put(code, atomRetBo.getDicMap());
        }
        return dicMap;
    }
}

