/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceCreateInsService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpAliLoadBalanceCreateReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceCreateInsReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceCreateInsRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsLoadBalanceInsCreateBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalanceInsCreateBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalanceInsCreateBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.RsInfoSlbMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.dao.po.RsInfoSlbPo;
import com.tydic.mcmp.resource.enums.RsSequencesEnum;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import com.tydic.starter.sequence.autoconfiguration.SequenceManagement;
import java.sql.SQLException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="rsLoadBalanceInsCreateBusiService")
public class RsLoadBalanceInsCreateBusiServiceImpl
implements RsLoadBalanceInsCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsLoadBalanceInsCreateBusiServiceImpl.class);
    @Autowired
    private McmpLoadBalanceCreateInsService mcmpLoadBalanceCreateInsService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private RsInfoSlbMapper rsInfoSlbMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;
    @Autowired
    private SequenceManagement sequenceManagement;

    public RsLoadBalanceInsCreateBusiRspBo createSlbIns(RsLoadBalanceInsCreateBusiReqBo reqBo) {
        log.info("\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u521b\u5efa Busi\u670d\u52a1, \u5165\u53c2\uff1a" + reqBo);
        RsLoadBalanceInsCreateBusiRspBo retBo = new RsLoadBalanceInsCreateBusiRspBo();
        this.validateArgs(reqBo);
        McmpLoadBalanceCreateInsRspBo createInsRetBo = this.invokeExtInterface(reqBo);
        log.info("\u5916\u90e8\u63a5\u53e3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)createInsRetBo));
        if (!"0000".equals(createInsRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u521b\u5efa\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u5931\u8d25\uff1a" + createInsRetBo.getRespDesc());
            throw new McmpBusinessException("9000", "\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u521b\u5efa\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u5931\u8d25\uff1a" + createInsRetBo.getRespDesc());
        }
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        Long resourceId = this.insertSlbInfo(reqBo, createInsRetBo);
        this.insertResource(reqBo, resourceId, nowTime, createInsRetBo);
        retBo.setResourceId(resourceId);
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private void insertResource(RsLoadBalanceInsCreateBusiReqBo reqBo, Long resourceId, Date nowTime, McmpLoadBalanceCreateInsRspBo createInsRetBo) {
        RsInfoResourcePo resourcePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)resourcePo);
        resourcePo.setResourceName(createInsRetBo.getLoadBalancerName());
        if (StringUtils.isEmpty((Object)reqBo.getZoneName())) {
            resourcePo.setZoneName(reqBo.getZoneId());
        }
        resourcePo.setResourceId(resourceId);
        resourcePo.setResourceName(createInsRetBo.getLoadBalancerName());
        resourcePo.setServiceId(10L);
        resourcePo.setInstanceId(createInsRetBo.getLoadBalancerId());
        resourcePo.setCreateOper(reqBo.getCreateOper());
        resourcePo.setCreateTime(nowTime);
        resourcePo.setResourceStatus(RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_RUN);
        int result = this.rsInfoResourceMapper.insertSelective(resourcePo);
        if (result < 1) {
            throw new McmpBusinessException("9000", "\u5199\u8d44\u6e90\u4fe1\u606f\u8868\u5931\u8d25");
        }
    }

    private Long insertSlbInfo(RsLoadBalanceInsCreateBusiReqBo reqBo, McmpLoadBalanceCreateInsRspBo createInsRetBo) {
        long resourceId;
        try {
            resourceId = this.sequenceManagement.nextId(RsSequencesEnum.RS_INFO_RESOURCE.toString());
        }
        catch (SQLException e) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u8d44\u6e90ID\u5f02\u5e38\uff1a" + e);
        }
        RsInfoSlbPo slbPo = new RsInfoSlbPo();
        BeanUtils.copyProperties((Object)reqBo, (Object)slbPo);
        slbPo.setResourceId(resourceId);
        slbPo.setInstanceId(createInsRetBo.getLoadBalancerId());
        slbPo.setInstanceName(createInsRetBo.getLoadBalancerName());
        slbPo.setServiceIp(createInsRetBo.getAddress());
        int result = this.rsInfoSlbMapper.insertSelective(slbPo);
        if (result < 1) {
            throw new McmpBusinessException("9000", "\u5199\u8d1f\u8f7d\u5747\u8861\u4fe1\u606f\u8868\u5931\u8d25");
        }
        return resourceId;
    }

    private McmpLoadBalanceCreateInsRspBo invokeExtInterface(RsLoadBalanceInsCreateBusiReqBo reqBo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u7528\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpLoadBalanceCreateInsReqBo createInsReqBo = new McmpLoadBalanceCreateInsReqBo();
        if (2L == reqBo.getPlatformId()) {
            createInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            createInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            createInsReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            createInsReqBo.setProxyHost(atomRetBo.getProxyHost());
            createInsReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            createInsReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            createInsReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            createInsReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        createInsReqBo.setRegion(reqBo.getRegionId());
        createInsReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        McmpAliLoadBalanceCreateReqBo dataBo = new McmpAliLoadBalanceCreateReqBo();
        dataBo.setAddressType(RsInterfaceUtil.RsSlbInstanceTypeConvert(reqBo.getInstanceType()));
        dataBo.setInternetChargeType(RsInterfaceUtil.RsSlbInsChargeTypeConvert(reqBo.getFeeType()));
        dataBo.setBandwidth(reqBo.getWidth());
        dataBo.setLoadBalancerName(reqBo.getInstanceName());
        dataBo.setVpcId(reqBo.getInterchangerId());
        dataBo.setMasterZoneId(reqBo.getZoneId());
        dataBo.setSlaveZoneId(reqBo.getBackZoneId());
        dataBo.setResourceGroupId(reqBo.getResourceGroupId());
        dataBo.setPayType(RsInterfaceUtil.convertSlbPayType(reqBo.getPayType()));
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_DATABASE_PAY_TYPE_MONTH.equals(reqBo.getPayType())) {
            dataBo.setPricingCycle(RsInterfaceUtil.convertTimeUnit(reqBo.getBuyMonth()));
            dataBo.setDuration(Integer.valueOf(RsInterfaceUtil.convertBuyTime(reqBo.getBuyMonth())));
            dataBo.setAutoPay(Boolean.valueOf(false));
        }
        dataBo.setAddressIPVersion(RsInterfaceUtil.convertIpVersion(reqBo.getIpVersion()));
        dataBo.setDeleteProtection("off");
        dataBo.setAddress(reqBo.getServiceIp());
        if (!"slb.share".equals(reqBo.getSpecId())) {
            dataBo.setLoadBalancerSpec(reqBo.getSpecId());
        }
        createInsReqBo.setMcmpAliLoadBalanceCreateReqBo(dataBo);
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u5165\u53c2\uff1a" + createInsReqBo);
        return this.mcmpLoadBalanceCreateInsService.createIns(createInsReqBo);
    }

    private void validateArgs(RsLoadBalanceInsCreateBusiReqBo reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getPlatformId())) {
            throw new McmpBusinessException("9000", "\u5e73\u53f0ID'platformId'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getAccountId())) {
            throw new McmpBusinessException("9000", "\u8d26\u6237ID'accountId'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getRegionId()) && 1L == reqBo.getPlatformId()) {
            throw new McmpBusinessException("9000", "\u5730\u57dfID'regionId'\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getPayType()) && 1L == reqBo.getPlatformId()) {
            throw new McmpBusinessException("9000", "\u4ed8\u8d39\u65b9\u5f0f'payType'\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

