/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.mcmp.resource.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.mcmp.cloud.common.base.exception.McmpBusinessException;
import com.tydic.mcmp.intf.api.loadbalance.McmpLoadBalanceStatusSetService;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceStatusSetReqBo;
import com.tydic.mcmp.intf.api.loadbalance.bo.McmpLoadBalanceStatusSetRspBo;
import com.tydic.mcmp.resource.atom.api.RsQueryAliParamAtomService;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomReqBo;
import com.tydic.mcmp.resource.atom.bo.RsQueryAliParamAtomRspBo;
import com.tydic.mcmp.resource.busi.api.RsLoadBalanceInsStatusSetBusiService;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalanceInsStatusSetBusiReqBo;
import com.tydic.mcmp.resource.busi.api.bo.RsLoadBalanceInsStatusSetBusiRspBo;
import com.tydic.mcmp.resource.constants.RsDictionaryValueConstants;
import com.tydic.mcmp.resource.dao.RsInfoPlatformAcountMapper;
import com.tydic.mcmp.resource.dao.RsInfoResourceMapper;
import com.tydic.mcmp.resource.dao.po.RsInfoResourcePo;
import com.tydic.mcmp.resource.utils.RsInterfaceUtil;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="rsLoadBalanceInsStatusSetBusiService")
public class RsLoadBalanceInsStatusSetBusiServiceImpl
implements RsLoadBalanceInsStatusSetBusiService {
    private static final Logger log = LoggerFactory.getLogger(RsLoadBalanceInsStatusSetBusiServiceImpl.class);
    private static final String ACTIVE = "active";
    private static final String IN_ACTIVE = "inactive";
    @Autowired
    private McmpLoadBalanceStatusSetService mcmpLoadBalanceStatusSetService;
    @Autowired
    private RsQueryAliParamAtomService rsQueryAliParamAtomService;
    @Autowired
    private RsInfoPlatformAcountMapper rsInfoPlatformAcountMapper;
    @Autowired
    private RsInfoResourceMapper rsInfoResourceMapper;

    public RsLoadBalanceInsStatusSetBusiRspBo setInsStatus(RsLoadBalanceInsStatusSetBusiReqBo reqBo) {
        log.info("\u8d1f\u8f7d\u5747\u8861\u5b9e\u4f8b\u72b6\u6001\u8bbe\u7f6ebusi\u670d\u52a1\uff0c\u5165\u53c2\uff1a" + reqBo);
        RsLoadBalanceInsStatusSetBusiRspBo retBo = new RsLoadBalanceInsStatusSetBusiRspBo();
        RsInfoResourcePo resourcePo = this.rsInfoResourceMapper.selectByPrimaryKey(reqBo.getResourceId());
        if (resourcePo == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u8d44\u6e90ID\uff08" + reqBo.getResourceId() + "\uff09\u7684\u76f8\u5173\u4fe1\u606f");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u8d44\u6e90ID\uff08" + reqBo.getResourceId() + "\uff09\u7684\u76f8\u5173\u4fe1\u606f");
            return retBo;
        }
        McmpLoadBalanceStatusSetRspBo invokeRetBo = this.invokeInterface(reqBo, resourcePo);
        log.info("\u5916\u90e8\u63a5\u53e3\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)invokeRetBo));
        if (!"0000".equals(invokeRetBo.getRespCode())) {
            log.error("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u8bbe\u7f6e\u5b9e\u4f8b\u72b6\u6001\u5931\u8d25\uff1a" + invokeRetBo.getRespDesc());
            BeanUtils.copyProperties((Object)invokeRetBo, (Object)retBo);
            return retBo;
        }
        boolean isSuccess = this.updateResourceInfo(reqBo, retBo);
        if (!isSuccess) {
            return retBo;
        }
        retBo.setRespCode("0000");
        retBo.setRespDesc("\u6210\u529f");
        return retBo;
    }

    private boolean updateResourceInfo(RsLoadBalanceInsStatusSetBusiReqBo reqBo, RsLoadBalanceInsStatusSetBusiRspBo retBo) {
        RsInfoResourcePo updatePo = new RsInfoResourcePo();
        BeanUtils.copyProperties((Object)reqBo, (Object)updatePo);
        Date nowTime = this.rsInfoPlatformAcountMapper.getDbDate();
        updatePo.setUpdateOper(reqBo.getOperatorId());
        updatePo.setUpdateTime(nowTime);
        updatePo.setResourceStatus(reqBo.getAction());
        int result = this.rsInfoResourceMapper.updateByPrimaryKeySelective(updatePo);
        if (result < 1) {
            log.error("\u66f4\u65b0\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            retBo.setRespCode("8887");
            retBo.setRespDesc("\u66f4\u65b0\u8d44\u6e90\u4fe1\u606f\u8868\u8fd4\u56de\u503c\u5c0f\u4e8e1");
            return false;
        }
        return true;
    }

    private McmpLoadBalanceStatusSetRspBo invokeInterface(RsLoadBalanceInsStatusSetBusiReqBo reqBo, RsInfoResourcePo resourcePo) {
        RsQueryAliParamAtomReqBo atomReqBo = new RsQueryAliParamAtomReqBo();
        atomReqBo.setAccountId(reqBo.getAccountId());
        atomReqBo.setPlatformId(reqBo.getPlatformId());
        RsQueryAliParamAtomRspBo atomRetBo = this.rsQueryAliParamAtomService.queryAliParam(atomReqBo);
        if (!"0000".equals(atomRetBo.getRespCode())) {
            throw new McmpBusinessException("9000", "\u83b7\u53d6\u7528\u6237\u53c2\u6570\u5931\u8d25\uff1a" + atomRetBo.getRespDesc());
        }
        McmpLoadBalanceStatusSetReqBo invokeReqBo = new McmpLoadBalanceStatusSetReqBo();
        if (2L == reqBo.getPlatformId()) {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setEndpointPriv(atomRetBo.getEndpoint());
            invokeReqBo.setProxyHost(atomRetBo.getProxyHost());
            invokeReqBo.setProxyPort(atomRetBo.getProxyPort());
        } else {
            invokeReqBo.setAccessKeyId(atomRetBo.getAccessKeyId());
            invokeReqBo.setAccessKeySecret(atomRetBo.getAccessKeySecret());
            invokeReqBo.setRegion(atomRetBo.getAccountRegionId());
        }
        invokeReqBo.setRegion(resourcePo.getRegionId());
        invokeReqBo.setCloudType(RsInterfaceUtil.convertCloudType(reqBo.getPlatformId()));
        invokeReqBo.setLoadBalancerId(resourcePo.getInstanceId());
        invokeReqBo.setLoadBalancerStatus(ACTIVE);
        if (RsDictionaryValueConstants.RS_INFO_RESOURCE_STATUS_STOP.equals(reqBo.getAction())) {
            invokeReqBo.setLoadBalancerStatus(IN_ACTIVE);
        }
        log.info("\u8c03\u7528\u5916\u90e8\u63a5\u53e3\u7684\u53c2\u6570\u4e3a\uff1a" + JSON.toJSONString((Object)invokeReqBo));
        return this.mcmpLoadBalanceStatusSetService.setStatus(invokeReqBo);
    }
}

